/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.gui.widgets.info_line;

import com.fedpol1.enchantips.gui.widgets.info_line.InfoLine;
import com.fedpol1.enchantips.gui.widgets.info_line.InfoLineContainer;
import com.fedpol1.enchantips.gui.widgets.info_line.InfoMultiLine;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;

public class ScrollableInfoLineContainer
extends InfoLineContainer
implements InfoMultiLine,
class_4068,
class_364 {
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60656((String)"widget/scroller");
    private static final class_2960 SCROLLER_BACKGROUND_TEXTURE = class_2960.method_60656((String)"widget/scroller_background");
    private static final int SCROLLER_WIDTH = 6;
    protected int childColor;
    protected int padding;
    protected int scrollHeight;
    private int scrollbarX;
    private int scrollbarY;
    private int scrollbarHeight;
    private int scrollerY;
    private int scrollerHeight;
    private boolean scrolling;

    public ScrollableInfoLineContainer(int childColor, int padding) {
        super(null);
        this.childColor = childColor;
        this.padding = padding;
        this.scrollHeight = 0;
        this.scrolling = false;
        this.nearestScrollableParent = this;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height / 10 * 10;
        if (this.height < 10) {
            throw new IllegalArgumentException("Height cannot be less than line height.");
        }
    }

    @Override
    public int getWidth() {
        return super.getWidth() - 3;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public boolean scrollerVisible() {
        return this.scrollerHeight < this.scrollbarHeight;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.scrollerVisible()) {
            context.method_52706(class_10799.field_59968, SCROLLER_BACKGROUND_TEXTURE, this.scrollbarX, this.scrollbarY, 6, this.scrollbarHeight);
            context.method_52706(class_10799.field_59968, SCROLLER_TEXTURE, this.scrollbarX, this.scrollerY, 6, this.scrollerHeight);
        }
    }

    @Override
    public void refresh(int index) {
        for (int i = 0; i < this.lines.size(); ++i) {
            ((InfoLine)this.lines.get(i)).refresh(i);
        }
        this.scrollbarHeight = this.getHeight() + 2 * this.padding;
        this.scrollbarX = this.x + this.width + this.padding - 6;
        this.scrollbarY = this.y - this.padding;
        this.scrollerHeight = (int)Math.clamp((float)this.scrollbarHeight * (float)this.getHeight() / (float)super.getHeight(), (float)Math.min(32, this.scrollbarHeight / 4), (float)this.scrollbarHeight);
        this.scrollerY = Math.clamp((long)((int)((float)this.scrollbarY - (float)this.scrollHeight * (float)(this.scrollbarHeight - this.scrollerHeight) / (float)(super.getHeight() - this.getHeight()))), this.scrollbarY, this.scrollbarY + this.scrollbarHeight - this.scrollerHeight);
    }

    public void scroll(int s) {
        int scroll = s * 10;
        InfoLine last = this.getLast();
        int scrollingCapacity = Math.max(0, last.y + last.height - (this.y + this.height));
        this.scrollHeight += Math.clamp((long)scroll, -scrollingCapacity, -this.scrollHeight);
        this.refresh(0);
    }

    private void scrollTo(int destination) {
        float destinationFraction = Math.clamp(((float)destination - (float)this.scrollbarY - (float)this.scrollerHeight / 2.0f) / (float)(this.scrollbarHeight - this.scrollerHeight), 0.0f, 1.0f);
        this.scroll((int)(-(((float)this.scrollHeight + destinationFraction * (float)(super.getHeight() - this.getHeight())) / 10.0f)));
    }

    private boolean isWithinScrollbar(double mouseX, double mouseY) {
        return mouseX >= (double)this.scrollbarX && mouseX < (double)(this.scrollbarX + 6) && mouseY >= (double)this.scrollbarY && mouseY < (double)(this.scrollbarY + this.scrollbarHeight);
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean bl = this.scrolling = click.method_74245() == 0 && this.isWithinScrollbar(click.comp_4798(), click.comp_4799());
        if (this.scrolling) {
            this.scrollTo((int)click.comp_4799());
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (this.scrolling) {
            this.scrollTo((int)click.comp_4799());
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25404(class_11908 input) {
        return super.method_25404(input);
    }

    @Override
    public boolean method_25400(class_11905 input) {
        return super.method_25400(input);
    }
}

