/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.gui.widgets.tiny;

import com.fedpol1.enchantips.EnchantipsClient;
import com.fedpol1.enchantips.gui.widgets.info_line.ColorConfigInfoLine;
import com.fedpol1.enchantips.gui.widgets.tiny.TextField;
import com.fedpol1.enchantips.gui.widgets.tiny.TextSetter;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.class_332;

public class ColorSetter
extends TextSetter<Color> {
    public ColorSetter(int x, int y, ColorConfigInfoLine line, Color color) {
        super(x, y, line, color);
        this.textField = new TextField(this.x + 9, this.y, line, 6, "0123456789abcdefABCDEF");
        this.value = color;
        this.textField.setText(this.getStringValue());
    }

    @Override
    public void readStringValue(String s) {
        try {
            this.value = new Color(Integer.parseInt(s, 16));
        }
        catch (NumberFormatException e) {
            this.value = null;
        }
    }

    @Override
    public String getStringValue() {
        if (this.value == null) {
            return "";
        }
        return String.format(Locale.ROOT, "%06X", ((Color)this.value).getRGB() & 0xFFFFFF);
    }

    @Override
    public int getWidth() {
        return this.textField.getWidth() + 10;
    }

    @Override
    public int getHeight() {
        return 9;
    }

    @Override
    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.textField.setPosition(x + 9, y);
    }

    @Override
    public boolean canTrigger() {
        return true;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.render(context, mouseX, mouseY, delta, EnchantipsClient.id("config/color_setter"));
        if (this.value != null) {
            context.method_25294(this.x + 1, this.y + 1, this.x + 8, this.y + 8, ((Color)this.value).getRGB() & 0xFFFFFF | 0xFF000000);
        }
        this.textField.render(context, mouseX, mouseY, delta);
    }
}

