/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.gui.widgets.tiny;

import com.fedpol1.enchantips.EnchantipsClient;
import com.fedpol1.enchantips.gui.widgets.info_line.IntegerConfigInfoLine;
import com.fedpol1.enchantips.gui.widgets.tiny.TextField;
import com.fedpol1.enchantips.gui.widgets.tiny.TextSetter;
import net.minecraft.class_332;

public class IntegerSetter
extends TextSetter<Integer> {
    public IntegerSetter(int x, int y, IntegerConfigInfoLine line, Integer value) {
        super(x, y, line, value);
        this.textField = new TextField(this.x, this.y, line, line.getMaximumDigits(), "-0123456789");
        this.textField.setText(this.getStringValue());
    }

    @Override
    public void readStringValue(String s) {
        try {
            this.value = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.value = null;
        }
    }

    @Override
    public String getStringValue() {
        if (this.value == null) {
            return "";
        }
        return Integer.toString((Integer)this.value);
    }

    @Override
    public int getWidth() {
        return this.textField.getWidth() + 2;
    }

    @Override
    public int getHeight() {
        return 9;
    }

    @Override
    public void setValue(int i) {
        this.value = i;
        this.textField.setText(this.getStringValue());
    }

    @Override
    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.textField.setPosition(x + 1, y);
    }

    @Override
    public boolean canTrigger() {
        return true;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.render(context, mouseX, mouseY, delta, EnchantipsClient.id("config/integer_setter"));
        this.textField.render(context, mouseX, mouseY, delta);
    }
}

