/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.gui.widgets.tiny;

import com.fedpol1.enchantips.EnchantipsClient;
import com.fedpol1.enchantips.gui.widgets.info_line.ConfigInfoLine;
import com.fedpol1.enchantips.gui.widgets.tiny.BaseSetter;
import com.google.common.base.CharMatcher;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3728;
import net.minecraft.class_5348;

public class TextField
extends BaseSetter<ConfigInfoLine<?>, String> {
    protected String text = "";
    protected class_3728 selectionManager = new class_3728(this::getText, this::setText, class_3728.method_27550((class_310)class_310.method_1551()), class_3728.method_27561((class_310)class_310.method_1551()), s -> CharMatcher.anyOf((CharSequence)this.allowedCharacters).matchesAllOf((CharSequence)s));
    protected int maximumLength;
    protected String allowedCharacters;
    protected boolean focused;

    public TextField(int x, int y, ConfigInfoLine<?> line, int maximumLength, String allowedCharacters) {
        super(x, y, line);
        this.maximumLength = maximumLength;
        this.allowedCharacters = allowedCharacters;
        this.focused = false;
    }

    @Override
    public int getWidth() {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int maxWidth = 0;
        for (char c : this.allowedCharacters.toCharArray()) {
            maxWidth = Math.max(maxWidth, textRenderer.method_27525((class_5348)class_2561.method_43470((String)Character.toString((int)c))));
        }
        return maxWidth * this.maximumLength + 1;
    }

    @Override
    public int getHeight() {
        return 9;
    }

    @Override
    public boolean canTrigger() {
        return true;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String s) {
        this.text = s;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        int sectionEndPos;
        class_327 textRenderer = class_310.method_1551().field_1772;
        int textWidth = textRenderer.method_27525((class_5348)class_2561.method_43470((String)this.text));
        int sectionStartPos = textRenderer.method_27525((class_5348)class_2561.method_43470((String)this.text.substring(this.selectionManager.method_16201())));
        String selectionPath = sectionStartPos < (sectionEndPos = textRenderer.method_27525((class_5348)class_2561.method_43470((String)this.text.substring(this.selectionManager.method_16203())))) ? "selection" : "selection_alt";
        int width = this.getWidth();
        if (this.focused) {
            context.method_52706(class_10799.field_59968, EnchantipsClient.id(selectionPath), this.x - 1 + width - Math.max(sectionStartPos, sectionEndPos), this.y, 1 + Math.abs(sectionEndPos - sectionStartPos), 9);
        }
        context.method_51439(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)this.text), this.x + width - textWidth, this.y + 1, -1, false);
    }

    @Override
    public boolean mouseClicked(class_11909 click, boolean doubled) {
        return false;
    }

    @Override
    public boolean keyPressed(class_11908 input) {
        if (!this.focused) {
            return false;
        }
        if (this.selectionManager.method_16202(input)) {
            this.shiftText();
            return true;
        }
        return false;
    }

    @Override
    public boolean charTyped(class_11905 input) {
        if (!this.focused) {
            return false;
        }
        if (this.selectionManager.method_16199(input)) {
            this.shiftText();
            return true;
        }
        return false;
    }

    private void shiftText() {
        int deletePosition = 0;
        int deleteLength = Math.max(0, this.text.length() - this.maximumLength);
        if (this.selectionManager.method_16201() < this.text.length()) {
            deletePosition = this.selectionManager.method_16201();
        }
        int deleteLengthAtStart = Math.max(0, deletePosition + deleteLength - this.text.length());
        deleteLength -= deleteLengthAtStart;
        if (this.text.length() > this.maximumLength) {
            this.text = this.text.substring(deleteLengthAtStart, deletePosition) + this.text.substring(deletePosition + deleteLength);
            this.selectionManager.method_27548(Math.min(this.text.length(), this.selectionManager.method_16201()), Math.min(this.text.length(), this.selectionManager.method_16203()));
        }
    }
}

