/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.util;

import com.fedpol1.enchantips.EnchantipsClient;
import com.fedpol1.enchantips.accessor.EnchantmentAccess;
import com.fedpol1.enchantips.config.ModOption;
import com.fedpol1.enchantips.resources.SymbolSet;
import com.fedpol1.enchantips.resources.Symbols;
import com.fedpol1.enchantips.util.EnchantmentLevel;
import com.fedpol1.enchantips.util.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9636;

public class EnchantmentAppearanceHelper {
    public static class_2561 getName(EnchantmentLevel enchLevel) {
        class_5250 symbolText;
        int colorFinal = enchLevel.getColor().getRGB();
        class_638 world = class_310.method_1551().field_1687;
        class_5321<class_1887> key = enchLevel.getKey();
        class_1887 ench = enchLevel.getEnchantment();
        if (ench == null) {
            return class_2561.method_43473();
        }
        int level = enchLevel.getLevel();
        int r = ench.method_58446();
        class_5250 enchantmentText = class_5250.method_43477((class_7417)ench.comp_2686().method_10851());
        class_5250 finalText = class_2561.method_43470((String)"");
        if (ModOption.SWATCHES_SWITCH.getValue().booleanValue()) {
            colorFinal = ModOption.SWATCHES_FALLBACK_COLOR.getValue().getRGB();
        }
        enchantmentText.method_10862(class_2583.field_24360.method_36139(colorFinal));
        if (level != 1 || ench.method_8183() != 1) {
            enchantmentText.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + level)));
        }
        if (ModOption.MAXIMUM_ENCHANTMENT_LEVEL_SWITCH.getValue().booleanValue()) {
            class_5250 maxLevelText = class_2561.method_43470((String)"/").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + enchLevel.getEnchantment().method_8183())));
            if (level == ench.method_8183()) {
                if (ModOption.MAXIMUM_ENCHANTMENT_LEVEL_SWITCH_AT_MAX.getValue().booleanValue()) {
                    enchantmentText.method_10852((class_2561)maxLevelText);
                }
            } else if (level > ench.method_8183()) {
                if (ModOption.MAXIMUM_ENCHANTMENT_LEVEL_SWITCH_OVER_MAX.getValue().booleanValue()) {
                    enchantmentText.method_10852((class_2561)maxLevelText);
                }
            } else {
                enchantmentText.method_10852((class_2561)maxLevelText);
            }
        }
        if (ModOption.SWATCHES_SWITCH.getValue().booleanValue()) {
            finalText.method_10852((class_2561)Symbols.get(EnchantipsClient.id("swatch")).method_27661().method_54663(enchLevel.getColor().getRGB())).method_27693(" ");
        }
        if (ModOption.ANVIL_COST_SWITCH.getValue().booleanValue()) {
            finalText.method_10852((class_2561)TooltipHelper.buildAnvilCost(r, colorFinal)).method_27693(" ");
        }
        if (ModOption.ENCHANTMENT_TAGS_SWITCH.getValue().booleanValue() && world != null) {
            symbolText = EnchantmentAppearanceHelper.getEnchantmentTagSymbolText(key, world.method_30349());
            finalText.method_10852((class_2561)symbolText).method_54663(colorFinal);
            if (!symbolText.getString().isEmpty()) {
                finalText.method_27693(" ");
            }
        }
        if (ModOption.ENCHANTMENT_TARGETS_SWITCH.getValue().booleanValue() && world != null) {
            symbolText = EnchantmentAppearanceHelper.getEnchantmentTargetSymbolText(key, world.method_30349());
            finalText.method_10852((class_2561)symbolText).method_54663(colorFinal);
            if (!symbolText.getString().isEmpty()) {
                finalText.method_27693(" ");
            }
        }
        return finalText.method_10852((class_2561)enchantmentText);
    }

    public static class_5250 getEnchantmentTagSymbolText(class_5321<class_1887> key, class_5455 registryManager) {
        List<Object> finalSymbols;
        SymbolSet symbolSet = Symbols.getSet("tags");
        Optional enchantmentReference = registryManager.method_30530(class_7924.field_41265).method_10223(key.method_29177());
        if (enchantmentReference.isPresent()) {
            finalSymbols = symbolSet.getApplicableSymbols(((class_6880.class_6883)enchantmentReference.get()).method_40228().map(class_6862::comp_327).toList(), symbolSet.miscSymbol);
        } else {
            List<Object> list = finalSymbols = symbolSet.unknownSymbol.isEmpty() ? List.of() : List.of(symbolSet.unknownSymbol.get());
        }
        if (finalSymbols.size() > ModOption.ENCHANTMENT_TAGS_LIMIT.getValue()) {
            List<Object> list = finalSymbols = symbolSet.allSymbol.isEmpty() ? List.of() : List.of(symbolSet.allSymbol.get());
        }
        if (finalSymbols.isEmpty()) {
            finalSymbols = symbolSet.noneSymbol.isEmpty() ? List.of() : List.of(symbolSet.noneSymbol.get());
        }
        return EnchantmentAppearanceHelper.beautifySymbolList(finalSymbols);
    }

    public static class_5250 getEnchantmentTargetSymbolText(class_5321<class_1887> key, class_5455 registryManager) {
        SymbolSet symbolSet = Symbols.getSet("items");
        class_1887 ench = (class_1887)registryManager.method_30530(class_7924.field_41265).method_46747(key).comp_349();
        class_6885<class_1792> primaryItems = ((EnchantmentAccess)ench).enchantips$getPrimaryItems();
        class_6885<class_1792> secondaryItems = ((EnchantmentAccess)ench).enchantips$getSecondaryItems();
        class_6885.class_6886 filteredPrimaryItems = class_6885.method_40242(primaryItems.method_40239().filter(i -> EnchantmentAppearanceHelper.canBePrimaryItem((class_1792)class_7923.field_41178.method_63535(((class_5321)i.method_40230().get()).method_29177()), key, primaryItems)).toList());
        class_6885.class_6886 filteredSecondaryItems = class_6885.method_40242(secondaryItems.method_40239().filter(arg_0 -> EnchantmentAppearanceHelper.lambda$getEnchantmentTargetSymbolText$1((class_6885)filteredPrimaryItems, arg_0)).toList());
        List<Object> primarySymbols = symbolSet.getApplicableSymbols(filteredPrimaryItems.method_40239().map(i -> ((class_5321)i.method_40230().get()).method_29177()).toList(), symbolSet.miscSymbol);
        List<Object> secondarySymbols = symbolSet.getApplicableSymbols(filteredSecondaryItems.method_40239().map(i -> ((class_5321)i.method_40230().get()).method_29177()).toList(), symbolSet.miscSymbol);
        if (primarySymbols.size() > ModOption.ENCHANTMENT_TARGETS_LIMIT.getValue()) {
            List<Object> list = primarySymbols = symbolSet.allSymbol.isEmpty() ? List.of() : List.of(symbolSet.allSymbol.get());
        }
        if (secondarySymbols.size() > ModOption.ENCHANTMENT_TARGETS_LIMIT.getValue()) {
            secondarySymbols = symbolSet.allSymbol.isEmpty() ? List.of() : List.of(symbolSet.allSymbol.get());
        }
        ArrayList<Object> finalSymbols = new ArrayList<class_2960>();
        finalSymbols.addAll(primarySymbols);
        if (!secondarySymbols.isEmpty()) {
            finalSymbols.add(EnchantipsClient.id("anvil"));
        }
        finalSymbols.addAll(secondarySymbols);
        if (finalSymbols.isEmpty()) {
            finalSymbols = symbolSet.noneSymbol.isEmpty() ? new ArrayList() : new ArrayList<class_2960>(List.of(symbolSet.noneSymbol.get()));
        }
        return EnchantmentAppearanceHelper.beautifySymbolList(finalSymbols);
    }

    public static boolean canBePrimaryItem(class_1792 item, class_5321<class_1887> key, class_6885<class_1792> primaryItems) {
        class_638 w = class_310.method_1551().field_1687;
        if (w == null) {
            return false;
        }
        class_6880.class_6883 entry = w.method_30349().method_30530(class_7924.field_41265).method_46747(key);
        Optional entryList = w.method_30349().method_30530(class_7924.field_41265).method_46733(class_9636.field_51547);
        if (entryList.isEmpty()) {
            return false;
        }
        if (!((class_6885.class_6888)entryList.get()).method_40241((class_6880)entry)) {
            return false;
        }
        String itemId = class_7923.field_41178.method_47983((Object)item).method_55840();
        return primaryItems.method_40239().map(class_6880::method_55840).anyMatch(c -> c.equals(itemId));
    }

    public static class_5250 beautifySymbolList(List<class_2960> symbols) {
        if (symbols == null || symbols.isEmpty()) {
            return class_2561.method_43473();
        }
        class_5250 finalText = class_2561.method_43473();
        finalText.method_10852(Symbols.get(symbols.getFirst()));
        symbols.subList(1, symbols.size()).forEach(fs -> finalText.method_10852(Symbols.SPACE).method_10852(Symbols.get(fs)));
        return finalText;
    }

    private static /* synthetic */ boolean lambda$getEnchantmentTargetSymbolText$1(class_6885 filteredPrimaryItems, class_6880 e) {
        return !filteredPrimaryItems.method_40241(e);
    }
}

