/*
 * Decompiled with CFR 0.152.
 */
package com.fedpol1.enchantips.util;

import com.fedpol1.enchantips.config.ModConfigData;
import com.fedpol1.enchantips.config.ModOption;
import com.fedpol1.enchantips.config.tree.EnchantmentGroupNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1132;
import net.minecraft.class_1887;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;

public class EnchantmentLevel
implements Comparable<EnchantmentLevel> {
    private final class_5321<class_1887> key;
    private final int level;

    private EnchantmentLevel(class_5321<class_1887> e, int l) {
        this.key = e;
        this.level = l;
    }

    public static EnchantmentLevel of(class_1887 e, int l) throws IllegalStateException {
        class_638 w = class_310.method_1551().field_1687;
        if (w == null) {
            throw new IllegalStateException("Could not construct EnchantmentLevel: world is null.");
        }
        Optional optional = w.method_30349().method_30530(class_7924.field_41265).method_29113((Object)e);
        if (optional.isEmpty()) {
            class_1132 s = class_310.method_1551().method_1576();
            if (s == null) {
                throw new IllegalStateException("Could not construct EnchantmentLevel: client enchantment optional is empty & no integrated server exists.");
            }
            if ((w = s.method_3847(w.method_27983())) == null) {
                throw new IllegalStateException("Could not construct EnchantmentLevel: client enchantment optional is empty & server world is null.");
            }
            optional = w.method_30349().method_30530(class_7924.field_41265).method_29113((Object)e);
            if (optional.isEmpty()) {
                throw new IllegalStateException("Could not construct EnchantmentLevel: client & server enchantment optionals are both empty.");
            }
        }
        return new EnchantmentLevel((class_5321<class_1887>)((class_5321)optional.get()), l);
    }

    public static ArrayList<EnchantmentLevel> ofList(class_9304 component) {
        ArrayList<EnchantmentLevel> enchantments = new ArrayList<EnchantmentLevel>();
        if (component == null) {
            return enchantments;
        }
        for (class_6880 entry : component.method_57534()) {
            class_1887 enchantment = (class_1887)entry.comp_349();
            if (enchantment == null) continue;
            enchantments.add(EnchantmentLevel.of(enchantment, component.method_57536(entry)));
        }
        return enchantments;
    }

    public class_5321<class_1887> getKey() {
        return this.key;
    }

    public class_1887 getEnchantment() {
        class_638 w = class_310.method_1551().field_1687;
        if (w == null) {
            return null;
        }
        return (class_1887)w.method_30349().method_30530(class_7924.field_41265).method_29107(this.key);
    }

    public int getLevel() {
        return this.level;
    }

    public Color getColor() {
        class_1887 ench = this.getEnchantment();
        EnchantmentGroupNode gn = ModConfigData.get(this.getKey());
        if (ench == null) {
            return gn.getMinColor().getValue();
        }
        if (this.getLevel() > ench.method_8183()) {
            return gn.getOvermaxColor().getValue();
        }
        float intensity = 1.0f - (float)(ench.method_8183() - this.getLevel()) / Math.max(1.0f, (float)(ench.method_8183() - ench.method_8187()));
        intensity = Math.min(1.0f, Math.max(0.0f, intensity));
        int rgbMin = gn.getMinColor().getValue().getRGB();
        int rgbMax = gn.getMaxColor().getValue().getRGB();
        int r1 = (rgbMin & 0xFF0000) >> 16;
        int r2 = (rgbMax & 0xFF0000) >> 16;
        int g1 = (rgbMin & 0xFF00) >> 8;
        int g2 = (rgbMax & 0xFF00) >> 8;
        int b1 = rgbMin & 0xFF;
        int b2 = rgbMax & 0xFF;
        r1 += (int)((float)(r2 - r1) * intensity);
        g1 += (int)((float)(g2 - g1) * intensity);
        b1 += (int)((float)(b2 - b1) * intensity);
        return new Color((r1 << 16) + (g1 << 8) + b1);
    }

    public int getLowestModifiedLevel() {
        return this.getEnchantment().method_8182(this.getLevel());
    }

    public int getHighestModifiedLevel() {
        if (this.getEnchantment().method_8183() > this.getLevel()) {
            return Math.min(this.getEnchantment().method_20742(this.getLevel()), this.getEnchantment().method_8182(this.getLevel() + 1) - 1);
        }
        return this.getEnchantment().method_20742(this.getLevel());
    }

    public boolean isOvermax() {
        return this.level > this.getEnchantment().method_8183();
    }

    @Override
    public int compareTo(EnchantmentLevel other) {
        if (ModOption.PRIORITIZE_OVERLEVELLED_ENCHANTMENTS.getValue().booleanValue() && this.isOvermax() ^ other.isOvermax()) {
            return this.isOvermax() ? -1 : 1;
        }
        int comparison = ModConfigData.getEnchantmentOrder(this.getKey()) - ModConfigData.getEnchantmentOrder(other.getKey());
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.getEnchantment().comp_2686().getString().compareTo(other.getEnchantment().comp_2686().getString());
        if (comparison != 0) {
            return comparison;
        }
        return this.getLevel() - other.getLevel();
    }
}

