/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.task.CompositeTasks;
import aqario.fowlplay.common.entity.ai.brain.task.FlightTasks;
import aqario.fowlplay.common.entity.ai.brain.task.SetEntityLookTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetPerchWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetRandomFlightTargetTask;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class HawkEntity
extends TrustingBirdEntity
implements BirdBrain<HawkEntity> {
    public final class_7094 standingState = new class_7094();
    public final class_7094 glidingState = new class_7094();
    public final class_7094 floatingState = new class_7094();
    private int timeSinceLastFlap = this.getFlapFrequency();
    private int flapTime = 0;

    public HawkEntity(class_1299<? extends HawkEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public int getFlapFrequency() {
        return 100;
    }

    public static class_5132.class_5133 createHawkAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23719, (double)0.225f).method_26868(class_5134.field_23720, (double)0.24f);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.7f;
    }

    @Override
    public int getMaxPitchChange() {
        return 18;
    }

    @Override
    public int getMaxYawChange() {
        return 18;
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)40, (Object)48);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
    }

    public boolean method_6109() {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.HAWK_FOOD);
    }

    @Override
    public boolean shouldAvoid(class_1309 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.HAWK_AVOIDS);
    }

    @Override
    public boolean canHunt(class_1309 target) {
        return target.method_5864().method_20210(FowlPlayEntityTypeTags.HAWK_HUNT_TARGETS) || target.method_5864().method_20210(FowlPlayEntityTypeTags.HAWK_BABY_HUNT_TARGETS) && target.method_6109();
    }

    @Override
    public boolean shouldAttack(class_1309 target) {
        if (this.hasLowHealth()) {
            return false;
        }
        Optional hurtBy = this.method_18868().method_18904(class_4140.field_18452);
        return hurtBy.isPresent() && ((class_1309)hurtBy.get()).equals((Object)target);
    }

    public boolean method_6049(class_1293 effect) {
        return effect.method_5579() != class_1294.field_5903 && super.method_6049(effect);
    }

    @Override
    public void updateAnimations() {
        this.standingState.method_45317(!this.isFlying() && !this.method_5816(), this.field_6012);
        this.glidingState.method_45317(this.isFlying(), this.field_6012);
        if (this.isFlying()) {
            if (this.timeSinceLastFlap > this.getFlapFrequency()) {
                this.timeSinceLastFlap = 0;
                ++this.flapTime;
            } else if (this.isCurrentlyFlapping()) {
                ++this.flapTime;
            } else {
                ++this.timeSinceLastFlap;
                this.flapTime = 0;
            }
        } else {
            this.timeSinceLastFlap = this.getFlapFrequency();
            this.flapTime = 0;
        }
        this.floatingState.method_45317(!this.isFlying() && this.method_5816(), this.field_6012);
    }

    private boolean isCurrentlyFlapping() {
        return this.flapTime > 0 && this.flapTime < 60;
    }

    protected boolean method_5776() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.8f;
    }

    @Override
    public float getFlapPitch() {
        return 0.6f;
    }

    @Override
    public float getWaterline() {
        return 0.5f;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return FowlPlaySoundEvents.ENTITY_HAWK_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().hawkCallVolume;
    }

    @Override
    public int getCallDelay() {
        return 800;
    }

    @Override
    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_HAWK_HURT.get();
    }

    protected class_4095.class_5303<HawkEntity> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends HawkEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor().setScanRate(bird -> 10), new AvoidTargetSensor().setScanRate(bird -> 10), new AttackTargetSensor()});
    }

    public BrainActivityGroup<? extends HawkEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new class_4097[]{new FloatToSurfaceOfFluid().riseChance(0.5f), FlightTasks.stopFalling(), new SetAttackTarget(), SetEntityLookTargetTask.create(Birds::isPlayerHoldingFood), new LookAtTarget().runFor(entity -> entity.method_6051().method_39332(45, 90)), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends HawkEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new class_4097[]{CompositeTasks.setAvoidEntityWalkTarget()});
    }

    public BrainActivityGroup<? extends HawkEntity> getFightTasks() {
        return BirdBrain.fightActivity(new class_4097[]{new InvalidateAttackTarget(), FlightTasks.startFlying(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(0)});
    }

    @Override
    public BrainActivityGroup<? extends HawkEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new class_4097[]{CompositeTasks.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends HawkEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new class_4097[]{CompositeTasks.setNearestFoodWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends HawkEntity> getRestTasks() {
        return BirdBrain.restActivity(new class_4097[]{new SetPerchWalkTargetTask().startCondition(Predicate.not(Birds::isPerched)), CompositeTasks.idleIfPerched()});
    }

    @Override
    public BrainActivityGroup<? extends HawkEntity> getSoarTasks() {
        return BirdBrain.soarActivity(new class_4097[]{new SetRandomFlightTargetTask().startCondition(entity -> !BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_18445))});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.RAPTOR.get();
    }

    protected void method_5958() {
        class_4095 brain = this.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        this.tickBrain((class_1309)this);
        if (activity == class_4168.field_22396 && brain.method_24538().orElse(null) != class_4168.field_22396) {
            brain.method_24525(class_4140.field_30246, (Object)true, 2400L);
        }
        super.method_5958();
    }
}

