/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.task.CompositeTasks;
import aqario.fowlplay.common.entity.ai.brain.task.FlightTasks;
import aqario.fowlplay.common.entity.ai.brain.task.SetEntityLookTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetPerchWalkTargetTask;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayActivities;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4168;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.Nullable;

public class BlueJayEntity
extends FlyingBirdEntity
implements BirdBrain<BlueJayEntity> {
    public final class_7094 standingState = new class_7094();
    public final class_7094 glidingState = new class_7094();
    public final class_7094 flappingState = new class_7094();
    public final class_7094 floatingState = new class_7094();

    public BlueJayEntity(class_1299<? extends BirdEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, -1.0f);
        this.method_5941(class_7.field_36432, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.BLUE_JAY_FOOD);
    }

    @Override
    public boolean shouldAvoid(class_1309 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.BLUE_JAY_AVOIDS);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    @Override
    public int getFlapFrequency() {
        return 7;
    }

    @Override
    protected void updateAnimations() {
        this.standingState.method_45317(!this.isFlying() && !this.method_5816(), this.field_6012);
        this.flappingState.method_45317(this.isFlying(), this.field_6012);
        this.floatingState.method_45317(!this.isFlying() && this.method_5816(), this.field_6012);
    }

    protected boolean method_5776() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.5f;
    }

    @Override
    public float getFlapPitch() {
        return 1.0f;
    }

    @Override
    public float getWaterline() {
        return 0.45f;
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return FowlPlaySoundEvents.ENTITY_BLUE_JAY_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().blueJayCallVolume;
    }

    @Override
    public int getCallDelay() {
        return 480;
    }

    @Override
    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_BLUE_JAY_HURT.get();
    }

    protected class_4095.class_5303<BlueJayEntity> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends BlueJayEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor().setScanRate(bird -> 10), new AvoidTargetSensor().setScanRate(bird -> 10)});
    }

    public BrainActivityGroup<? extends BlueJayEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new class_4097[]{new FloatToSurfaceOfFluid(), FlightTasks.stopFalling(), SetEntityLookTargetTask.create(Birds::isPlayerHoldingFood), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new class_4097[]{CompositeTasks.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getForageTasks() {
        return BirdBrain.forageActivity(new class_4097[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeTasks.tryForage(), CompositeTasks.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new class_4097[]{CompositeTasks.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new class_4097[]{CompositeTasks.setNearestFoodWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends BlueJayEntity> getRestTasks() {
        return BirdBrain.restActivity(new class_4097[]{new SetPerchWalkTargetTask().startCondition(Predicate.not(Birds::isPerched)), CompositeTasks.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    public class_4168 getDefaultActivity() {
        return FowlPlayActivities.PERCH.get();
    }

    protected void method_5958() {
        this.tickBrain((class_1309)this);
        super.method_5958();
    }
}

