/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.PigeonVariant;
import aqario.fowlplay.common.entity.TameableBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.PigeonSpecificSensor;
import aqario.fowlplay.common.entity.ai.brain.task.CompositeTasks;
import aqario.fowlplay.common.entity.ai.brain.task.DeliverBundleTask;
import aqario.fowlplay.common.entity.ai.brain.task.FlightTasks;
import aqario.fowlplay.common.entity.ai.brain.task.LeaderlessFlockTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetEntityLookTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetOwnerTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetPerchWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.TeleportToTargetTask;
import aqario.fowlplay.common.entity.ai.pathing.GroundNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayActivities;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.FowlPlayRegistryKeys;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.FowlPlayTrackedDataHandlerRegistry;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4168;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5537;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7988;
import net.minecraft.class_9334;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class PigeonEntity
extends TameableBirdEntity
implements BirdBrain<PigeonEntity>,
class_7988<class_6880<PigeonVariant>>,
Flocking {
    private static final class_2940<Optional<UUID>> RECIPIENT = class_2945.method_12791(PigeonEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_6880<PigeonVariant>> VARIANT = class_2945.method_12791(PigeonEntity.class, FowlPlayTrackedDataHandlerRegistry.PIGEON_VARIANT);
    public final class_7094 standingState = new class_7094();
    public final class_7094 glidingState = new class_7094();
    public final class_7094 flappingState = new class_7094();
    public final class_7094 floatingState = new class_7094();
    public final class_7094 sittingState = new class_7094();

    public PigeonEntity(class_1299<? extends PigeonEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -3.0f);
        this.method_5941(class_7.field_4, 12.0f);
        this.method_5941(class_7.field_36432, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        float f = world.method_8409().method_43057();
        if (f < 0.5f) {
            FowlPlayRegistries.PIGEON_VARIANT.method_40264(PigeonVariant.BANDED).ifPresent(this::setVariant);
        } else if (f < 0.75f) {
            FowlPlayRegistries.PIGEON_VARIANT.method_40264(PigeonVariant.CHECKERED).ifPresent(this::setVariant);
        } else if (f < 0.95f) {
            FowlPlayRegistries.PIGEON_VARIANT.method_40264(PigeonVariant.GRAY).ifPresent(this::setVariant);
        } else if (f < 0.99f) {
            FowlPlayRegistries.PIGEON_VARIANT.method_40264(PigeonVariant.RUSTY).ifPresent(this::setVariant);
        } else {
            FowlPlayRegistries.PIGEON_VARIANT.method_40264(PigeonVariant.WHITE).ifPresent(this::setVariant);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        this.method_5946(class_1304.field_6173, 1.0f);
        this.method_5946(class_1304.field_6171, 1.0f);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RECIPIENT, Optional.empty());
        builder.method_56912(VARIANT, (Object)FowlPlayRegistries.PIGEON_VARIANT.method_40290(PigeonVariant.BANDED));
    }

    public class_6880<PigeonVariant> getVariant() {
        return (class_6880)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(class_6880<PigeonVariant> variant) {
        this.field_6011.method_12778(VARIANT, variant);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("variant", this.getVariant().method_40230().orElse(PigeonVariant.BANDED).method_29177().toString());
        if (this.getRecipientUuid() != null) {
            nbt.method_25927("recipient", this.getRecipientUuid());
        }
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        Optional.ofNullable(class_2960.method_12829((String)nbt.method_10558("variant"))).map(variant -> class_5321.method_29179(FowlPlayRegistryKeys.PIGEON_VARIANT, (class_2960)variant)).flatMap(arg_0 -> FowlPlayRegistries.PIGEON_VARIANT.method_40264(arg_0)).ifPresent(this::setVariant);
        if (nbt.method_25928("recipient")) {
            this.setRecipientUuid(nbt.method_25926("recipient"));
        } else {
            this.setRecipientUuid(null);
        }
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)10, (Object)12);
    }

    @Override
    public float getWaterline() {
        return 0.45f;
    }

    @Override
    public int getFlapFrequency() {
        return 7;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public boolean method_6109() {
        return false;
    }

    public static class_5132.class_5133 createPigeonAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23720, (double)0.26f);
    }

    @Override
    protected class_1408 getLandNavigation() {
        GroundNavigation navigation = new GroundNavigation((class_1308)this, this.method_37908());
        navigation.method_6363(false);
        navigation.method_35139(true);
        navigation.method_6354(false);
        return navigation;
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 playerStack = player.method_5998(hand);
        class_1799 bundleStack = this.method_5998(class_1268.field_5810);
        if (bundleStack.method_7960() && playerStack.method_7909() instanceof class_5537 && playerStack.method_57353().method_57832(class_9334.field_49631) && this.isTamed()) {
            if (!this.method_37908().field_9236) {
                this.method_6122(class_1268.field_5810, playerStack);
                player.method_6122(hand, class_1799.field_8037);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (playerStack.method_7960() && bundleStack.method_7909() instanceof class_5537) {
            if (!this.method_37908().field_9236) {
                player.method_6122(hand, bundleStack);
                this.method_6122(class_1268.field_5810, class_1799.field_8037);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.method_6481(playerStack) && !this.isTamed()) {
            if (!this.method_37908().field_9236) {
                this.method_6475(player, hand, playerStack);
                if (this.field_5974.method_43048(4) == 0) {
                    this.setOwner(player);
                    this.field_6189.method_6340();
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)6);
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.method_24828() && this.isTamed() && this.isOwner((class_1309)player)) {
            if (!this.method_37908().field_9236) {
                this.setSitting(!this.isSitting());
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return !this.isTamed() && this.getFood().method_8093(stack);
    }

    @Override
    public boolean method_18397(class_1799 stack) {
        class_1304 equipmentSlot = this.method_32326(stack);
        if (!this.method_6118(equipmentSlot).method_7960()) {
            return false;
        }
        return equipmentSlot == class_1304.field_6173 || equipmentSlot == class_1304.field_6171 && super.method_18397(stack);
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.PIGEON_FOOD);
    }

    @Override
    public boolean shouldAvoid(class_1309 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.PIGEON_AVOIDS);
    }

    protected void method_16078() {
        super.method_16078();
        this.method_5775(this.method_6118(class_1304.field_6173));
        this.method_5673(class_1304.field_6173, class_1799.field_8037);
        this.method_5775(this.method_6118(class_1304.field_6171));
        this.method_5673(class_1304.field_6171, class_1799.field_8037);
    }

    @Override
    public void updateAnimations() {
        this.standingState.method_45317(!this.isFlying() && !this.method_5816() && !this.isInSittingPose(), this.field_6012);
        this.flappingState.method_45317(this.isFlying(), this.field_6012);
        this.floatingState.method_45317(!this.isFlying() && this.method_5816(), this.field_6012);
        this.sittingState.method_45317(this.isInSittingPose(), this.field_6012);
    }

    protected boolean method_5776() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.65f;
    }

    @Override
    public float getFlapPitch() {
        return 0.9f;
    }

    @Nullable
    public UUID getRecipientUuid() {
        return ((Optional)this.field_6011.method_12789(RECIPIENT)).orElse(null);
    }

    public void setRecipientUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(RECIPIENT, Optional.ofNullable(uuid));
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    @Override
    protected boolean canSing() {
        if (this.method_37908().method_8530()) {
            return false;
        }
        List list = this.method_37908().method_8390(class_1657.class, this.method_53511().method_1009(16.0, 16.0, 16.0), class_1301.field_6155);
        if (list.isEmpty()) {
            return false;
        }
        return super.canSing();
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return FowlPlaySoundEvents.ENTITY_PIGEON_CALL.get();
    }

    @Override
    @Nullable
    protected class_3414 getSongSound() {
        return FowlPlaySoundEvents.ENTITY_PIGEON_SONG.get();
    }

    @Override
    public int getCallDelay() {
        return 120;
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().pigeonCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().pigeonSongVolume;
    }

    @Override
    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_PIGEON_HURT.get();
    }

    @Override
    public boolean isLeader() {
        return false;
    }

    @Override
    public void setLeader() {
    }

    protected class_4095.class_5303<PigeonEntity> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends PigeonEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor().setScanRate(bird -> 10), new AvoidTargetSensor().setScanRate(bird -> 10), new PigeonSpecificSensor()});
    }

    public BrainActivityGroup<? extends PigeonEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new class_4097[]{new FloatToSurfaceOfFluid().riseChance(0.5f), FlightTasks.stopFalling(), new TeleportToTargetTask(), new SetOwnerTargetTask(), SetEntityLookTargetTask.create(Birds::isPlayerHoldingFood), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget().startCondition(entity -> !BrainUtils.hasMemory((class_1309)entity, FowlPlayMemoryModuleType.TELEPORT_TARGET.get())).stopIf(entity -> BrainUtils.hasMemory((class_1309)entity, FowlPlayMemoryModuleType.TELEPORT_TARGET.get()))});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new class_4097[]{CompositeTasks.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getDeliverTasks() {
        return BirdBrain.deliverActivity(new class_4097[]{FlightTasks.stopFlying().startCondition(PigeonEntity::shouldStopFlyingToRecipient), FlightTasks.startFlying().startCondition(PigeonEntity::shouldFlyToRecipient), DeliverBundleTask.run()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getForageTasks() {
        return BirdBrain.forageActivity(new class_4097[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeTasks.tryForage(), CompositeTasks.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new class_4097[]{new LeaderlessFlockTask(5, 0.03f, 0.6f, 0.05f, 3.0f), CompositeTasks.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new class_4097[]{CompositeTasks.setNearestFoodWalkTarget().startCondition(pigeon -> !pigeon.isSitting())});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getRestTasks() {
        return BirdBrain.restActivity(new class_4097[]{new SetPerchWalkTargetTask().startCondition(Predicate.not(Birds::isPerched)), CompositeTasks.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    public class_4168 getDefaultActivity() {
        return FowlPlayActivities.PERCH.get();
    }

    private static boolean shouldFlyToRecipient(PigeonEntity pigeon) {
        UUID recipientUuid = pigeon.method_18868().method_18904(FowlPlayMemoryModuleType.RECIPIENT.get()).orElse(null);
        if (recipientUuid == null) {
            return false;
        }
        class_1657 recipient = pigeon.method_37908().method_18470(recipientUuid);
        if (recipient == null) {
            return false;
        }
        return pigeon.method_5858((class_1297)recipient) > 64.0;
    }

    private static boolean shouldStopFlyingToRecipient(PigeonEntity pigeon) {
        UUID recipientUuid = pigeon.method_18868().method_18904(FowlPlayMemoryModuleType.RECIPIENT.get()).orElse(null);
        if (recipientUuid == null) {
            return true;
        }
        class_1657 recipient = pigeon.method_37908().method_18470(recipientUuid);
        if (recipient == null) {
            return true;
        }
        return pigeon.method_5858((class_1297)recipient) < 16.0;
    }

    protected void method_5958() {
        this.tickBrain((class_1309)this);
        super.method_5958();
        if (this.method_5682() == null) {
            return;
        }
        if (!this.isTamed()) {
            return;
        }
        class_1799 stack = this.method_6118(class_1304.field_6171);
        class_3222 recipient = this.method_5682().method_3760().method_14566(stack.method_7964().getString());
        if (!(stack.method_7909() instanceof class_5537) || !stack.method_57353().method_57832(class_9334.field_49631) || recipient == null || recipient.method_5667() == null) {
            this.setRecipientUuid(null);
            return;
        }
        this.setRecipientUuid(recipient.method_5667());
    }
}

