/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.GooseVariant;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.LeaderlessFlocking;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetRandomLookTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.control.BirdFloatMoveControl;
import aqario.fowlplay.common.entity.ai.pathing.AmphibiousNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.FowlPlayTrackedDataHandlerRegistry;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import aqario.fowlplay.core.tags.FowlPlayVariantTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7988;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowParent;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.Nullable;

public class GooseEntity
extends TrustingBirdEntity
implements BirdBrain<GooseEntity>,
class_7988<GooseVariant>,
Flocking {
    private static final class_2940<GooseVariant> VARIANT = class_2945.method_12791(GooseEntity.class, FowlPlayTrackedDataHandlerRegistry.GOOSE_VARIANT);
    private static final String AGGRESSIVE_KEY = "aggressive";
    private boolean aggressive;
    public final class_7094 standingState = new class_7094();
    public final class_7094 glidingState = new class_7094();
    public final class_7094 flappingState = new class_7094();
    public final class_7094 floatingState = new class_7094();

    public GooseEntity(class_1299<? extends GooseEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_4, 0.0f);
        this.method_5941(class_7.field_18, 0.0f);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 1.0f;
    }

    @Override
    protected class_1335 createMoveControl() {
        return new BirdFloatMoveControl(this);
    }

    @Override
    public int getMaxPitchChange() {
        return 18;
    }

    @Override
    public int getMaxYawChange() {
        return 18;
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)18, (Object)24);
    }

    @Override
    protected class_1408 getLandNavigation() {
        return new AmphibiousNavigation((class_1308)this, this.method_37908());
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        switch (spawnReason) {
            case field_16466: {
                FowlPlayRegistries.GOOSE_VARIANT.get().fowlplay$getRandomEntry(FowlPlayVariantTags.Goose.DOMESTIC, world.method_8409()).ifPresent(this::setVariant);
                break;
            }
            case field_16472: 
            case field_16459: {
                FowlPlayRegistries.GOOSE_VARIANT.get().fowlplay$getRandomEntry(FowlPlayVariantTags.Goose.NATURAL, world.method_8409()).ifPresent(this::setVariant);
                break;
            }
            default: {
                FowlPlayRegistries.GOOSE_VARIANT.get().fowlplay$getRandom(world.method_8409()).ifPresent(this::setVariant);
            }
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean canSwim() {
        return true;
    }

    @Override
    public int getFlapFrequency() {
        return 0;
    }

    public static class_5132.class_5133 createGooseAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23721, 1.5).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23720, (double)0.22f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)GooseVariant.GREYLAG.get());
    }

    public GooseVariant getVariant() {
        return (GooseVariant)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(GooseVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("variant", FowlPlayRegistries.GOOSE_VARIANT.get().fowlplay$getId(this.getVariant()).toString());
        if (this.aggressive) {
            nbt.method_10556(AGGRESSIVE_KEY, true);
        }
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        GooseVariant variant = FowlPlayRegistries.GOOSE_VARIANT.get().fowlplay$get(class_2960.method_12829((String)nbt.method_10558("variant")));
        if (variant != null) {
            this.setVariant(variant);
        }
        if (nbt.method_10573(AGGRESSIVE_KEY, 99)) {
            this.aggressive = nbt.method_10577(AGGRESSIVE_KEY);
        }
    }

    public boolean isAggressive() {
        return this.aggressive;
    }

    public boolean method_6109() {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    @Override
    public boolean method_5939(class_1799 stack) {
        return super.method_5939(stack) || this.isAggressive() && stack.method_7909() instanceof class_1829;
    }

    @Override
    public boolean shouldDropBeakItem(class_1799 stack) {
        return super.shouldDropBeakItem(stack) && (!this.isAggressive() || !(stack.method_7909() instanceof class_1829));
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.GOOSE_FOOD);
    }

    @Override
    public boolean shouldAttack(class_1309 target) {
        if (this.isAggressive()) {
            return target instanceof class_1657;
        }
        if (this.hasLowHealth()) {
            return false;
        }
        return Birds.wasHurtBy(this, target);
    }

    @Override
    public boolean shouldAvoid(class_1309 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.GOOSE_AVOIDS) && !this.isAggressive();
    }

    @Override
    public void updateAnimations() {
        this.standingState.method_45317(!this.isFlying() && !this.method_5816(), this.field_6012);
        this.flappingState.method_45317(this.isFlying(), this.field_6012);
        this.floatingState.method_45317(!this.isFlying() && this.method_5816(), this.field_6012);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        if (!this.aggressive && name != null && name.getString().equalsIgnoreCase("untitled")) {
            this.aggressive = true;
        }
    }

    protected boolean method_5776() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.8f;
    }

    @Override
    public float getFlapPitch() {
        return 0.6f;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return FowlPlaySoundEvents.ENTITY_GOOSE_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().gooseCallVolume;
    }

    @Override
    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_GOOSE_HURT.get();
    }

    @Override
    public float getWaterline() {
        return 0.35f;
    }

    @Override
    public CylindricalRadius getWalkRange() {
        return new CylindricalRadius(32, 12);
    }

    @Override
    public boolean isLeader() {
        return false;
    }

    @Override
    public void setLeader() {
    }

    protected class_4095.class_5303<GooseEntity> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends GooseEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor(), new AttackTargetSensor()});
    }

    public BrainActivityGroup<? extends GooseEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new class_4097[]{FlightBehaviours.stopFalling(), new SetAttackTarget(), new LookAtTarget().runFor(entity -> entity.method_6051().method_39332(45, 90)), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends GooseEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new class_4097[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    public BrainActivityGroup<? extends GooseEntity> getFightTasks() {
        return BirdBrain.fightActivity(new class_4097[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.4f)), new AnimatableMeleeAttack(0)});
    }

    @Override
    public BrainActivityGroup<? extends GooseEntity> getForageTasks() {
        return BirdBrain.forageActivity(new class_4097[]{new LeaderlessFlocking(5, 0.04f, 0.6f, 0.06f, 3.0f), new OneRandomBehaviour(new Pair[]{Pair.of(CustomBehaviours.setWaterWalkTarget(), (Object)1), Pair.of((Object)CustomBehaviours.idleIfNotFlying().runFor(entity -> entity.method_6051().method_39332(100, 300)), (Object)2)})});
    }

    public BrainActivityGroup<? extends GooseEntity> getIdleTasks() {
        return BirdBrain.idleActivity(new class_4097[]{new BreedWithPartner(), new FollowParent(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new SetRandomLookTarget().lookChance(0.02f), new OneRandomBehaviour(new ExtendedBehaviour[]{CustomBehaviours.setWaterWalkTarget(), CustomBehaviours.idleIfNotFlying().runFor(entity -> entity.method_6051().method_39332(100, 300))})});
    }

    @Override
    public BrainActivityGroup<? extends GooseEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new class_4097[]{CustomBehaviours.setNearestFoodWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends GooseEntity> getRestTasks() {
        return BirdBrain.restActivity(new class_4097[]{CustomBehaviours.setWaterRestTarget(), CustomBehaviours.idleIfInWater()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.WATERFOWL.get();
    }

    protected void method_5958() {
        this.tickBrain((class_1309)this);
        super.method_5958();
    }
}

