/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetItemWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetNonAirWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetWalkTargetAwayFrom;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetWaterWalkTarget;
import aqario.fowlplay.common.util.Birds;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_4140;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;

public class CustomBehaviours {
    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> setWaterWalkTarget() {
        return new SetWaterWalkTarget().radius(32, 24);
    }

    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> setGroundWalkTarget() {
        return new SetNonAirWalkTarget().setRadius(32, 16);
    }

    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> setWaterRestTarget() {
        return new SetWaterWalkTarget().radius(64, 32).startCondition(Predicate.not(class_1297::method_5816)).stopIf(class_1297::method_5816);
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> setNearestFoodWalkTarget() {
        return new SetItemWalkTarget().radius(32).speed(1.4f);
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> setAvoidEntityWalkTarget() {
        return new SetWalkTargetAwayFrom(class_4140.field_22357, class_1297::method_19538).speed(1.4f);
    }

    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> idleIfNotFlying() {
        return new Idle().noTimeout().startCondition(entity -> !entity.isFlying() && !Birds.isPerched(entity)).stopIf(entity -> entity.isFlying() || Birds.isPerched(entity));
    }

    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> idleIfPerched() {
        return new Idle().noTimeout().startCondition(Birds::isPerched).stopIf(Predicate.not(Birds::isPerched));
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> idleIfInWater() {
        return new Idle().noTimeout().startCondition(class_1297::method_5816).stopIf(Predicate.not(class_1297::method_5816));
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> forgetUnderwaterAttackTarget() {
        return new InvalidateMemory(class_4140.field_22355).invalidateIf((entity, target) -> entity.method_5816() && target.method_5869() && target.method_19538().field_1351 < entity.method_19538().field_1351);
    }
}

