/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.util.MemoryList;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class GuidedFlocking
extends ExtendedBehaviour<FlyingBirdEntity> {
    private static final MemoryList MEMORIES = MemoryList.create(3).present((class_4140<?>)FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS.get()).absent(FowlPlayMemoryModuleType.IS_AVOIDING.get(), FowlPlayMemoryModuleType.SEES_FOOD.get());
    private static final int VIEW_RADIUS = 8;
    public float coherence;
    public float alignment;
    public final float separation;
    public final float separationRange;
    private FlyingBirdEntity leader;
    private List<? extends class_1296> nearbyBirds;

    public GuidedFlocking(float separation, float separationRange) {
        this.separation = separation;
        this.separationRange = separationRange;
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean shouldRun(class_3218 world, FlyingBirdEntity bird) {
        if (!bird.isFlying()) {
            return false;
        }
        class_4095 brain = bird.method_18868();
        if (!BrainUtils.hasMemory((class_4095)brain, FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS.get())) {
            return false;
        }
        this.nearbyBirds = (List)BrainUtils.getMemory((class_4095)brain, FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS.get());
        assert (this.nearbyBirds != null);
        this.nearbyBirds.removeIf(entity -> entity.method_5858((class_1297)bird) > 64.0);
        if (this.nearbyBirds.isEmpty()) {
            return false;
        }
        this.leader = null;
        this.nearbyBirds.forEach(entity -> {
            Flocking flockingBird;
            if (entity instanceof Flocking && (flockingBird = (Flocking)entity).isLeader()) {
                this.leader = (FlyingBirdEntity)((Object)((Object)flockingBird));
            }
        });
        if (this.leader == null) {
            ((Flocking)((Object)bird)).setLeader();
            return false;
        }
        return true;
    }

    protected boolean shouldKeepRunning(class_3218 world, FlyingBirdEntity bird, long time) {
        return this.shouldRun(world, bird);
    }

    protected void tick(FlyingBirdEntity bird) {
        class_243 heading = this.getHeading(bird).method_1019(bird.method_19538());
        bird.method_5962().method_6239(heading.field_1352, heading.field_1351, heading.field_1350, (double)(bird.method_6051().method_43057() - bird.method_6051().method_43057()) * 1.5 + 2.0);
    }

    private class_243 getHeading(FlyingBirdEntity bird) {
        class_243 separation = class_243.field_1353;
        class_243 alignment = class_243.field_1353;
        class_243 cohesion = class_243.field_1353;
        for (class_1296 class_12962 : this.nearbyBirds) {
            if (class_12962.method_19538().method_1020(bird.method_19538()).method_1033() < (double)this.separationRange) {
                separation = separation.method_1020(class_12962.method_19538().method_1020(bird.method_19538()));
            }
            alignment = alignment.method_1019(class_12962.method_18798());
            cohesion = cohesion.method_1019(class_12962.method_19538());
        }
        alignment = alignment.method_1021((double)(1.0f / (float)this.nearbyBirds.size()));
        cohesion = cohesion.method_1021((double)(1.0f / (float)this.nearbyBirds.size()));
        cohesion = cohesion.method_1020(bird.method_19538());
        cohesion = cohesion.method_1021((double)this.coherence);
        alignment = alignment.method_1021((double)this.alignment);
        separation = separation.method_1021((double)this.separation);
        class_243 randomness = new class_243((double)(bird.method_6051().method_43057() - bird.method_6051().method_43057()), (double)(bird.method_6051().method_43057() - bird.method_6051().method_43057()), (double)(bird.method_6051().method_43057() - bird.method_6051().method_43057())).method_1021(0.5);
        return cohesion.method_1019(separation).method_1019(alignment).method_1019(randomness);
    }
}

