/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.sensor;

import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlaySensorType;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PigeonSpecificSensor
extends PredicateSensor<UUID, PigeonEntity> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{FowlPlayMemoryModuleType.RECIPIENT.get()});

    public PigeonSpecificSensor() {
        super((uuid, pigeon) -> pigeon.isTamed() && pigeon.getRecipientUuid() != null && pigeon.m_9236_().m_46003_(pigeon.getRecipientUuid()) != null);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return FowlPlaySensorType.PIGEON_SPECIFIC_SENSOR.get();
    }

    protected void sense(ServerLevel world, PigeonEntity pigeon) {
        if (this.predicate().test(null, pigeon)) {
            BrainUtils.setMemory((LivingEntity)pigeon, FowlPlayMemoryModuleType.RECIPIENT.get(), (Object)pigeon.getRecipientUuid());
        } else {
            BrainUtils.clearMemory((LivingEntity)pigeon, FowlPlayMemoryModuleType.RECIPIENT.get());
        }
    }
}

