/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class EntityTypeBuilder<T extends Entity> {
    private final EntityType.EntityFactory<T> factory;
    private final MobCategory spawnGroup;
    private ImmutableSet<Block> canSpawnInside = ImmutableSet.of();
    private boolean saveable = true;
    private boolean summonable = true;
    private boolean fireImmune;
    private boolean spawnableFarFromPlayer;
    private int maxTrackDistance = 5;
    private int trackTickInterval = 3;
    private EntityDimensions dimensions = EntityDimensions.m_20395_((float)0.6f, (float)1.8f);
    private FeatureFlagSet requiredFeatures = FeatureFlags.f_244377_;
    @Nullable
    private Supplier<AttributeSupplier.Builder> attributeBuilder;
    private SpawnPlacements.Type location;
    private Heightmap.Types heightmap;
    private SpawnPlacements.SpawnPredicate<T> spawnPredicate;

    private EntityTypeBuilder(EntityType.EntityFactory<T> factory, MobCategory spawnGroup) {
        this.factory = factory;
        this.spawnGroup = spawnGroup;
        this.spawnableFarFromPlayer = spawnGroup == MobCategory.CREATURE || spawnGroup == MobCategory.MISC;
    }

    public static <T extends Entity> EntityTypeBuilder<T> create(EntityType.EntityFactory<T> factory, MobCategory spawnGroup) {
        return new EntityTypeBuilder<T>(factory, spawnGroup);
    }

    public static <T extends Entity> EntityTypeBuilder<T> create(MobCategory spawnGroup) {
        return new EntityTypeBuilder<T>((type, world) -> null, spawnGroup);
    }

    public EntityTypeBuilder<T> dimensions(float width, float height) {
        this.dimensions = EntityDimensions.m_20395_((float)width, (float)height);
        return this;
    }

    public EntityTypeBuilder<T> disableSummon() {
        this.summonable = false;
        return this;
    }

    public EntityTypeBuilder<T> disableSaving() {
        this.saveable = false;
        return this;
    }

    public EntityTypeBuilder<T> makeFireImmune() {
        this.fireImmune = true;
        return this;
    }

    public EntityTypeBuilder<T> allowSpawningInside(Block ... blocks) {
        this.canSpawnInside = ImmutableSet.copyOf((Object[])blocks);
        return this;
    }

    public EntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.spawnableFarFromPlayer = true;
        return this;
    }

    public EntityTypeBuilder<T> maxTrackingRange(int maxTrackingRange) {
        this.maxTrackDistance = maxTrackingRange;
        return this;
    }

    public EntityTypeBuilder<T> trackingTickInterval(int trackingTickInterval) {
        this.trackTickInterval = trackingTickInterval;
        return this;
    }

    public EntityTypeBuilder<T> requires(FeatureFlag ... features) {
        this.requiredFeatures = FeatureFlags.f_244280_.m_245769_(features);
        return this;
    }

    public EntityTypeBuilder<T> attributes(Supplier<AttributeSupplier.Builder> attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
        return this;
    }

    public EntityTypeBuilder<T> spawnRestriction(SpawnPlacements.Type location, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        this.location = location;
        this.heightmap = heightmap;
        this.spawnPredicate = spawnPredicate;
        return this;
    }

    public EntityType<T> build() {
        return this.build(null);
    }

    public EntityType<T> build(String id) {
        EntityType type;
        if (this.saveable) {
            Util.m_137456_((DSL.TypeReference)References.f_16785_, (String)id);
        }
        if ((type = new EntityType(this.factory, this.spawnGroup, this.spawnableFarFromPlayer, this.saveable, this.summonable, this.fireImmune, this.canSpawnInside, this.dimensions, this.maxTrackDistance, this.trackTickInterval, this.requiredFeatures)).m_142225_().isAssignableFrom(LivingEntity.class) && this.attributeBuilder != null) {
            EntityAttributeRegistry.register(() -> type, this.attributeBuilder);
        }
        if (type.m_142225_().isAssignableFrom(Mob.class) && this.spawnPredicate != null) {
            SpawnPlacementsRegistry.register(() -> type, (SpawnPlacements.Type)this.location, (Heightmap.Types)this.heightmap, this.spawnPredicate);
        }
        return type;
    }
}

