/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.mixin;

import aqario.fowlplay.common.entity.ChickenVariant;
import aqario.fowlplay.common.util.ChickenAnimationStates;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.FowlPlayTrackedDataHandlerRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Chicken.class}, priority=999)
public abstract class ChickenEntityMixin
extends Animal
implements VariantHolder<ChickenVariant>,
ChickenAnimationStates {
    @Unique
    private static final EntityDataAccessor<ChickenVariant> fowlplay$VARIANT = SynchedEntityData.m_135353_(Chicken.class, FowlPlayTrackedDataHandlerRegistry.CHICKEN_VARIANT);
    @Unique
    private final AnimationState fowlplay$standingState = new AnimationState();
    @Unique
    private final AnimationState fowlplay$flappingState = new AnimationState();
    @Unique
    private final AnimationState fowlplay$floatingState = new AnimationState();

    protected ChickenEntityMixin(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        switch (spawnReason) {
            case BREEDING: {
                this.setVariant(ChickenVariant.WHITE.get());
                break;
            }
            case CHUNK_GENERATION: {
                this.setVariant(ChickenVariant.RED_JUNGLEFOWL.get());
                break;
            }
            default: {
                FowlPlayRegistries.CHICKEN_VARIANT.get().fowlplay$getRandom(world.m_213780_()).ifPresent(this::setVariant);
            }
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public ChickenVariant getVariant() {
        return (ChickenVariant)this.f_19804_.m_135370_(fowlplay$VARIANT);
    }

    public void setVariant(ChickenVariant variant) {
        this.f_19804_.m_135381_(fowlplay$VARIANT, (Object)variant);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(fowlplay$VARIANT, (Object)ChickenVariant.WHITE.get());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void fowlplay$readCustomVariant(CompoundTag nbt, CallbackInfo ci) {
        ChickenVariant variant = FowlPlayRegistries.CHICKEN_VARIANT.get().fowlplay$get(ResourceLocation.m_135820_((String)nbt.m_128461_("variant")));
        if (variant != null) {
            this.setVariant(variant);
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void fowlplay$writeCustomVariant(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128359_("variant", FowlPlayRegistries.CHICKEN_VARIANT.get().fowlplay$getId(this.getVariant()).toString());
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.fowlplay$standingState.m_246184_(this.m_20096_() && !this.m_20072_(), this.f_19797_);
            this.fowlplay$flappingState.m_246184_(!this.m_20096_() && !this.m_20072_(), this.f_19797_);
            this.fowlplay$floatingState.m_246184_(this.m_20072_(), this.f_19797_);
        }
        super.m_8119_();
    }

    @Override
    public AnimationState fowlplay$getStandingState() {
        return this.fowlplay$standingState;
    }

    @Override
    public AnimationState fowlplay$getFlappingState() {
        return this.fowlplay$flappingState;
    }

    @Override
    public AnimationState fowlplay$getFloatingState() {
        return this.fowlplay$floatingState;
    }
}

