/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.task.CompositeTasks;
import aqario.fowlplay.common.entity.ai.brain.task.LookAroundTask;
import aqario.fowlplay.common.entity.ai.brain.task.PenguinSpecificTasks;
import aqario.fowlplay.common.entity.ai.brain.task.SetAdultWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetAirTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetEntityLookTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetLandWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SlideTasks;
import aqario.fowlplay.common.entity.ai.control.BirdAquaticMoveControl;
import aqario.fowlplay.common.entity.ai.pathing.AmphibiousNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayEntityType;
import aqario.fowlplay.core.FowlPlayParticleTypes;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayBiomeTags;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4215;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowParent;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.ItemTemptingSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class PenguinEntity
extends BirdEntity
implements BirdBrain<PenguinEntity> {
    private static final int SLIDING_TRANSITION_TICKS = 15;
    private static final int STANDING_TRANSITION_TICKS = 20;
    private static final long LAST_POSE_CHANGE_TICKS = 0L;
    public static final class_2940<Long> LAST_POSE_TICK = class_2945.method_12791(PenguinEntity.class, (class_2941)class_2943.field_39965);
    private static final int SWIM_PARTICLE_COUNT = 15;
    public final class_7094 standingState = new class_7094();
    public final class_7094 slidingState = new class_7094();
    public final class_7094 slidingTransitionState = new class_7094();
    public final class_7094 standingTransitionState = new class_7094();
    public final class_7094 flappingState = new class_7094();
    public final class_7094 swimmingState = new class_7094();
    public final class_7094 dancingState = new class_7094();
    private boolean songPlaying;
    @Nullable
    private class_2338 songSource;

    public PenguinEntity(class_1299<? extends PenguinEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6206 = new class_1332((class_1308)this, 85);
    }

    protected float method_49484() {
        return this.method_5816() ? this.method_6029() : super.method_49484();
    }

    public float method_6029() {
        return this.method_18376() == class_4050.field_47246 ? super.method_6029() * 1.5f : super.method_6029();
    }

    @Override
    protected class_1335 createMoveControl() {
        return new BirdAquaticMoveControl(this, 85, 15, 1.0f, 1.0f, true);
    }

    @Override
    public int method_5978() {
        return this.method_5816() ? 1 : super.method_5978();
    }

    @Override
    public int method_5986() {
        return this.method_5816() ? 1 : super.method_5986();
    }

    protected class_1408 method_5965(class_1937 world) {
        return new AmphibiousNavigation((class_1308)this, this.method_37908());
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_59664();
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.initLastPoseTick(world.method_8410().method_8510());
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)FowlPlayEntityType.PENGUIN.get().method_5883((class_1937)world);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return this.getFood().method_8093(stack);
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.PENGUIN_FOOD);
    }

    @Override
    public boolean canHunt(class_1309 target) {
        return target.method_5864().method_20210(FowlPlayEntityTypeTags.PENGUIN_HUNT_TARGETS);
    }

    @Override
    public boolean shouldAvoid(class_1309 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.PENGUIN_AVOIDS);
    }

    public static class_5132.class_5133 createPenguinAttributes() {
        return BirdEntity.createBirdAttributes().method_26868(class_5134.field_23716, 16.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, (double)0.145f).method_26868(class_5134.field_51578, 1.0);
    }

    public void method_6006(class_2338 songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    @Override
    public void method_6007() {
        if (this.songSource == null || !this.songSource.method_19769((class_2374)this.method_19538(), 5.0) || !this.method_37908().method_8320(this.songSource).method_27852(class_2246.field_10223)) {
            this.songPlaying = false;
            this.songSource = null;
        }
        super.method_6007();
    }

    public boolean isSongPlaying() {
        return this.songPlaying;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LAST_POSE_TICK, (Object)0L);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10544("lastPoseTick", ((Long)this.field_6011.method_12789(LAST_POSE_TICK)).longValue());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        long l = nbt.method_10537("lastPoseTick");
        if (l < 0L) {
            this.method_18380(class_4050.field_47246);
        }
        this.setLastPoseTick(l);
    }

    public void method_48850(List<class_2945.class_7834<?>> entries) {
        super.method_48850(entries);
        this.method_18382();
    }

    @Override
    public void method_5773() {
        if (this.method_5642() != null && this.method_5816()) {
            this.method_5642().method_5848();
        }
        if (this.method_5816() && !this.isSliding()) {
            this.setSliding();
        }
        super.method_5773();
        if (this.method_37908().method_8608() && this.method_5816() && this.method_18798().method_1027() > 0.02) {
            this.addSwimParticles();
        }
        if (this.method_5681()) {
            this.method_18380(class_4050.field_18079);
        } else if (this.isSliding()) {
            this.method_18380(class_4050.field_47246);
        } else {
            this.method_18380(class_4050.field_18076);
        }
    }

    private void addSwimParticles() {
        class_243 velocity = this.method_5720().method_22882().method_1021(0.5);
        for (int i = 0; i < 15; ++i) {
            this.method_37908().method_8406((class_2394)FowlPlayParticleTypes.SMALL_BUBBLE.get(), this.method_23317() + (double)(this.field_5974.method_43057() * 0.75f - 0.375f), this.method_23318() + this.method_5829().method_17940() / 2.0 + (double)(this.field_5974.method_43057() * 0.75f - 0.375f), this.method_23321() + (double)(this.field_5974.method_43057() * 0.75f - 0.375f), velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    @Override
    protected void updateAnimations() {
        this.standingState.method_45317(this.method_24828() && !this.method_5816() && !this.isSliding(), this.field_6012);
        if (this.method_5816()) {
            this.standingState.method_41325();
            this.swimmingState.method_41324(this.field_6012);
        } else {
            this.swimmingState.method_41325();
        }
        if (this.shouldUpdateSlidingAnimations() && !this.method_5816()) {
            this.standingState.method_41325();
            if (this.shouldPlaySlidingTransition()) {
                this.slidingTransitionState.method_41324(this.field_6012);
                this.slidingState.method_41325();
            } else {
                this.slidingTransitionState.method_41325();
                this.slidingState.method_41324(this.field_6012);
            }
        } else {
            this.slidingTransitionState.method_41325();
            this.slidingState.method_41325();
            this.standingTransitionState.method_45317(this.isChangingPose() && this.getLastPoseTickDelta() >= 0L, this.field_6012);
        }
        if (this.isSongPlaying() && this.method_24828()) {
            this.dancingState.method_41324(this.field_6012);
            this.setStanding();
            this.standingState.method_41325();
        } else {
            this.dancingState.method_41325();
        }
    }

    public boolean canStartSliding() {
        return !this.method_5816() && !this.method_5782() && this.method_24828() && (this.method_37908().method_8320(this.method_24515().method_10074()).method_26164(FowlPlayBlockTags.PENGUINS_SLIDE_ON) || this.method_37908().method_8320(this.method_24515()).method_26164(FowlPlayBlockTags.PENGUINS_SLIDE_ON));
    }

    public boolean isSliding() {
        return (Long)this.field_6011.method_12789(LAST_POSE_TICK) < 0L;
    }

    public boolean shouldUpdateSlidingAnimations() {
        return this.getLastPoseTickDelta() < 0L != this.isSliding();
    }

    public boolean isChangingPose() {
        long l = this.getLastPoseTickDelta();
        return l < (long)(this.isSliding() ? 15 : 20);
    }

    private boolean shouldPlaySlidingTransition() {
        return this.isSliding() && this.getLastPoseTickDelta() < 15L && this.getLastPoseTickDelta() >= 0L;
    }

    public void startSliding() {
        if (!this.isSliding()) {
            this.method_18380(class_4050.field_47246);
            this.method_32876((class_6880)class_5712.field_45148);
            this.setLastPoseTick(-this.method_37908().method_8510());
        }
    }

    public void stopSliding() {
        if (this.isSliding()) {
            this.method_18380(class_4050.field_18076);
            this.method_32876((class_6880)class_5712.field_45148);
            this.setLastPoseTick(this.method_37908().method_8510());
        }
    }

    public void setStanding() {
        this.method_18380(class_4050.field_18076);
        this.method_32876((class_6880)class_5712.field_45148);
        this.initLastPoseTick(this.method_37908().method_8510());
    }

    public void setSliding() {
        this.method_18380(class_4050.field_47246);
        this.method_32876((class_6880)class_5712.field_45148);
        this.setLastPoseTick(-Math.max(0L, this.method_37908().method_8510() - 15L - 1L));
    }

    private void setLastPoseTick(long lastPoseTick) {
        this.field_6011.method_12778(LAST_POSE_TICK, (Object)lastPoseTick);
    }

    private void initLastPoseTick(long time) {
        this.setLastPoseTick(Math.max(0L, time - 20L - 1L));
    }

    public long getLastPoseTickDelta() {
        return this.method_37908().method_8510() - Math.abs((Long)this.field_6011.method_12789(LAST_POSE_TICK));
    }

    public void method_5790() {
        this.method_5796(this.method_5816() && !this.method_5765());
    }

    protected void clampPassengerYaw(class_1297 entity) {
        entity.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entity.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entity.field_5982 += g - f;
        entity.method_36456(entity.method_36454() + g - f);
        entity.method_5847(entity.method_36454());
    }

    public void method_5644(class_1297 passenger) {
        this.clampPassengerYaw(passenger);
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 vec3d = PenguinEntity.method_24826((double)(this.method_17681() * class_3532.field_15724), (double)passenger.method_17681(), (float)passenger.method_36454());
        double d = this.method_23317() + vec3d.field_1352;
        double e = this.method_23321() + vec3d.field_1350;
        class_2338 blockPos = new class_2338((int)d, (int)this.method_53511().field_1325, (int)e);
        class_2338 blockPos2 = blockPos.method_10074();
        if (!this.method_37908().method_22351(blockPos2)) {
            double g;
            ArrayList list = Lists.newArrayList();
            double f = this.method_37908().method_30347(blockPos);
            if (class_5275.method_27932((double)f)) {
                list.add(new class_243(d, (double)blockPos.method_10264() + f, e));
            }
            if (class_5275.method_27932((double)(g = this.method_37908().method_30347(blockPos2)))) {
                list.add(new class_243(d, (double)blockPos2.method_10264() + g, e));
            }
            for (class_4050 entityPose : passenger.method_24831()) {
                for (class_243 vec3d2 : list) {
                    if (!class_5275.method_33353((class_1941)this.method_37908(), (class_243)vec3d2, (class_1309)passenger, (class_4050)entityPose)) continue;
                    passenger.method_18380(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.method_24829(passenger);
    }

    public float method_49476() {
        return this.method_18376() == class_4050.field_47246 ? 1.1f : super.method_49476();
    }

    public float method_17825() {
        return this.method_6109() ? 0.62f : 1.0f;
    }

    public class_4048 method_55694(class_4050 pose) {
        class_4048 dimensions = super.method_55694(pose);
        return pose == class_4050.field_47246 || pose == class_4050.field_18079 ? dimensions.method_19539(1.0f, 0.35f) : dimensions;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5810() {
        return !this.method_5782();
    }

    protected boolean canBreed() {
        return !this.method_5782() && !this.method_5765() && !this.method_6109() && this.method_6032() >= this.method_6063() && this.method_6479();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_6474(class_1429 other) {
        if (other == this) return false;
        if (!(other instanceof PenguinEntity)) return false;
        PenguinEntity penguin = (PenguinEntity)other;
        if (!this.canBreed()) return false;
        if (!penguin.canBreed()) return false;
        return true;
    }

    public boolean shouldStepDown() {
        class_2338 pos = this.method_24515();
        return !this.method_24828() && this.field_6017 > 0.0f && this.field_6017 < 0.1f && !this.method_37908().method_8320(pos.method_10074()).method_26220((class_1922)this.method_37908(), pos.method_10074()).method_1110();
    }

    @Nullable
    public class_1309 method_5642() {
        return (class_1309)this.method_31483();
    }

    protected boolean method_5818(class_1297 passenger) {
        return super.method_5818(passenger) && !this.method_5869();
    }

    protected boolean method_5876() {
        boolean touchingWater = this.method_5799();
        boolean bl = super.method_5876();
        if (touchingWater != this.method_5799()) {
            this.method_18380(this.method_5799() ? class_4050.field_18079 : class_4050.field_18076);
            this.method_18382();
        }
        return bl;
    }

    public static boolean canSpawnPenguins(class_1299<? extends BirdEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_23753(pos).method_40220(FowlPlayBiomeTags.SPAWNS_PENGUINS) && world.method_8320(pos.method_10074()).method_26164(FowlPlayBlockTags.PENGUINS_SPAWNABLE_ON);
    }

    protected void method_49481(class_1657 player, class_243 input) {
        super.method_49481(player, input);
        float sidewaysMovement = player.field_6212;
        double rotation = 3.0;
        if (Math.abs(sidewaysMovement) == 0.0f) {
            rotation = 0.0;
        }
        this.method_5710((float)((double)this.method_36454() + rotation * (double)(sidewaysMovement < 0.0f ? 1 : -1)), this.method_36455());
        player.method_36456((float)((double)player.method_36454() + rotation * (double)(sidewaysMovement < 0.0f ? 1 : -1)) % 360.0f);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
    }

    protected class_243 method_49482(class_1657 player, class_243 input) {
        float forwardMovement = player.field_6250 * 0.2f;
        if (this.method_37908().method_8320(this.method_23314()).method_26164(FowlPlayBlockTags.PENGUINS_SLIDE_ON) || this.method_55667().method_26164(FowlPlayBlockTags.PENGUINS_SLIDE_ON)) {
            forwardMovement *= 2.0f;
        }
        return new class_243(0.0, 0.0, (double)Math.max(forwardMovement, 0.0f));
    }

    protected float method_49485(class_1657 player) {
        return (float)this.method_45325(class_5134.field_23719);
    }

    public int method_5748() {
        return 9600;
    }

    protected int method_6064(int air) {
        return this.method_5748();
    }

    @Override
    public float getWaterline() {
        return 0.0f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean bl = this.method_6481(player.method_5998(hand));
        if (!(bl || this.method_5782() || player.method_21823() || this.method_6109() || !this.isSliding())) {
            if (!this.method_37908().field_9236) {
                player.method_5804((class_1297)this);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        if (this.method_18376() == class_4050.field_47246) {
            return (super.method_23329(fallDistance, damageMultiplier) - 3) / 2;
        }
        return super.method_23329(fallDistance, damageMultiplier);
    }

    @Override
    protected boolean canCall() {
        return !this.method_5816() && super.canCall();
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return this.method_6109() ? FowlPlaySoundEvents.ENTITY_PENGUIN_BABY_CALL.get() : FowlPlaySoundEvents.ENTITY_PENGUIN_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().penguinCallVolume;
    }

    protected class_3414 method_5737() {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_SWIM.get();
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_HURT.get();
    }

    protected class_4095.class_5303<PenguinEntity> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends PenguinEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new ItemTemptingSensor().temptedWith((entity, stack) -> this.getFood().method_8093(stack)), new InWaterSensor(), new AttackedSensor().setScanRate(bird -> 10), new AvoidTargetSensor().setScanRate(bird -> 10), new AttackTargetSensor().setScanRate(bird -> 10)});
    }

    public BrainActivityGroup<? extends PenguinEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new class_4097[]{new SetAirTargetTask(), new SetAttackTarget(), new LookAtTarget().runFor(entity -> entity.method_59922().method_39332(45, 90)), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends PenguinEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new class_4097[]{CompositeTasks.setAvoidEntityWalkTarget()});
    }

    public BrainActivityGroup<? extends PenguinEntity> getFightTasks() {
        return BirdBrain.fightActivity(new class_4097[]{new InvalidateAttackTarget(), SlideTasks.startSliding(), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.4f)), new AnimatableMeleeAttack(0), new InvalidateMemory(class_4140.field_22355).invalidateIf((entity, memory) -> class_4215.method_41331((class_1309)entity))});
    }

    public BrainActivityGroup<? extends PenguinEntity> getIdleTasks() {
        return BirdBrain.idleActivity(new class_4097[]{new BreedWithPartner(), new FollowParent(), SetEntityLookTargetTask.create(class_1299.field_6097), new FollowTemptation(), new LookAroundTask().lookChance(0.02f), new OneRandomBehaviour(new Pair[]{Pair.of(SetLandWalkTargetTask.create(32), (Object)5), Pair.of(PenguinSpecificTasks.swim(), (Object)2)}).startCondition(entity -> entity.method_5816() && !BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_18445)), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SetRandomWalkTarget().setRadius(24.0, 12.0), (Object)2), Pair.of(SlideTasks.toggleSliding(20), (Object)5), Pair.of((Object)new Idle().runFor(entity -> entity.method_59922().method_39332(400, 800)), (Object)5), Pair.of(SetAdultWalkTargetTask.create(Birds.STAY_NEAR_ENTITY_RANGE), (Object)2), Pair.of(PenguinSpecificTasks.goToWater(), (Object)6)}).startCondition(entity -> !entity.method_5816() && !BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_18445))});
    }

    @Override
    public BrainActivityGroup<? extends PenguinEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new class_4097[]{SlideTasks.startSliding(), CompositeTasks.setNearestFoodWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends PenguinEntity> getRestTasks() {
        return BirdBrain.restActivity(new class_4097[]{new Idle()});
    }

    protected void method_5958() {
        class_4095 brain = this.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        this.tickBrain((class_1309)this);
        if (activity == class_4168.field_22396 && brain.method_24538().orElse(null) != class_4168.field_22396) {
            brain.method_24525(class_4140.field_30246, (Object)true, 2400L);
        }
        super.method_5958();
    }
}

