/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.network;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.network.s2c.DebugBirdCustomPayload;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlay;
import com.google.common.collect.Lists;
import dev.architectury.networking.NetworkManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11;
import net.minecraft.class_1275;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4099;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4617;
import net.minecraft.class_4831;
import net.minecraft.class_6067;
import net.minecraft.class_6670;
import net.minecraft.class_7893;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class FowlPlayDebugInfoSender {
    public static void sendBirdDebugData(BirdEntity bird) {
        if (!FowlPlay.isDebugUtilsLoaded()) {
            return;
        }
        if (bird.method_37908().method_8608()) {
            return;
        }
        class_4095 brain = bird.method_18868();
        String name = class_4617.method_36154((class_1297)bird);
        String inventory = "";
        class_11 path = null;
        if (bird instanceof class_6067) {
            class_6067 inventoryOwner = (class_6067)bird;
            String string = inventory = inventoryOwner.method_35199().method_5442() ? "" : inventoryOwner.method_35199().toString();
        }
        if (BrainUtils.hasMemory((class_4095)brain, (class_4140)class_4140.field_18449)) {
            path = (class_11)BrainUtils.getMemory((class_4095)brain, (class_4140)class_4140.field_18449);
        }
        ArrayList<String> trusting = new ArrayList<String>();
        if (bird instanceof TrustingBirdEntity) {
            TrustingBirdEntity trustingBird = (TrustingBirdEntity)bird;
            trustingBird.getTrustedUuids().forEach(uuid -> {
                class_1657 player = bird.method_37908().method_18470(uuid);
                if (player != null) {
                    trusting.add(player.method_5477().getString());
                } else {
                    trusting.add(uuid.toString());
                }
            });
        }
        List<String> activities = brain.method_35059().stream().map(class_4168::method_19634).toList();
        List<String> behaviors = brain.method_27074().stream().map(class_7893::method_46910).toList();
        List<String> memories = FowlPlayDebugInfoSender.getMemoryDescriptions((class_1309)bird, bird.method_37908().method_8510());
        String schedule = Optional.ofNullable(class_7923.field_41131.method_10221((Object)brain.method_18894())).map(class_2960::method_12832).orElse(null);
        Set<class_2338> pois = Set.of();
        Set<class_2338> potentialPois = Set.of();
        DebugBirdCustomPayload.BirdData data = new DebugBirdCustomPayload.BirdData(bird.method_5667(), bird.method_5628(), name, bird.method_5962().getClass().getSimpleName(), bird.method_5942().getClass().getSimpleName(), bird.method_6032(), bird.method_6063(), bird.method_19538(), inventory, path, trusting, bird.isAmbient(), Birds.isPerched(bird), activities, behaviors, memories, schedule, pois, potentialPois);
        DebugBirdCustomPayload payload = new DebugBirdCustomPayload(data);
        FowlPlayDebugInfoSender.sendToAll((class_3218)bird.method_37908(), payload);
    }

    private static List<String> getMemoryDescriptions(class_1309 entity, long gameTime) {
        Map map = entity.method_18868().method_35058();
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            class_4140 memoryModuleType = (class_4140)entry.getKey();
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                class_4831 expirableValue = (class_4831)optional.get();
                Object object = expirableValue.method_24637();
                if (memoryModuleType == class_4140.field_19009) {
                    long l = gameTime - (Long)object;
                    value = l + " ticks ago";
                } else if (expirableValue.method_24914()) {
                    String desc = FowlPlayDebugInfoSender.getMemoryValueDescription((class_3218)entity.method_37908(), object);
                    value = desc + " (ttl: " + expirableValue.method_35127() + ")";
                } else {
                    value = FowlPlayDebugInfoSender.getMemoryValueDescription((class_3218)entity.method_37908(), object);
                }
            } else {
                value = "-";
            }
            String memory = class_7923.field_41129.method_10221((Object)memoryModuleType).method_12832();
            list.add(memory + ": " + (String)value);
        }
        list.sort(String::compareTo);
        return list;
    }

    private static String getMemoryValueDescription(class_3218 world, @Nullable Object object) {
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UUID.class, class_1309.class, class_1275.class, class_4142.class, class_4102.class, class_4208.class, class_4099.class, class_1282.class, Collection.class, class_6670.class}, (Object)object2, n)) {
            case -1: {
                return "-";
            }
            case 0: {
                UUID uuid = (UUID)object2;
                return FowlPlayDebugInfoSender.getMemoryValueDescription(world, world.method_14190(uuid));
            }
            case 1: {
                class_1309 entity = (class_1309)object2;
                return class_4617.method_36154((class_1297)entity);
            }
            case 2: {
                class_1275 nameable = (class_1275)object2;
                return nameable.method_5477().getString();
            }
            case 3: {
                class_4142 walkTarget = (class_4142)object2;
                return FowlPlayDebugInfoSender.getMemoryValueDescription(world, walkTarget.method_19094());
            }
            case 4: {
                class_4102 entityLookTarget = (class_4102)object2;
                return FowlPlayDebugInfoSender.getMemoryValueDescription(world, entityLookTarget.method_35066());
            }
            case 5: {
                class_4208 globalPos = (class_4208)object2;
                return FowlPlayDebugInfoSender.getMemoryValueDescription(world, globalPos.comp_2208());
            }
            case 6: {
                class_4099 blockPosLookTarget = (class_4099)object2;
                return FowlPlayDebugInfoSender.getMemoryValueDescription(world, blockPosLookTarget.method_18989());
            }
            case 7: {
                class_1282 damageSource = (class_1282)object2;
                class_1297 entity = damageSource.method_5529();
                return entity == null ? object.toString() : FowlPlayDebugInfoSender.getMemoryValueDescription(world, entity);
            }
            case 8: {
                Collection iterable = (Collection)object2;
                ArrayList list = Lists.newArrayList();
                iterable.forEach(o -> list.add(FowlPlayDebugInfoSender.getMemoryValueDescription(world, o)));
                return ((Object)list).toString();
            }
            case 9: {
                class_6670 cache = (class_6670)object2;
                ArrayList list = Lists.newArrayList();
                cache.field_35105.forEach(o -> list.add(FowlPlayDebugInfoSender.getMemoryValueDescription(world, o)));
                return ((Object)list).toString();
            }
        }
        return object.toString();
    }

    private static void sendToAll(class_3218 world, class_8710 payload) {
        NetworkManager.sendToPlayers((Iterable)world.method_18456(), (class_8710)payload);
    }
}

