/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.datagen.provider;

import aqario.fowlplay.datagen.provider.SoundDefinition;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class SoundDefinitionsProvider
implements class_2405 {
    private final FabricDataOutput output;
    private final String namespace;
    private final Map<String, SoundDefinition> soundDefinitions = new LinkedHashMap<String, SoundDefinition>();

    protected SoundDefinitionsProvider(FabricDataOutput output, String namespace, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.output = output;
        this.namespace = namespace;
    }

    public abstract void generateSounds();

    public CompletableFuture<?> method_10319(class_7403 writer) {
        this.soundDefinitions.clear();
        this.generateSounds();
        if (this.soundDefinitions.isEmpty()) {
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }
        return this.writeJson(writer, this.output.method_45972(class_7784.class_7490.field_39368).resolve(this.namespace).resolve("sounds.json"));
    }

    public String method_10321() {
        return "Sound Definitions";
    }

    protected static SoundDefinition.Sound sound(class_2960 name, SoundDefinition.SoundType type) {
        return SoundDefinition.Sound.sound(name, type);
    }

    protected static SoundDefinition.Sound sound(class_2960 name) {
        return SoundDefinitionsProvider.sound(name, SoundDefinition.SoundType.SOUND);
    }

    protected static SoundDefinition.Sound sound(String name, SoundDefinition.SoundType type) {
        return SoundDefinitionsProvider.sound(class_2960.method_12829((String)name), type);
    }

    protected static SoundDefinition.Sound sound(String name) {
        return SoundDefinitionsProvider.sound(class_2960.method_12829((String)name));
    }

    protected void add(Supplier<class_3414> soundEvent, SoundDefinition definition) {
        this.add(soundEvent.get(), definition);
    }

    protected void add(class_3414 soundEvent, SoundDefinition definition) {
        this.add(soundEvent.method_14833(), definition);
    }

    protected void add(class_2960 soundEvent, SoundDefinition definition) {
        this.addSounds(soundEvent, definition);
    }

    protected void add(String soundEvent, SoundDefinition definition) {
        this.add(class_2960.method_12829((String)soundEvent), definition);
    }

    private void addSounds(class_2960 soundEvent, SoundDefinition definition) {
        if (this.soundDefinitions.put(soundEvent.method_12832(), definition) != null) {
            throw new IllegalStateException("Sound event '" + String.valueOf(soundEvent) + "' already exists");
        }
    }

    private CompletableFuture<?> writeJson(class_7403 cache, Path path) {
        return class_2405.method_10320((class_7403)cache, (JsonElement)this.mapToJson(this.soundDefinitions), (Path)path);
    }

    private JsonObject mapToJson(Map<String, SoundDefinition> map) {
        JsonObject json = new JsonObject();
        map.forEach((sound, definition) -> json.add(sound, (JsonElement)definition.serialize()));
        return json;
    }
}

