/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.DomesticGooseAnimations;
import aqario.fowlplay.client.render.entity.animation.GooseAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdEntityModel;
import aqario.fowlplay.common.entity.GooseEntity;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class GooseEntityModel
extends FlyingBirdEntityModel<GooseEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(ResourceLocation.m_214293_((String)"fowlplay", (String)"goose"), "main");

    public GooseEntityModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition root = modelPartData.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-1.5f, -7.0f, -1.75f, 3.0f, 9.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)-3.5f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.5f, -3.0f, -1.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-1.75f));
        head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-1.0f, 0.0f, -2.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(-0.001f)).m_171514_(0, 3).m_171488_(-1.0f, -0.75f, -2.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -6.0f, -6.5f, 6.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        torso.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-0.5f, -3.0f, -0.5f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-3.0f, (float)3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(1, 24).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-5.5f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(1, 24).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-5.5f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.m_171599_("left_wing_open", CubeListBuilder.m_171558_().m_171514_(23, 0).m_171488_(-1.0f, -0.1f, -1.0f, 10.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-6.5f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        left_wing_open.m_171599_("left_wing_outer", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171488_(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition right_wing_open = body.m_171599_("right_wing_open", CubeListBuilder.m_171558_().m_171514_(23, 0).m_171480_().m_171488_(-9.0f, -0.1f, -1.0f, 10.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-6.5f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        right_wing_open.m_171599_("right_wing_outer", CubeListBuilder.m_171558_().m_171514_(24, 10).m_171480_().m_171488_(-11.0f, 0.0f, 0.0f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(34, 18).m_171488_(-1.5f, -1.0f, 1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(40, 18).m_171488_(-1.0f, -1.002f, 1.75f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.25f, (float)6.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        tail.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(41, 18).m_171488_(-1.0f, -0.001f, 0.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-1.0f, (float)2.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        tail.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(41, 18).m_171480_().m_171488_(-1.0f, -0.001f, 0.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.5f, (float)-1.0f, (float)2.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(-1, 0).m_171480_().m_171488_(-1.5f, 4.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.25f, (float)1.0f, (float)2.5f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(-1, 0).m_171488_(-1.5f, 4.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.25f, (float)1.0f, (float)2.5f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void animateModel(GooseEntity goose, float limbAngle, float limbDistance, float tickDelta) {
        AnimationDefinition flappingAnimation;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        super.m_6839_((Entity)goose, limbAngle, limbDistance, tickDelta);
        float ageInTicks = (float)goose.f_19797_ + tickDelta;
        float bodyYaw = Mth.m_14189_((float)tickDelta, (float)goose.f_20884_, (float)goose.f_20883_);
        float headYaw = Mth.m_14189_((float)tickDelta, (float)goose.f_20886_, (float)goose.f_20885_);
        float relativeHeadYaw = Mth.m_14177_((float)(headYaw - bodyYaw));
        float headPitch = Mth.m_14179_((float)tickDelta, (float)goose.f_19860_, (float)goose.m_146909_());
        if (LivingEntityRenderer.m_194453_((LivingEntity)goose)) {
            headPitch *= -1.0f;
            relativeHeadYaw *= -1.0f;
        }
        if (!goose.isFlying()) {
            this.updateHeadRotation(relativeHeadYaw, headPitch);
        }
        if (goose.isFlying()) {
            this.root.f_104203_ = goose.m_5686_(tickDelta) * ((float)Math.PI / 180);
            this.root.f_104205_ = goose.getRoll(tickDelta) * ((float)Math.PI / 180);
        }
        if (goose.isFlying()) {
            this.leftWingOpen.f_104207_ = true;
            this.rightWingOpen.f_104207_ = true;
            this.leftWing.f_104207_ = false;
            this.rightWing.f_104207_ = false;
        } else {
            this.leftWingOpen.f_104207_ = false;
            this.rightWingOpen.f_104207_ = false;
            this.leftWing.f_104207_ = true;
            this.rightWing.f_104207_ = true;
        }
        boolean domestic = goose.getVariant().domestic();
        AnimationDefinition walkingAnimation = domestic ? DomesticGooseAnimations.WALKING : GooseAnimations.WALKING;
        AnimationDefinition standingAnimation = domestic ? DomesticGooseAnimations.STANDING : GooseAnimations.STANDING;
        AnimationDefinition swimmingAnimation = domestic ? DomesticGooseAnimations.SWIMMING : GooseAnimations.SWIMMING;
        AnimationDefinition glidingAnimation = domestic ? DomesticGooseAnimations.GLIDING : GooseAnimations.GLIDING;
        AnimationDefinition animationDefinition = flappingAnimation = domestic ? DomesticGooseAnimations.FLAPPING : GooseAnimations.FLAPPING;
        if (!goose.isFlying() && !goose.m_20072_()) {
            this.m_267799_(walkingAnimation, limbAngle, limbDistance, 3.0f, 3.0f);
        }
        this.m_233381_(goose.standingState, standingAnimation, ageInTicks);
        this.m_233381_(goose.floatingState, swimmingAnimation, ageInTicks);
        this.m_233381_(goose.glidingState, glidingAnimation, ageInTicks);
        this.m_233381_(goose.flappingState, flappingAnimation, ageInTicks);
    }

    private void updateHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.m_14036_((float)headYaw, (float)-100.0f, (float)100.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f);
        this.neck.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.neck.f_104203_ = headPitch * ((float)Math.PI / 180);
    }
}

