/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.pathing;

import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.util.Birds;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.navigation.ExtendedNavigator;
import org.jetbrains.annotations.Nullable;

public class FlightNavigation
extends GroundPathNavigation
implements ExtendedNavigator {
    private static final int NODE_DISTANCE = 3;
    private static final float NODE_REACH_RADIUS = 2.0f;
    private final FlyingBirdEntity bird;

    public FlightNavigation(FlyingBirdEntity bird, Level world) {
        super((Mob)bird, world);
        this.bird = bird;
    }

    public Mob getMob() {
        return this.bird;
    }

    @Nullable
    public Path m_26570_() {
        return super.m_26570_();
    }

    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new FlyNodeEvaluator();
        this.f_26508_.m_77351_(true);
        return new PathFinder(this.f_26508_, maxVisitedNodes){

            @Nullable
            public Path m_77427_(PathNavigationRegion navigationRegion, Mob mob, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
                Path path = super.m_77427_(navigationRegion, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
                return FlightNavigation.this.patchPath(path);
            }
        };
    }

    @Nullable
    public Path patchPath(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        Path newPath = new Path(path.f_77362_, path.m_77406_(), path.m_77403_()){

            public Vec3 m_77382_(Entity entity1, int nodeIndex) {
                return FlightNavigation.this.getEntityPosAtNode(nodeIndex);
            }
        };
        Node[] debugNodes = path.m_77404_();
        Node[] debugSecondNodes = path.m_77405_();
        Set debugTargetNodes = path.f_77365_;
        newPath.m_164709_(debugNodes, debugSecondNodes, debugTargetNodes);
        return newPath;
    }

    public boolean m_26519_(double x, double y, double z, double speed) {
        this.bird.m_21566_().m_6849_(x, y, z, speed);
        return true;
    }

    public boolean m_5624_(Entity entity, double speed) {
        this.bird.m_21566_().m_6849_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), speed);
        return true;
    }

    protected boolean m_183431_(Vec3 origin, Vec3 target) {
        return FlightNavigation.m_262402_((Mob)this.bird, (Vec3)origin, (Vec3)target, (boolean)true);
    }

    protected boolean m_7632_() {
        return this.m_26576_() && this.m_26574_() || !this.bird.m_20159_();
    }

    protected Vec3 m_7475_() {
        return this.getMob().m_20182_();
    }

    protected double m_183345_(Vec3 pos) {
        return pos.f_82480_;
    }

    @Nullable
    public Path m_7864_(BlockPos target, int distance) {
        return this.m_26551_((Set)ImmutableSet.of((Object)target), 48, false, distance);
    }

    public void m_7638_() {
        ++this.f_26498_;
        if (this.f_26506_) {
            this.m_26569_();
        }
        if (!this.m_26571_()) {
            if (this.m_7632_()) {
                this.m_7636_();
            } else if (this.f_26496_ != null && !this.f_26496_.m_77392_()) {
                Vec3 pos = this.m_7475_();
                Vec3 nodePos = this.f_26496_.m_77380_((Entity)this.bird);
                if (pos.f_82480_ > nodePos.f_82480_ && !this.bird.m_20096_() && Mth.m_14107_((double)pos.f_82479_) == Mth.m_14107_((double)nodePos.f_82479_) && Mth.m_14107_((double)pos.f_82481_) == Mth.m_14107_((double)nodePos.f_82481_)) {
                    this.f_26496_.m_77374_();
                }
            }
            if (this.f_26496_ != null && this.f_26496_.m_77392_() && this.m_26567_() != null && Birds.shouldLandAtDestination(this.bird, this.m_26567_())) {
                this.bird.stopFlying();
            }
            DebugPackets.m_133703_((Level)this.f_26495_, (Mob)this.getMob(), (Path)this.m_26570_(), (float)0.1f);
            if (!this.m_26571_()) {
                Vec3 vec3d = this.f_26496_.m_77380_((Entity)this.bird);
                this.bird.m_21566_().m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, this.f_26497_);
            }
        }
    }

    public Vec3 getEntityPosAtNode(int nodeIndex) {
        Mob mob = this.getMob();
        Path path = this.m_26570_();
        double lateralOffset = (float)Mth.m_14143_((float)(mob.m_20205_() + 1.0f)) / 2.0f;
        return Vec3.m_82528_((Vec3i)path.m_77396_(nodeIndex)).m_82520_(lateralOffset, 0.5, lateralOffset);
    }

    protected void m_7636_() {
        Vec3 safeSurfacePos = this.m_7475_();
        int shortcutNode = this.getClosestVerticalTraversal(Mth.m_14107_((double)safeSurfacePos.f_82480_));
        float f = this.f_26505_ = this.bird.m_20205_() > 0.75f ? this.bird.m_20205_() / 2.0f : 0.75f - this.bird.m_20205_() / 2.0f;
        if (this.isCloseToNextNode(2.0f)) {
            int nextNodeIndex = this.f_26496_.m_77399_() + 3;
            if (this.f_26496_.m_77399_() < this.f_26496_.m_77398_() - 1 && nextNodeIndex >= this.f_26496_.m_77398_()) {
                this.f_26496_.m_77393_(this.f_26496_.m_77398_() - 1);
            } else {
                this.f_26496_.m_77393_(nextNodeIndex);
            }
        }
        this.m_6481_(safeSurfacePos);
    }

    public boolean isCloseToNextNode(float distance) {
        Vec3 nextNodePos = this.getEntityPosAtNode(this.m_26570_().m_77399_());
        if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
            return this.m_7475_().m_82509_((Position)nextNodePos, 0.5);
        }
        return this.m_7475_().m_82509_((Position)nextNodePos, (double)distance);
    }

    protected int getClosestVerticalTraversal(int safeSurfaceHeight) {
        int nodesLength = this.f_26496_.m_77398_();
        for (int nodeIndex = this.f_26496_.m_77399_(); nodeIndex < nodesLength; ++nodeIndex) {
            if (this.f_26496_.m_77375_((int)nodeIndex).f_77272_ == safeSurfaceHeight) continue;
            return nodeIndex;
        }
        return nodesLength;
    }

    public boolean m_6342_(BlockPos pos) {
        return true;
    }
}

