/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.core;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.ChickenVariant;
import aqario.fowlplay.common.entity.DuckVariant;
import aqario.fowlplay.common.entity.GooseVariant;
import aqario.fowlplay.common.entity.GullVariant;
import aqario.fowlplay.common.entity.PigeonVariant;
import aqario.fowlplay.common.entity.SparrowVariant;
import aqario.fowlplay.common.world.gen.PigeonSpawner;
import aqario.fowlplay.common.world.gen.SparrowSpawner;
import aqario.fowlplay.core.FowlPlayActivities;
import aqario.fowlplay.core.FowlPlayEntityType;
import aqario.fowlplay.core.FowlPlayItems;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlayParticleTypes;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.FowlPlayRegistryKeys;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySensorType;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.FowlPlayTrackedDataHandlerRegistry;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import net.minecraft.server.level.ServerLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FowlPlay {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fowl Play");
    public static final String ID = "fowlplay";

    public static boolean isDebugUtilsLoaded() {
        return Platform.isModLoaded((String)"debugutils");
    }

    public static void earlyInit() {
        Mod mod = Platform.getMod((String)ID);
        LOGGER.info("Loading {} {}", (Object)mod.getName(), (Object)mod.getVersion());
        FowlPlayConfig.load();
        FowlPlayRegistryKeys.init();
        FowlPlayRegistries.init();
    }

    public static void init() {
        ChickenVariant.init();
        DuckVariant.init();
        GooseVariant.init();
        GullVariant.init();
        PigeonVariant.init();
        SparrowVariant.init();
        FowlPlayActivities.init();
        FowlPlayEntityType.init();
        FowlPlayItems.init();
        FowlPlayMemoryModuleType.init();
        FowlPlayParticleTypes.init();
        FowlPlaySchedules.init();
        FowlPlaySensorType.init();
        FowlPlaySoundEvents.init();
        FowlPlayTrackedDataHandlerRegistry.init();
        FowlPlay.initSpawners();
    }

    private static void initSpawners() {
        PigeonSpawner pigeonSpawner = new PigeonSpawner();
        SparrowSpawner sparrowSpawner = new SparrowSpawner();
        TickEvent.SERVER_LEVEL_POST.register(world -> {
            pigeonSpawner.m_7995_((ServerLevel)world, world.m_7654_().m_7004_(), world.m_7654_().m_6998_());
            sparrowSpawner.m_7995_((ServerLevel)world, world.m_7654_().m_7004_(), world.m_7654_().m_6998_());
        });
    }
}

