/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.core;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BlueJayEntity;
import aqario.fowlplay.common.entity.CardinalEntity;
import aqario.fowlplay.common.entity.ChickadeeEntity;
import aqario.fowlplay.common.entity.CrowEntity;
import aqario.fowlplay.common.entity.DuckEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.GooseEntity;
import aqario.fowlplay.common.entity.GullEntity;
import aqario.fowlplay.common.entity.HawkEntity;
import aqario.fowlplay.common.entity.PenguinEntity;
import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.RavenEntity;
import aqario.fowlplay.common.entity.RobinEntity;
import aqario.fowlplay.common.entity.ScarecrowEntity;
import aqario.fowlplay.common.entity.SparrowEntity;
import aqario.fowlplay.common.util.EntityTypeBuilder;
import aqario.fowlplay.core.platform.CustomSpawnGroup;
import aqario.fowlplay.core.platform.CustomSpawnLocation;
import aqario.fowlplay.core.platform.PlatformHelper;
import aqario.fowlplay.core.tags.FowlPlayBiomeTags;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;

public final class FowlPlayEntityType {
    public static final Supplier<EntityType<BlueJayEntity>> BLUE_JAY = FowlPlayEntityType.register("blue_jay", EntityTypeBuilder.create(BlueJayEntity::new, CustomSpawnGroup.ambientBirds()).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f));
    public static final Supplier<EntityType<CardinalEntity>> CARDINAL = FowlPlayEntityType.register("cardinal", EntityTypeBuilder.create(CardinalEntity::new, CustomSpawnGroup.ambientBirds()).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f));
    public static final Supplier<EntityType<ChickadeeEntity>> CHICKADEE = FowlPlayEntityType.register("chickadee", EntityTypeBuilder.create(ChickadeeEntity::new, CustomSpawnGroup.ambientBirds()).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.3f, 0.45f));
    public static final Supplier<EntityType<CrowEntity>> CROW = FowlPlayEntityType.register("crow", EntityTypeBuilder.create(CrowEntity::new, CustomSpawnGroup.ambientBirds()).attributes(CrowEntity::createCrowAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.5f, 0.6f));
    public static final Supplier<EntityType<DuckEntity>> DUCK = FowlPlayEntityType.register("duck", EntityTypeBuilder.create(DuckEntity::new, CustomSpawnGroup.birds()).attributes(DuckEntity::createDuckAttributes).spawnRestriction(CustomSpawnLocation.aquatic(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnWaterfowl).dimensions(0.6f, 0.8f));
    public static final Supplier<EntityType<GooseEntity>> GOOSE = FowlPlayEntityType.register("goose", EntityTypeBuilder.create(GooseEntity::new, CustomSpawnGroup.birds()).attributes(GooseEntity::createGooseAttributes).spawnRestriction(CustomSpawnLocation.aquatic(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnWaterfowl).dimensions(0.8f, 1.0f));
    public static final Supplier<EntityType<GullEntity>> GULL = FowlPlayEntityType.register("gull", EntityTypeBuilder.create(GullEntity::new, CustomSpawnGroup.birds()).attributes(GullEntity::createGullAttributes).spawnRestriction(CustomSpawnLocation.semiaquatic(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnShorebirds).dimensions(0.6f, 0.8f));
    public static final Supplier<EntityType<HawkEntity>> HAWK = FowlPlayEntityType.register("hawk", EntityTypeBuilder.create(HawkEntity::new, CustomSpawnGroup.birds()).attributes(HawkEntity::createHawkAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.6f, 0.8f));
    public static final Supplier<EntityType<PenguinEntity>> PENGUIN = FowlPlayEntityType.register("penguin", EntityTypeBuilder.create(PenguinEntity::new, MobCategory.CREATURE).attributes(PenguinEntity::createPenguinAttributes).spawnRestriction(CustomSpawnLocation.semiaquatic(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PenguinEntity::canSpawnPenguins).dimensions(0.5f, 1.4f));
    public static final Supplier<EntityType<PigeonEntity>> PIGEON = FowlPlayEntityType.register("pigeon", EntityTypeBuilder.create(PigeonEntity::new, CustomSpawnGroup.birds()).attributes(PigeonEntity::createPigeonAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnShorebirds).dimensions(0.5f, 0.6f));
    public static final Supplier<EntityType<RavenEntity>> RAVEN = FowlPlayEntityType.register("raven", EntityTypeBuilder.create(RavenEntity::new, CustomSpawnGroup.ambientBirds()).attributes(RavenEntity::createRavenAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.6f, 0.8f));
    public static final Supplier<EntityType<RobinEntity>> ROBIN = FowlPlayEntityType.register("robin", EntityTypeBuilder.create(RobinEntity::new, CustomSpawnGroup.ambientBirds()).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f));
    public static final Supplier<EntityType<SparrowEntity>> SPARROW = FowlPlayEntityType.register("sparrow", EntityTypeBuilder.create(SparrowEntity::new, CustomSpawnGroup.ambientBirds()).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocation.ground(), Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.3f, 0.45f));
    public static final Supplier<EntityType<ScarecrowEntity>> SCARECROW = FowlPlayEntityType.register("scarecrow", EntityTypeBuilder.create(ScarecrowEntity::new, MobCategory.MISC).attributes(ScarecrowEntity::createScarecrowAttributes).dimensions(0.6f, 2.0f));

    private static <T extends Entity> Supplier<EntityType<T>> register(String id, EntityTypeBuilder<T> builder) {
        return PlatformHelper.registerEntityType(id, () -> builder.build(id));
    }

    public static void init() {
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_BLUE_JAYS, CustomSpawnGroup.ambientBirds(), BLUE_JAY, FowlPlayConfig.getInstance().blueJaySpawnWeight, FowlPlayConfig.getInstance().blueJayMinGroupSize, FowlPlayConfig.getInstance().blueJayMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CARDINALS, CustomSpawnGroup.ambientBirds(), CARDINAL, FowlPlayConfig.getInstance().cardinalSpawnWeight, FowlPlayConfig.getInstance().cardinalMinGroupSize, FowlPlayConfig.getInstance().cardinalMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CHICKADEES, CustomSpawnGroup.ambientBirds(), CHICKADEE, FowlPlayConfig.getInstance().chickadeeSpawnWeight, FowlPlayConfig.getInstance().chickadeeMinGroupSize, FowlPlayConfig.getInstance().chickadeeMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CROWS, CustomSpawnGroup.ambientBirds(), CROW, FowlPlayConfig.getInstance().crowSpawnWeight, FowlPlayConfig.getInstance().crowMinGroupSize, FowlPlayConfig.getInstance().crowMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_DUCKS, CustomSpawnGroup.birds(), DUCK, FowlPlayConfig.getInstance().duckSpawnWeight, FowlPlayConfig.getInstance().duckMinGroupSize, FowlPlayConfig.getInstance().duckMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_GEESE, CustomSpawnGroup.birds(), GOOSE, FowlPlayConfig.getInstance().gooseSpawnWeight, FowlPlayConfig.getInstance().gooseMinGroupSize, FowlPlayConfig.getInstance().gooseMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_GULLS, CustomSpawnGroup.birds(), GULL, FowlPlayConfig.getInstance().gullSpawnWeight, FowlPlayConfig.getInstance().gullMinGroupSize, FowlPlayConfig.getInstance().gullMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_HAWKS, CustomSpawnGroup.birds(), HAWK, FowlPlayConfig.getInstance().hawkSpawnWeight, FowlPlayConfig.getInstance().hawkMinGroupSize, FowlPlayConfig.getInstance().hawkMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_PENGUINS, MobCategory.CREATURE, PENGUIN, FowlPlayConfig.getInstance().penguinSpawnWeight, FowlPlayConfig.getInstance().penguinMinGroupSize, FowlPlayConfig.getInstance().penguinMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_PIGEONS, CustomSpawnGroup.birds(), PIGEON, FowlPlayConfig.getInstance().pigeonSpawnWeight, FowlPlayConfig.getInstance().pigeonMinGroupSize, FowlPlayConfig.getInstance().pigeonMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_RAVENS, CustomSpawnGroup.ambientBirds(), RAVEN, FowlPlayConfig.getInstance().ravenSpawnWeight, FowlPlayConfig.getInstance().ravenMinGroupSize, FowlPlayConfig.getInstance().ravenMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_ROBINS, CustomSpawnGroup.ambientBirds(), ROBIN, FowlPlayConfig.getInstance().robinSpawnWeight, FowlPlayConfig.getInstance().robinMinGroupSize, FowlPlayConfig.getInstance().robinMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_SPARROWS, CustomSpawnGroup.ambientBirds(), SPARROW, FowlPlayConfig.getInstance().sparrowSpawnWeight, FowlPlayConfig.getInstance().sparrowMinGroupSize, FowlPlayConfig.getInstance().sparrowMaxGroupSize);
        FowlPlayEntityType.setSpawnCost(FowlPlayBiomeTags.SPAWNS_DUCKS, DUCK, 0.8, 0.1);
        FowlPlayEntityType.setSpawnCost(FowlPlayBiomeTags.SPAWNS_GULLS, GULL, 1.0, 0.07);
    }

    public static <T extends Entity> void addSpawn(TagKey<Biome> tag, MobCategory spawnGroup, Supplier<EntityType<T>> type, int weight, int minGroupSize, int maxGroupSize) {
        BiomeModifications.addProperties(context -> context.hasTag(tag), (context, mutable) -> mutable.getSpawnProperties().addSpawn(spawnGroup, new MobSpawnSettings.SpawnerData((EntityType)type.get(), weight, minGroupSize, maxGroupSize)));
    }

    public static <T extends Entity> void setSpawnCost(TagKey<Biome> tag, Supplier<EntityType<T>> type, double gravityLimit, double mass) {
        BiomeModifications.addProperties(context -> context.hasTag(tag), (context, mutable) -> mutable.getSpawnProperties().setSpawnCost((EntityType)type.get(), new MobSpawnSettings.MobSpawnCost(gravityLimit, mass)));
    }
}

