/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity;

import aqario.fowlplay.client.render.entity.feature.BirdHeldItemFeatureRenderer;
import aqario.fowlplay.client.render.entity.model.AdultBabyModelPair;
import aqario.fowlplay.client.render.entity.model.BabyPenguinEntityModel;
import aqario.fowlplay.client.render.entity.model.PenguinEntityModel;
import aqario.fowlplay.common.entity.PenguinEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class PenguinEntityRenderer
extends MobRenderer<PenguinEntity, PenguinEntityModel> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fowlplay", (String)"textures/entity/penguin/penguin.png");
    private static final ResourceLocation BABY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fowlplay", (String)"textures/entity/penguin/penguin_baby.png");
    private final AdultBabyModelPair<PenguinEntityModel> modelPair;

    public PenguinEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PenguinEntityModel(context.bakeLayer(PenguinEntityModel.MODEL_LAYER)), 0.3f);
        this.addLayer(new BirdHeldItemFeatureRenderer(this, context.getItemInHandRenderer(), new Vec3(0.0, -0.145, -0.1475)));
        this.modelPair = PenguinEntityRenderer.bakeModels(context);
    }

    private static AdultBabyModelPair<PenguinEntityModel> bakeModels(EntityRendererProvider.Context context) {
        return AdultBabyModelPair.of(new PenguinEntityModel(context.bakeLayer(PenguinEntityModel.MODEL_LAYER)), new BabyPenguinEntityModel(context.bakeLayer(BabyPenguinEntityModel.MODEL_LAYER)));
    }

    public void render(PenguinEntity penguin, float f, float g, PoseStack matrices, MultiBufferSource vertexConsumerProvider, int i) {
        this.model = (EntityModel)this.modelPair.getModel(penguin.isBaby());
        if (penguin.isBaby()) {
            matrices.scale(0.8f, 0.8f, 0.8f);
        }
        super.render((LivingEntity)penguin, f, g, matrices, vertexConsumerProvider, i);
    }

    public ResourceLocation getTexture(PenguinEntity entity) {
        return entity.isBaby() ? BABY_TEXTURE : TEXTURE;
    }

    protected void scale(PenguinEntity penguin, PoseStack matrices, float amount) {
        super.scale((LivingEntity)penguin, matrices, amount);
        String name = ChatFormatting.stripFormatting((String)penguin.getName().getString());
        if (name.equalsIgnoreCase("rico")) {
            matrices.scale(1.1f, 1.0f, 1.0f);
        }
        if (name.equalsIgnoreCase("skipper")) {
            matrices.scale(1.25f, 0.9f, 1.0f);
        }
        if (name.equalsIgnoreCase("kowalski")) {
            matrices.scale(1.0f, 1.1f, 1.0f);
        }
        if (name.equalsIgnoreCase("private")) {
            matrices.scale(1.2f, 0.85f, 1.0f);
        }
    }
}

