/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity;

import aqario.fowlplay.client.render.entity.feature.BirdHeldItemFeatureRenderer;
import aqario.fowlplay.client.render.entity.feature.PigeonBundleFeatureRenderer;
import aqario.fowlplay.client.render.entity.model.PigeonEntityModel;
import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.PigeonVariant;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class PigeonEntityRenderer
extends MobRenderer<PigeonEntity, PigeonEntityModel> {
    private static final ResourceLocation MARTHA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fowlplay", (String)"textures/entity/pigeon/martha.png");

    public PigeonEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PigeonEntityModel(context.bakeLayer(PigeonEntityModel.MODEL_LAYER)), 0.2f);
        this.addLayer(new BirdHeldItemFeatureRenderer(this, context.getItemInHandRenderer(), new Vec3(0.0, -0.0225, -0.1475)));
        this.addLayer(new PigeonBundleFeatureRenderer((RenderLayerParent<PigeonEntity, PigeonEntityModel>)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTexture(PigeonEntity pigeon) {
        String string = ChatFormatting.stripFormatting((String)pigeon.getName().getString());
        if ("Martha".equals(string)) {
            return MARTHA_TEXTURE;
        }
        return ((PigeonVariant)pigeon.getVariant().value()).texture();
    }
}

