/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.feature;

import aqario.fowlplay.client.render.entity.model.BirdEntityModel;
import aqario.fowlplay.common.entity.BirdEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class BirdHeldItemFeatureRenderer<E extends BirdEntity, M extends BirdEntityModel<E>>
extends RenderLayer<E, M> {
    private final ItemInHandRenderer itemRenderer;
    private final Vec3 heldItemOffset;

    public BirdHeldItemFeatureRenderer(RenderLayerParent<E, M> context, ItemInHandRenderer heldItemRenderer, Vec3 heldItemOffset) {
        super(context);
        this.itemRenderer = heldItemRenderer;
        this.heldItemOffset = heldItemOffset;
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, E bird, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        matrices.pushPose();
        matrices.translate(((BirdEntityModel)this.getParentModel()).root.x / 16.0f, ((BirdEntityModel)this.getParentModel()).root.y / 16.0f, ((BirdEntityModel)this.getParentModel()).root.z / 16.0f);
        matrices.mulPose(Axis.ZP.rotation(((BirdEntityModel)this.getParentModel()).root.storePose().zRot));
        matrices.mulPose(Axis.YP.rotation(((BirdEntityModel)this.getParentModel()).root.storePose().yRot));
        matrices.mulPose(Axis.XP.rotation(((BirdEntityModel)this.getParentModel()).root.storePose().xRot));
        matrices.translate(((BirdEntityModel)this.getParentModel()).body.x / 16.0f, ((BirdEntityModel)this.getParentModel()).body.y / 16.0f, ((BirdEntityModel)this.getParentModel()).body.z / 16.0f);
        matrices.mulPose(Axis.ZP.rotation(((BirdEntityModel)this.getParentModel()).body.storePose().zRot));
        matrices.mulPose(Axis.YP.rotation(((BirdEntityModel)this.getParentModel()).body.storePose().yRot));
        matrices.mulPose(Axis.XP.rotation(((BirdEntityModel)this.getParentModel()).body.storePose().xRot));
        matrices.translate(((BirdEntityModel)this.getParentModel()).neck.x / 16.0f, ((BirdEntityModel)this.getParentModel()).neck.y / 16.0f, ((BirdEntityModel)this.getParentModel()).neck.z / 16.0f);
        matrices.mulPose(Axis.ZP.rotation(((BirdEntityModel)this.getParentModel()).neck.storePose().zRot));
        matrices.mulPose(Axis.YP.rotation(((BirdEntityModel)this.getParentModel()).neck.storePose().yRot));
        matrices.mulPose(Axis.XP.rotation(((BirdEntityModel)this.getParentModel()).neck.storePose().xRot));
        matrices.translate(((BirdEntityModel)this.getParentModel()).head.x / 16.0f, ((BirdEntityModel)this.getParentModel()).head.y / 16.0f, ((BirdEntityModel)this.getParentModel()).head.z / 16.0f);
        matrices.mulPose(Axis.ZP.rotation(((BirdEntityModel)this.getParentModel()).head.storePose().zRot));
        matrices.mulPose(Axis.YP.rotation(((BirdEntityModel)this.getParentModel()).head.storePose().yRot));
        matrices.mulPose(Axis.XP.rotation(((BirdEntityModel)this.getParentModel()).head.storePose().xRot));
        matrices.translate(this.heldItemOffset.x, this.heldItemOffset.y, this.heldItemOffset.z);
        matrices.mulPose(Axis.XN.rotationDegrees(90.0f));
        matrices.scale(0.5f, 0.5f, 0.5f);
        ItemStack stack = bird.getItemBySlot(EquipmentSlot.MAINHAND);
        this.itemRenderer.renderItem(bird, stack, ItemDisplayContext.GROUND, false, matrices, vertexConsumers, light);
        matrices.popPose();
    }
}

