/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.ChickenAnimations;
import aqario.fowlplay.common.util.ChickenAnimationStates;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Chicken;

public class CustomChickenEntityModel
extends HierarchicalModel<Chicken> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"fowlplay", (String)"chicken"), "main");
    public final ModelPart root;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart torso;
    public final ModelPart leftWing;
    public final ModelPart rightWing;
    public final ModelPart leftWingOpen;
    public final ModelPart rightWingOpen;
    public final ModelPart leftLeg;
    public final ModelPart rightLeg;
    public final ModelPart tail;

    public CustomChickenEntityModel(ModelPart root) {
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.torso = this.body.getChild("torso");
        this.leftWing = this.body.getChild("left_wing");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWingOpen = this.body.getChild("left_wing_open");
        this.rightWingOpen = this.body.getChild("right_wing_open");
        this.leftLeg = this.root.getChild("left_leg");
        this.rightLeg = this.root.getChild("right_leg");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.5f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 21).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, -3).addBox(0.0f, -7.0f, -2.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(0.5f, -4.0f, -2.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(-0.5f, -4.0f, -2.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-2.5f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(15, 4).addBox(-0.5f, -0.5f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-1.0f));
        body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.5f, -6.5f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.95f, (float)2.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 11).addBox(-0.75f, -1.0f, -0.5f, 1.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.25f, (float)-3.55f, (float)-1.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 11).mirror().addBox(-0.25f, -1.0f, -0.5f, 1.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.25f, (float)-3.55f, (float)-1.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(8, 19).addBox(-0.5f, 0.0f, -1.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-4.25f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(2, 26).addBox(0.0f, 0.0f, 0.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)0.0f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(8, 19).mirror().addBox(-4.5f, 0.0f, -1.0f, 5.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-4.25f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(2, 26).mirror().addBox(-5.0f, 0.0f, 0.0f, 5.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.5f, (float)0.0f, (float)-1.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(15, 0).addBox(-1.0f, -1.0f, 1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, -1).addBox(0.0f, -6.0f, 1.0f, 0.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 4).addBox(-0.5f, 1.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.25f, (float)1.0f, (float)1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 5).mirror().addBox(0.5f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)4.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 4).addBox(-0.5f, 1.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.25f, (float)1.0f, (float)1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 5).addBox(-0.5f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    public void setAngles(Chicken chicken, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updateHeadRotation(netHeadYaw, headPitch);
        if (chicken.onGround() || chicken.isInWaterOrBubble()) {
            this.leftWingOpen.visible = false;
            this.rightWingOpen.visible = false;
            this.leftWing.visible = true;
            this.rightWing.visible = true;
        } else {
            this.leftWingOpen.visible = true;
            this.rightWingOpen.visible = true;
            this.leftWing.visible = false;
            this.rightWing.visible = false;
        }
        if (chicken.onGround() && !chicken.isInWaterOrBubble()) {
            this.animateWalk(ChickenAnimations.WALKING, limbSwing, limbSwingAmount, 3.0f, 3.0f);
        }
        this.animate(((ChickenAnimationStates)chicken).fowlplay$getStandingState(), ChickenAnimations.STANDING, ageInTicks);
        this.animate(((ChickenAnimationStates)chicken).fowlplay$getFlappingState(), ChickenAnimations.FLAPPING, ageInTicks);
        this.animate(((ChickenAnimationStates)chicken).fowlplay$getFloatingState(), ChickenAnimations.FLOATING, ageInTicks);
    }

    private void updateHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-135.0f, (float)135.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart root() {
        return this.root;
    }
}

