/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.task;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.task.LookAroundTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetItemWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetPerchWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetWalkTargetAwayFromTask;
import aqario.fowlplay.common.util.Birds;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomSwimTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;

public class CompositeTasks {
    public static <E extends BirdEntity> ExtendedBehaviour<E> setWaterfowlForagingTarget() {
        return new SetRandomSwimTarget().setRadius(24.0, 8.0).swimTargetPredicate((entity, target) -> target != null && entity.level().isWaterAt(BlockPos.containing((Position)target).below()));
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> setWaterWalkTarget() {
        return new SetRandomSwimTarget().setRadius(64.0, 32.0).swimTargetPredicate((entity, target) -> target != null && entity.level().isWaterAt(BlockPos.containing((Position)target).below())).startCondition(Predicate.not(Entity::isInWaterOrBubble));
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> setNearestFoodWalkTarget() {
        return new SetItemWalkTargetTask().radius(32).speedModifier(1.4f).startCondition(Birds::canPickupFood);
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> setAvoidEntityWalkTarget() {
        return new SetWalkTargetAwayFromTask(MemoryModuleType.AVOID_TARGET, Entity::position).speedModifier(1.4f);
    }

    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> idleIfPerched() {
        return new Idle().noTimeout().startCondition(Birds::isPerched).stopIf(Predicate.not(Birds::isPerched));
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> idleIfInWater() {
        return new Idle().noTimeout().startCondition(Entity::isInWaterOrBubble).stopIf(Predicate.not(Entity::isInWaterOrBubble));
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> forgetUnderwaterAttackTarget() {
        return new InvalidateMemory(MemoryModuleType.ATTACK_TARGET).invalidateIf((entity, target) -> entity.isInWaterOrBubble() && target.isUnderWater() && target.position().y < entity.position().y);
    }

    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> tryPerch() {
        return new OneRandomBehaviour(new Pair[]{Pair.of((Object)new OneRandomBehaviour(new ExtendedBehaviour[]{new LookAroundTask(), new Idle().runForBetween(100, 200)}).runForBetween(30, 100).startCondition(Birds::isPerched).stopIf(Predicate.not(Birds::isPerched)), (Object)8), Pair.of(new SetPerchWalkTargetTask(), (Object)1)});
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> tryForage() {
        return new OneRandomBehaviour(new Pair[]{Pair.of((Object)new OneRandomBehaviour(new ExtendedBehaviour[]{new LookAroundTask(), new Idle().runForBetween(100, 200)}).runForBetween(30, 100).startCondition(Entity::onGround).stopIf(Predicate.not(Entity::onGround)), (Object)2), Pair.of((Object)new SetRandomWalkTarget().setRadius(32.0, 16.0).walkTargetPredicate((entity, target) -> target != null && !entity.level().isEmptyBlock(BlockPos.containing((Position)target).below())), (Object)1)});
    }
}

