/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.control;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.util.Birds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BirdMoveControl
extends MoveControl {
    protected final BirdEntity bird;
    private static final double DECELERATE_DISTANCE = 3.0;

    public BirdMoveControl(BirdEntity bird) {
        super((Mob)bird);
        this.bird = bird;
    }

    public void tick() {
        FlyingBirdEntity flyingBird;
        BirdEntity birdEntity = this.bird;
        if (birdEntity instanceof FlyingBirdEntity && (flyingBird = (FlyingBirdEntity)birdEntity).isFlying()) {
            this.tickFlying();
        } else {
            super.tick();
        }
    }

    private void tickFlying() {
        double dist;
        this.operation = MoveControl.Operation.MOVE_TO;
        FlyingBirdEntity bird = (FlyingBirdEntity)this.bird;
        Vec3 distance = new Vec3(this.wantedX - bird.getX(), this.wantedY - bird.getY(), this.wantedZ - bird.getZ());
        double squaredDistance = distance.lengthSqr();
        if (squaredDistance < 2.500000277905201E-7) {
            bird.setZza(0.0f);
            return;
        }
        float yaw = (float)(Mth.atan2((double)distance.z, (double)distance.x) * 180.0 / 3.1415927410125732) - 90.0f;
        bird.setYRot(this.rotlerp(bird.getYRot(), yaw, 25.0f));
        bird.yBodyRot = bird.getYRot();
        bird.yHeadRot = bird.getYRot();
        float speed = (float)bird.getAttributeValue(Attributes.FLYING_SPEED) * 2.0f;
        BlockPos destination = bird.getNavigation().getTargetPos();
        if (destination != null && Birds.shouldLandAtDestination(bird, destination) && (dist = bird.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)destination))) < 9.0) {
            speed *= (float)BirdMoveControl.decelerate(dist);
        }
        bird.setSpeed(speed);
        double horizontalDistance = Math.sqrt(distance.x * distance.x + distance.z * distance.z);
        if (Math.abs(distance.y) > (double)1.0E-5f || Math.abs(horizontalDistance) > (double)1.0E-5f) {
            float pitch = -((float)(Mth.atan2((double)distance.y, (double)horizontalDistance) * 180.0 / Math.PI));
            pitch = Mth.clamp((float)Mth.wrapDegrees((float)pitch), (float)(-bird.getMaxHeadXRot()), (float)bird.getMaxHeadXRot());
            bird.setXRot(this.rotlerp(bird.getXRot(), pitch, 25.0f));
        }
        float x = Mth.cos((float)(bird.getXRot() * ((float)Math.PI / 180)));
        float y = Mth.sin((float)(bird.getXRot() * ((float)Math.PI / 180)));
        bird.zza = x * speed;
        bird.yya = -y * speed;
    }

    private static double decelerate(double x) {
        return Math.max(0.1111111111111111 * x, 0.25);
    }

    private void tickWalking() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            Vec3 distance = new Vec3(this.wantedX - this.bird.getX(), this.wantedY - this.bird.getY(), this.wantedZ - this.bird.getZ());
            if (distance.lengthSqr() < 2.500000277905201E-7) {
                this.bird.setZza(0.0f);
                this.operation = MoveControl.Operation.WAIT;
                return;
            }
            float angle = (float)(Mth.atan2((double)distance.z, (double)distance.x) * 180.0 / 3.1415927410125732) - 90.0f;
            this.bird.setYRot(this.rotlerp(this.bird.getYRot(), angle, 15.0f));
            this.bird.setSpeed((float)(this.speedModifier * this.bird.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            BlockPos pos = this.bird.blockPosition();
            BlockState state = this.bird.level().getBlockState(pos);
            VoxelShape collisionShape = state.getCollisionShape((BlockGetter)this.bird.level(), pos);
            double horizontalSqDistance = distance.x * distance.x + distance.z * distance.z;
            if (distance.y > (double)this.bird.maxUpStep() && horizontalSqDistance < (double)Math.max(1.0f, this.bird.getBbWidth()) || !collisionShape.isEmpty() && this.bird.getY() < collisionShape.max(Direction.Axis.Y) + (double)pos.getY() && !state.is(BlockTags.DOORS) && !state.is(BlockTags.FENCES)) {
                this.bird.getJumpControl().jump();
                this.operation = MoveControl.Operation.JUMPING;
            }
            if (distance.y < (double)this.bird.maxUpStep() && horizontalSqDistance < (double)Math.max(1.0f, this.bird.getBbWidth()) || !collisionShape.isEmpty() && this.bird.getY() > collisionShape.max(Direction.Axis.Y) + (double)pos.getY() && !state.is(BlockTags.DOORS) && !state.is(BlockTags.FENCES)) {
                this.bird.setShiftKeyDown(true);
            }
        } else if (this.operation == MoveControl.Operation.JUMPING) {
            this.bird.setSpeed((float)(this.speedModifier * this.bird.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            if (this.bird.onGround()) {
                this.operation = MoveControl.Operation.WAIT;
            }
        } else if (this.operation == MoveControl.Operation.STRAFE) {
            this.operation = MoveControl.Operation.WAIT;
        } else {
            this.bird.setZza(0.0f);
        }
    }
}

