/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import aqario.fowlplay.common.entity.BirdEntity;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityTypeBuilder<T extends Entity> {
    private final EntityType.EntityFactory<T> factory;
    private final MobCategory spawnGroup;
    private ImmutableSet<Block> canSpawnInside = ImmutableSet.of();
    private boolean saveable = true;
    private boolean summonable = true;
    private boolean fireImmune;
    private boolean spawnableFarFromPlayer;
    private int maxTrackingRange = 5;
    private int trackingTickInterval = 3;
    private EntityDimensions dimensions = EntityDimensions.scalable((float)0.6f, (float)1.8f);
    private float spawnBoxScale = 1.0f;
    private EntityAttachments.Builder attachments = EntityAttachments.builder();
    private FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;
    @Nullable
    private Supplier<AttributeSupplier.Builder> attributeBuilder;
    private SpawnPlacementType location;
    private Heightmap.Types heightmap;
    private SpawnPlacements.SpawnPredicate<T> spawnPredicate;

    private EntityTypeBuilder(EntityType.EntityFactory<T> factory, MobCategory spawnGroup) {
        this.factory = factory;
        this.spawnGroup = spawnGroup;
        this.spawnableFarFromPlayer = spawnGroup == MobCategory.CREATURE || spawnGroup == MobCategory.MISC;
    }

    public static <T extends BirdEntity> EntityTypeBuilder<T> create(EntityType.EntityFactory<T> factory, MobCategory spawnGroup) {
        return new EntityTypeBuilder<T>(factory, spawnGroup);
    }

    public static <T extends BirdEntity> EntityTypeBuilder<T> create(MobCategory spawnGroup) {
        return new EntityTypeBuilder<T>((type, world) -> null, spawnGroup);
    }

    public EntityTypeBuilder<T> dimensions(float width, float height) {
        this.dimensions = EntityDimensions.scalable((float)width, (float)height);
        return this;
    }

    public EntityTypeBuilder<T> spawnBoxScale(float spawnBoxScale) {
        this.spawnBoxScale = spawnBoxScale;
        return this;
    }

    public EntityTypeBuilder<T> eyeHeight(float eyeHeight) {
        this.dimensions = this.dimensions.withEyeHeight(eyeHeight);
        return this;
    }

    public EntityTypeBuilder<T> passengerAttachments(float ... offsetYs) {
        for (float f : offsetYs) {
            this.attachments = this.attachments.attach(EntityAttachment.PASSENGER, 0.0f, f, 0.0f);
        }
        return this;
    }

    public EntityTypeBuilder<T> passengerAttachments(Vec3 ... passengerAttachments) {
        for (Vec3 vec3d : passengerAttachments) {
            this.attachments = this.attachments.attach(EntityAttachment.PASSENGER, vec3d);
        }
        return this;
    }

    public EntityTypeBuilder<T> vehicleAttachment(Vec3 vehicleAttachment) {
        return this.attachment(EntityAttachment.VEHICLE, vehicleAttachment);
    }

    public EntityTypeBuilder<T> vehicleAttachment(float offsetY) {
        return this.attachment(EntityAttachment.VEHICLE, 0.0f, -offsetY, 0.0f);
    }

    public EntityTypeBuilder<T> nameTagAttachment(float offsetY) {
        return this.attachment(EntityAttachment.NAME_TAG, 0.0f, offsetY, 0.0f);
    }

    public EntityTypeBuilder<T> attachment(EntityAttachment type, float offsetX, float offsetY, float offsetZ) {
        this.attachments = this.attachments.attach(type, offsetX, offsetY, offsetZ);
        return this;
    }

    public EntityTypeBuilder<T> attachment(EntityAttachment type, Vec3 offset) {
        this.attachments = this.attachments.attach(type, offset);
        return this;
    }

    public EntityTypeBuilder<T> disableSummon() {
        this.summonable = false;
        return this;
    }

    public EntityTypeBuilder<T> disableSaving() {
        this.saveable = false;
        return this;
    }

    public EntityTypeBuilder<T> makeFireImmune() {
        this.fireImmune = true;
        return this;
    }

    public EntityTypeBuilder<T> allowSpawningInside(Block ... blocks) {
        this.canSpawnInside = ImmutableSet.copyOf((Object[])blocks);
        return this;
    }

    public EntityTypeBuilder<T> spawnableFarFromPlayer() {
        this.spawnableFarFromPlayer = true;
        return this;
    }

    public EntityTypeBuilder<T> maxTrackingRange(int maxTrackingRange) {
        this.maxTrackingRange = maxTrackingRange;
        return this;
    }

    public EntityTypeBuilder<T> trackingTickInterval(int trackingTickInterval) {
        this.trackingTickInterval = trackingTickInterval;
        return this;
    }

    public EntityTypeBuilder<T> requires(FeatureFlag ... features) {
        this.requiredFeatures = FeatureFlags.REGISTRY.subset(features);
        return this;
    }

    public EntityTypeBuilder<T> attributes(Supplier<AttributeSupplier.Builder> attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
        return this;
    }

    public EntityTypeBuilder<T> spawnRestriction(SpawnPlacementType location, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        this.location = location;
        this.heightmap = heightmap;
        this.spawnPredicate = spawnPredicate;
        return this;
    }

    public EntityType<T> build() {
        return this.build(null);
    }

    public EntityType<T> build(String id) {
        EntityType type;
        if (this.saveable) {
            Util.fetchChoiceType((DSL.TypeReference)References.ENTITY_TREE, (String)id);
        }
        if ((type = new EntityType(this.factory, this.spawnGroup, this.saveable, this.summonable, this.fireImmune, this.spawnableFarFromPlayer, this.canSpawnInside, this.dimensions.withAttachments(this.attachments), this.spawnBoxScale, this.maxTrackingRange, this.trackingTickInterval, this.requiredFeatures)).getBaseClass().isAssignableFrom(LivingEntity.class) && this.attributeBuilder != null) {
            EntityAttributeRegistry.register(() -> type, this.attributeBuilder);
        }
        if (type.getBaseClass().isAssignableFrom(Mob.class) && this.spawnPredicate != null) {
            SpawnPlacementsRegistry.register(() -> type, (SpawnPlacementType)this.location, (Heightmap.Types)this.heightmap, this.spawnPredicate);
        }
        return type;
    }
}

