/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.world.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public interface CustomSpawnLocations {
    public static final SpawnPlacementType GROUND = new SpawnPlacementType(){

        public boolean isSpawnPositionOk(LevelReader worldView, BlockPos spawnPos, @Nullable EntityType<?> entityType) {
            return CustomSpawnLocations.spawnsOnGround(worldView, spawnPos, entityType);
        }

        public BlockPos adjustSpawnPosition(LevelReader world, BlockPos pos) {
            BlockPos blockPos = pos.below();
            return world.getBlockState(blockPos).isPathfindable(PathComputationType.LAND) ? blockPos : pos;
        }
    };
    public static final SpawnPlacementType SEMIAQUATIC = new SpawnPlacementType(){

        public boolean isSpawnPositionOk(LevelReader worldView, BlockPos spawnPos, @Nullable EntityType<?> entityType) {
            return CustomSpawnLocations.spawnsOnWater(worldView, spawnPos, entityType) || CustomSpawnLocations.spawnsOnGround(worldView, spawnPos, entityType);
        }

        public BlockPos adjustSpawnPosition(LevelReader world, BlockPos pos) {
            BlockPos groundPos = pos.below();
            return world.getBlockState(groundPos).isPathfindable(PathComputationType.LAND) ? groundPos : pos;
        }
    };
    public static final SpawnPlacementType AQUATIC = CustomSpawnLocations::spawnsOnWater;

    private static boolean isClearForSpawn(LevelReader world, BlockPos pos, EntityType<?> entityType) {
        BlockState blockState = world.getBlockState(pos);
        return NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)world, (BlockPos)pos, (BlockState)blockState, (FluidState)blockState.getFluidState(), entityType);
    }

    private static boolean spawnsOnGround(LevelReader world, BlockPos spawnPos, EntityType<?> entityType) {
        if (entityType != null && world.getWorldBorder().isWithinBounds(spawnPos)) {
            BlockPos headPos = spawnPos.above();
            return CustomSpawnLocations.isClearForSpawn(world, spawnPos, entityType) && (entityType.getHeight() <= 1.0f || CustomSpawnLocations.isClearForSpawn(world, headPos, entityType));
        }
        return false;
    }

    private static boolean spawnsOnWater(LevelReader world, BlockPos spawnPos, EntityType<?> entityType) {
        if (entityType != null && world.getWorldBorder().isWithinBounds(spawnPos)) {
            BlockPos headPos = spawnPos.above();
            return world.getFluidState(spawnPos.below()).is(FluidTags.WATER) && (entityType.getHeight() <= 1.0f || CustomSpawnLocations.isClearForSpawn(world, headPos, entityType));
        }
        return false;
    }
}

