/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.debug;

import aqario.fowlplay.client.FowlPlayClient;
import aqario.fowlplay.common.network.s2c.DebugBirdCustomPayload;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.BrainDebugRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.debug.PathfindingRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BirdDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    public static final BirdDebugRenderer INSTANCE = new BirdDebugRenderer();
    private final Minecraft client;
    private final Map<UUID, DebugBirdCustomPayload.BirdData> birds = Maps.newHashMap();
    @Nullable
    private UUID targetedEntity;

    private BirdDebugRenderer() {
        this.client = Minecraft.getInstance();
    }

    public void clear() {
        this.targetedEntity = null;
    }

    public void addBird(DebugBirdCustomPayload.BirdData birdData) {
        this.birds.put(birdData.uuid(), birdData);
    }

    private boolean isTargeted(DebugBirdCustomPayload.BirdData birdData) {
        return Objects.equals(this.targetedEntity, birdData.uuid());
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        if (!FowlPlayClient.DEBUG_BIRD) {
            return;
        }
        this.removeRemovedBirds();
        this.draw(matrices, vertexConsumers, cameraX, cameraY, cameraZ);
        this.updateTargetedEntity();
    }

    private void removeRemovedBirds() {
        this.birds.entrySet().removeIf(entry -> {
            Entity entity = this.client.level.getEntity(((DebugBirdCustomPayload.BirdData)entry.getValue()).entityId());
            return entity == null || entity.isRemoved();
        });
    }

    private void updateTargetedEntity() {
        DebugRenderer.getTargetedEntity((Entity)this.client.getCameraEntity(), (int)8).ifPresent(entity -> {
            this.targetedEntity = entity.getUUID();
        });
    }

    private boolean isClose(DebugBirdCustomPayload.BirdData birdData) {
        LocalPlayer playerEntity = this.client.player;
        BlockPos playerPos = BlockPos.containing((double)playerEntity.getX(), (double)birdData.pos().y(), (double)playerEntity.getZ());
        BlockPos brainPos = BlockPos.containing((Position)birdData.pos());
        return playerPos.closerThan((Vec3i)brainPos, 30.0);
    }

    private void draw(PoseStack matrices, MultiBufferSource vertexConsumers, double x, double y, double z) {
        this.birds.values().forEach(birdData -> {
            if (this.isClose((DebugBirdCustomPayload.BirdData)birdData)) {
                BirdDebugRenderer.drawBirdData(matrices, vertexConsumers, birdData, this.isTargeted((DebugBirdCustomPayload.BirdData)birdData), x, y, z);
            }
        });
    }

    private static void drawBirdData(PoseStack matrices, MultiBufferSource vertexConsumers, DebugBirdCustomPayload.BirdData birdData, boolean targeted, double cameraX, double cameraY, double cameraZ) {
        int i = 0;
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, birdData.name(), -1, 0.03f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "trusting: " + Arrays.toString(birdData.trusting().toArray()), -3355444, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "flying: " + birdData.flying(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "perched: " + birdData.perched(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "ambient: " + birdData.ambient(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "move control: " + birdData.moveControl(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "navigation: " + birdData.navigation(), -1, 0.02f);
        int j = birdData.health() < birdData.maxHealth() ? -23296 : -1;
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), ++i, "health: " + String.format(Locale.ROOT, "%.1f", Float.valueOf(birdData.health())) + " / " + String.format(Locale.ROOT, "%.1f", Float.valueOf(birdData.maxHealth())), j, 0.02f);
        ++i;
        if (!birdData.inventory().isEmpty()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, birdData.inventory(), -98404, 0.02f);
        }
        for (String string : birdData.runningTasks()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, string, -16711681, 0.02f);
            ++i;
        }
        for (String string : birdData.possibleActivities()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, string, -16711936, 0.02f);
            ++i;
        }
        if (birdData.schedule() != null) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, birdData.schedule(), -23296, 0.02f);
            ++i;
        }
        if (targeted) {
            for (String string : Lists.reverse(birdData.memories())) {
                BirdDebugRenderer.drawString(matrices, vertexConsumers, (Position)birdData.pos(), i, string, -3355444, 0.02f);
                ++i;
            }
        }
        BirdDebugRenderer.drawPath(matrices, vertexConsumers, birdData, cameraX, cameraY, cameraZ);
    }

    private static void drawPath(PoseStack matrices, MultiBufferSource vertexConsumers, DebugBirdCustomPayload.BirdData birdData, double cameraX, double cameraY, double cameraZ) {
        if (birdData.path() != null) {
            if (birdData.flying()) {
                BirdDebugRenderer.drawPath(matrices, vertexConsumers, birdData.path(), 0.1f, false, false, cameraX, cameraY, cameraZ);
            } else {
                PathfindingRenderer.renderPath((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (Path)birdData.path(), (float)0.5f, (boolean)false, (boolean)false, (double)cameraX, (double)cameraY, (double)cameraZ);
            }
        }
    }

    public static void drawPath(PoseStack matrices, MultiBufferSource vertexConsumers, Path path, float nodeSize, boolean drawDebugNodes, boolean drawLabels, double cameraX, double cameraY, double cameraZ) {
        PathfindingRenderer.renderPathLine((PoseStack)matrices, (VertexConsumer)vertexConsumers.getBuffer(RenderType.debugLineStrip((double)6.0)), (Path)path, (double)cameraX, (double)cameraY, (double)cameraZ);
        BlockPos blockPos = path.getTarget();
        if (BirdDebugRenderer.getManhattanDistance(blockPos, cameraX, cameraY, cameraZ) <= 80.0f) {
            DebugRenderer.renderFilledBox((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB((double)((float)blockPos.getX() + 0.25f), (double)((float)blockPos.getY() + 0.25f), (double)blockPos.getZ() + 0.25, (double)((float)blockPos.getX() + 0.75f), (double)((float)blockPos.getY() + 0.75f), (double)((float)blockPos.getZ() + 0.75f)).move(-cameraX, -cameraY, -cameraZ), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            for (int i = 0; i < path.getNodeCount(); ++i) {
                Node pathNode = path.getNode(i);
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode.asBlockPos(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                float red = i == path.getNextNodeIndex() ? 1.0f : 0.0f;
                float blue = i == path.getNextNodeIndex() ? 0.0f : 1.0f;
                DebugRenderer.renderFilledBox((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB((double)((float)pathNode.x + 0.5f - nodeSize), (double)((float)pathNode.y + 0.5f - nodeSize), (double)((float)pathNode.z + 0.5f - nodeSize), (double)((float)pathNode.x + 0.5f + nodeSize), (double)((float)pathNode.y + 0.5f + nodeSize), (double)((float)pathNode.z + 0.5f + nodeSize)).move(-cameraX, -cameraY, -cameraZ), (float)red, (float)0.0f, (float)blue, (float)0.5f);
            }
        }
        Path.DebugData debugNodeInfo = path.debugData();
        if (drawDebugNodes && debugNodeInfo != null) {
            for (Node pathNode2 : debugNodeInfo.closedSet()) {
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode2.asBlockPos(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                DebugRenderer.renderFilledBox((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB((double)((float)pathNode2.x + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.y + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.z + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.x + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2.y + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2.z + 0.5f + nodeSize / 2.0f)).move(-cameraX, -cameraY, -cameraZ), (float)1.0f, (float)0.8f, (float)0.8f, (float)0.5f);
            }
            for (Node pathNode2x : debugNodeInfo.openSet()) {
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode2x.asBlockPos(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                DebugRenderer.renderFilledBox((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (AABB)new AABB((double)((float)pathNode2x.x + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.y + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.z + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.x + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2x.y + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2x.z + 0.5f + nodeSize / 2.0f)).move(-cameraX, -cameraY, -cameraZ), (float)0.8f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
        }
        if (drawLabels) {
            for (int j = 0; j < path.getNodeCount(); ++j) {
                Node pathNode3 = path.getNode(j);
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode3.asBlockPos(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                DebugRenderer.renderFloatingText((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (String)String.valueOf(pathNode3.type), (double)((double)pathNode3.x + 0.5), (double)((double)pathNode3.y + 0.75), (double)((double)pathNode3.z + 0.5), (int)-1, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
                DebugRenderer.renderFloatingText((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (String)String.format(Locale.ROOT, "%.2f", Float.valueOf(pathNode3.costMalus)), (double)((double)pathNode3.x + 0.5), (double)((double)pathNode3.y + 0.25), (double)((double)pathNode3.z + 0.5), (int)-1, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
            }
        }
    }

    private static float getManhattanDistance(BlockPos pos, double x, double y, double z) {
        return (float)(Math.abs((double)pos.getX() - x) + Math.abs((double)pos.getY() - y) + Math.abs((double)pos.getZ() - z));
    }

    private static void drawString(PoseStack matrices, MultiBufferSource vertexConsumers, String string, BrainDebugRenderer.PoiInfo pointOfInterest, int offsetY, int color) {
        BirdDebugRenderer.drawString(matrices, vertexConsumers, string, pointOfInterest.pos, offsetY, color);
    }

    private static void drawString(PoseStack matrices, MultiBufferSource vertexConsumers, String string, BlockPos pos, int offsetY, int color) {
        double f = (double)pos.getX() + 0.5;
        double g = (double)pos.getY() + 1.3 + (double)offsetY * 0.2;
        double h = (double)pos.getZ() + 0.5;
        DebugRenderer.renderFloatingText((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (String)string, (double)f, (double)g, (double)h, (int)color, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
    }

    private static void drawString(PoseStack matrices, MultiBufferSource vertexConsumers, Position pos, int offsetY, String string, int color, float size) {
        double f = pos.x() + 0.5;
        double g = pos.y() + 2.4 + (double)offsetY * 0.25;
        double h = pos.z() + 0.5;
        DebugRenderer.renderFloatingText((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (String)string, (double)f, (double)g, (double)h, (int)color, (float)size, (boolean)false, (float)0.5f, (boolean)true);
    }
}

