/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.DomesticGooseAnimations;
import aqario.fowlplay.client.render.entity.animation.GooseAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdEntityModel;
import aqario.fowlplay.common.entity.GooseEntity;
import aqario.fowlplay.common.entity.GooseVariant;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class GooseEntityModel
extends FlyingBirdEntityModel<GooseEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("goose"), "main");

    public GooseEntityModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 23).addBox(-1.5f, -7.0f, -1.75f, 3.0f, 9.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-3.5f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-1.5f, -3.0f, -1.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.75f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, 0.0f, -2.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(-0.001f)).texOffs(0, 3).addBox(-1.0f, -0.75f, -2.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -6.5f, 6.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(16, 16).addBox(-0.5f, -3.0f, -0.5f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)3.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(1, 24).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-5.5f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(1, 24).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 11.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)-5.5f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(23, 0).addBox(-1.0f, -0.1f, -1.0f, 10.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-6.5f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(23, 0).mirror().addBox(-9.0f, -0.1f, -1.0f, 10.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)-6.5f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(24, 10).mirror().addBox(-11.0f, 0.0f, 0.0f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-8.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(34, 18).addBox(-1.5f, -1.0f, 1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 18).addBox(-1.0f, -1.002f, 1.75f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.25f, (float)6.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(41, 18).addBox(-1.0f, -0.001f, 0.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.0f, (float)2.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        tail.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(41, 18).mirror().addBox(-1.0f, -0.001f, 0.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)2.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-1, 0).mirror().addBox(-1.5f, 4.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.25f, (float)1.0f, (float)2.5f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-1, 0).addBox(-1.5f, 4.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.25f, (float)1.0f, (float)2.5f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void animateModel(GooseEntity goose, float limbAngle, float limbDistance, float tickDelta) {
        AnimationDefinition flappingAnimation;
        this.root().getAllParts().forEach(ModelPart::resetPose);
        super.prepareMobModel((Entity)goose, limbAngle, limbDistance, tickDelta);
        float ageInTicks = (float)goose.tickCount + tickDelta;
        float bodyYaw = Mth.rotLerp((float)tickDelta, (float)goose.yBodyRotO, (float)goose.yBodyRot);
        float headYaw = Mth.rotLerp((float)tickDelta, (float)goose.yHeadRotO, (float)goose.yHeadRot);
        float relativeHeadYaw = Mth.wrapDegrees((float)(headYaw - bodyYaw));
        float headPitch = Mth.lerp((float)tickDelta, (float)goose.xRotO, (float)goose.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)goose)) {
            headPitch *= -1.0f;
            relativeHeadYaw *= -1.0f;
        }
        if (!goose.isFlying()) {
            this.updateHeadRotation(relativeHeadYaw, headPitch);
        }
        if (goose.isFlying()) {
            this.root.xRot = goose.getViewXRot(tickDelta) * ((float)Math.PI / 180);
            this.root.zRot = goose.getRoll(tickDelta) * ((float)Math.PI / 180);
        }
        if (goose.isFlying()) {
            this.leftWingOpen.visible = true;
            this.rightWingOpen.visible = true;
            this.leftWing.visible = false;
            this.rightWing.visible = false;
        } else {
            this.leftWingOpen.visible = false;
            this.rightWingOpen.visible = false;
            this.leftWing.visible = true;
            this.rightWing.visible = true;
        }
        boolean domestic = ((GooseVariant)goose.getVariant().value()).modelType() == GooseVariant.ModelType.DOMESTIC;
        AnimationDefinition walkingAnimation = domestic ? DomesticGooseAnimations.WALKING : GooseAnimations.WALKING;
        AnimationDefinition standingAnimation = domestic ? DomesticGooseAnimations.STANDING : GooseAnimations.STANDING;
        AnimationDefinition swimmingAnimation = domestic ? DomesticGooseAnimations.SWIMMING : GooseAnimations.SWIMMING;
        AnimationDefinition glidingAnimation = domestic ? DomesticGooseAnimations.GLIDING : GooseAnimations.GLIDING;
        AnimationDefinition animationDefinition = flappingAnimation = domestic ? DomesticGooseAnimations.FLAPPING : GooseAnimations.FLAPPING;
        if (!goose.isFlying() && !goose.isInWaterOrBubble()) {
            this.animateWalk(walkingAnimation, limbAngle, limbDistance, 3.0f, 3.0f);
        }
        this.animate(goose.standingState, standingAnimation, ageInTicks);
        this.animate(goose.floatingState, swimmingAnimation, ageInTicks);
        this.animate(goose.glidingState, glidingAnimation, ageInTicks);
        this.animate(goose.flappingState, flappingAnimation, ageInTicks);
    }

    private void updateHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-100.0f, (float)100.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.neck.yRot = headYaw * ((float)Math.PI / 180);
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
    }
}

