/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.GullAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdEntityModel;
import aqario.fowlplay.common.entity.GullEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class GullEntityModel
extends FlyingBirdEntityModel<GullEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("gull"), "main");

    public GullEntityModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.5f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-2.5f, (float)-2.5f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-1.0f));
        body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.5f, -6.5f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.05f, (float)2.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-4.25f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 14).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-4.25f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -0.1f, -1.0f, 10.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-5.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(16, 9).addBox(0.0f, 0.0f, 0.0f, 12.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-9.0f, -0.1f, -1.0f, 10.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-5.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(16, 9).mirror().addBox(-12.0f, 0.0f, 0.0f, 12.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-9.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(16, 0).addBox(-1.5f, -1.0f, 1.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-1.0f, -1.002f, 3.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.75f, (float)3.5f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(23, 0).addBox(-1.0f, -0.001f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.0f, (float)2.5f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        tail.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(23, 0).mirror().addBox(-1.0f, -0.001f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)2.5f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 4).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.25f, (float)1.0f, (float)2.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 5).mirror().addBox(0.5f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)4.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 4).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.25f, (float)1.0f, (float)2.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 5).addBox(-0.5f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void animateModel(GullEntity gull, float limbAngle, float limbDistance, float tickDelta) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        super.prepareMobModel((Entity)gull, limbAngle, limbDistance, tickDelta);
        float ageInTicks = (float)gull.tickCount + tickDelta;
        float bodyYaw = Mth.rotLerp((float)tickDelta, (float)gull.yBodyRotO, (float)gull.yBodyRot);
        float headYaw = Mth.rotLerp((float)tickDelta, (float)gull.yHeadRotO, (float)gull.yHeadRot);
        float relativeHeadYaw = Mth.wrapDegrees((float)(headYaw - bodyYaw));
        float headPitch = Mth.lerp((float)tickDelta, (float)gull.xRotO, (float)gull.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)gull)) {
            headPitch *= -1.0f;
            relativeHeadYaw *= -1.0f;
        }
        if (!gull.isFlying()) {
            this.updateHeadRotation(relativeHeadYaw, headPitch);
        }
        if (gull.isFlying()) {
            this.root.xRot = gull.getViewXRot(tickDelta) * ((float)Math.PI / 180);
            this.root.zRot = gull.getRoll(tickDelta) * ((float)Math.PI / 180);
        }
        if (gull.isFlying()) {
            this.leftWingOpen.visible = true;
            this.rightWingOpen.visible = true;
            this.leftWing.visible = false;
            this.rightWing.visible = false;
        } else {
            this.leftWingOpen.visible = false;
            this.rightWingOpen.visible = false;
            this.leftWing.visible = true;
            this.rightWing.visible = true;
        }
        if (gull.isFlying()) {
            this.animateWalk(GullAnimations.FLAPPING, limbAngle, limbDistance, 2.0f, 2.0f);
        } else if (!gull.isInWaterOrBubble()) {
            this.animateWalk(GullAnimations.WALKING, limbAngle, limbDistance, 4.0f, 4.0f);
        }
        this.animate(gull.standingState, GullAnimations.STANDING, ageInTicks);
        this.animate(gull.floatingState, GullAnimations.FLOATING, ageInTicks);
        this.animate(gull.glidingState, GullAnimations.GLIDING, ageInTicks);
    }

    private void updateHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-135.0f, (float)135.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.neck.yRot = headYaw * ((float)Math.PI / 180);
        this.neck.xRot = headPitch * ((float)Math.PI / 180);
    }
}

