/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.Flocking;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.PigeonVariant;
import aqario.fowlplay.common.entity.TameableBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.DeliverBundle;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.LeaderlessFlocking;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetOwnerTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetPerchWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.TeleportToTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.PigeonSpecificSensor;
import aqario.fowlplay.common.entity.ai.pathing.GroundNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.FowlPlayRegistryKeys;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.FowlPlayTrackedDataHandlerRegistry;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class PigeonEntity
extends TameableBirdEntity
implements BirdBrain<PigeonEntity>,
VariantHolder<Holder<PigeonVariant>>,
Flocking {
    private static final EntityDataAccessor<Optional<UUID>> RECIPIENT = SynchedEntityData.defineId(PigeonEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Holder<PigeonVariant>> VARIANT = SynchedEntityData.defineId(PigeonEntity.class, FowlPlayTrackedDataHandlerRegistry.PIGEON_VARIANT);
    public final AnimationState standingState = new AnimationState();
    public final AnimationState glidingState = new AnimationState();
    public final AnimationState flappingState = new AnimationState();
    public final AnimationState floatingState = new AnimationState();
    public final AnimationState sittingState = new AnimationState();

    public PigeonEntity(EntityType<? extends PigeonEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        float f = world.getRandom().nextFloat();
        if (f < 0.5f) {
            FowlPlayRegistries.PIGEON_VARIANT.getHolder(PigeonVariant.BANDED).ifPresent(this::setVariant);
        } else if (f < 0.75f) {
            FowlPlayRegistries.PIGEON_VARIANT.getHolder(PigeonVariant.CHECKERED).ifPresent(this::setVariant);
        } else if (f < 0.95f) {
            FowlPlayRegistries.PIGEON_VARIANT.getHolder(PigeonVariant.GRAY).ifPresent(this::setVariant);
        } else if (f < 0.99f) {
            FowlPlayRegistries.PIGEON_VARIANT.getHolder(PigeonVariant.RUSTY).ifPresent(this::setVariant);
        } else {
            FowlPlayRegistries.PIGEON_VARIANT.getHolder(PigeonVariant.WHITE).ifPresent(this::setVariant);
        }
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setDropChance(EquipmentSlot.MAINHAND, 1.0f);
        this.setDropChance(EquipmentSlot.OFFHAND, 1.0f);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RECIPIENT, Optional.empty());
        builder.define(VARIANT, (Object)FowlPlayRegistries.PIGEON_VARIANT.getHolderOrThrow(PigeonVariant.BANDED));
    }

    public Holder<PigeonVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public void setVariant(Holder<PigeonVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("variant", this.getVariant().unwrapKey().orElse(PigeonVariant.BANDED).location().toString());
        if (this.getRecipientUuid() != null) {
            nbt.putUUID("recipient", this.getRecipientUuid());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        Optional.ofNullable(ResourceLocation.tryParse((String)nbt.getString("variant"))).map(variant -> ResourceKey.create(FowlPlayRegistryKeys.PIGEON_VARIANT, (ResourceLocation)variant)).flatMap(arg_0 -> FowlPlayRegistries.PIGEON_VARIANT.getHolder(arg_0)).ifPresent(this::setVariant);
        if (nbt.hasUUID("recipient")) {
            this.setRecipientUuid(nbt.getUUID("recipient"));
        } else {
            this.setRecipientUuid(null);
        }
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)10, (Object)12);
    }

    @Override
    public float getWaterline() {
        return 0.45f;
    }

    @Override
    public int getFlapFrequency() {
        return 7;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean isBaby() {
        return false;
    }

    public static AttributeSupplier.Builder createPigeonAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.FLYING_SPEED, (double)0.26f);
    }

    @Override
    protected PathNavigation getLandNavigation() {
        GroundNavigation navigation = new GroundNavigation((Mob)this, this.level());
        navigation.setCanOpenDoors(false);
        navigation.setCanPassDoors(true);
        navigation.setCanFloat(false);
        return navigation;
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack playerStack = player.getItemInHand(hand);
        ItemStack bundleStack = this.getItemInHand(InteractionHand.OFF_HAND);
        if (bundleStack.isEmpty() && playerStack.getItem() instanceof BundleItem && playerStack.getComponents().has(DataComponents.CUSTOM_NAME) && this.isTamed()) {
            if (!this.level().isClientSide) {
                this.setItemInHand(InteractionHand.OFF_HAND, playerStack);
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (playerStack.isEmpty() && bundleStack.getItem() instanceof BundleItem) {
            if (!this.level().isClientSide) {
                player.setItemInHand(hand, bundleStack);
                this.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isFood(playerStack) && !this.isTamed()) {
            if (!this.level().isClientSide) {
                this.usePlayerItem(player, hand, playerStack);
                if (this.random.nextInt(4) == 0) {
                    this.setOwner(player);
                    this.navigation.stop();
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.onGround() && this.isTamed() && this.isOwner((LivingEntity)player)) {
            if (!this.level().isClientSide) {
                this.setSitting(!this.isSitting());
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return !this.isTamed() && this.getFood().test(stack);
    }

    @Override
    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot equipmentSlot = this.getEquipmentSlotForItem(stack);
        if (!this.getItemBySlot(equipmentSlot).isEmpty()) {
            return false;
        }
        return equipmentSlot == EquipmentSlot.MAINHAND || equipmentSlot == EquipmentSlot.OFFHAND && super.canTakeItem(stack);
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.of(FowlPlayItemTags.PIGEON_FOOD);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.getType().is(FowlPlayEntityTypeTags.PIGEON_AVOIDS);
    }

    protected void dropEquipment() {
        super.dropEquipment();
        this.spawnAtLocation(this.getItemBySlot(EquipmentSlot.MAINHAND));
        this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.spawnAtLocation(this.getItemBySlot(EquipmentSlot.OFFHAND));
        this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
    }

    @Override
    public void updateAnimations() {
        this.standingState.animateWhen(!this.isFlying() && !this.isInWaterOrBubble() && !this.isInSittingPose(), this.tickCount);
        this.flappingState.animateWhen(this.isFlying(), this.tickCount);
        this.floatingState.animateWhen(!this.isFlying() && this.isInWaterOrBubble(), this.tickCount);
        this.sittingState.animateWhen(this.isInSittingPose(), this.tickCount);
    }

    protected boolean isFlapping() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.65f;
    }

    @Override
    public float getFlapPitch() {
        return 0.9f;
    }

    @Nullable
    public UUID getRecipientUuid() {
        return ((Optional)this.entityData.get(RECIPIENT)).orElse(null);
    }

    public void setRecipientUuid(@Nullable UUID uuid) {
        this.entityData.set(RECIPIENT, Optional.ofNullable(uuid));
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    @Override
    protected boolean canSing() {
        if (this.level().isDay()) {
            return false;
        }
        List list = this.level().getEntitiesOfClass(Player.class, this.getAttackBoundingBox().inflate(16.0, 16.0, 16.0), EntitySelector.NO_SPECTATORS);
        if (list.isEmpty()) {
            return false;
        }
        return super.canSing();
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_PIGEON_CALL.get();
    }

    @Override
    @Nullable
    protected SoundEvent getSongSound() {
        return FowlPlaySoundEvents.ENTITY_PIGEON_SONG.get();
    }

    @Override
    public int getCallDelay() {
        return 120;
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().pigeonCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().pigeonSongVolume;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_PIGEON_HURT.get();
    }

    @Override
    public boolean isLeader() {
        return false;
    }

    @Override
    public void setLeader() {
    }

    protected Brain.Provider<PigeonEntity> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends PigeonEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor(), new PigeonSpecificSensor()});
    }

    public BrainActivityGroup<? extends PigeonEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{new FloatToSurfaceOfFluid().riseChance(0.5f), FlightBehaviours.stopFalling(), new TeleportToTarget(), new SetOwnerTarget(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget().startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, FowlPlayMemoryModuleType.TELEPORT_TARGET.get())).stopIf(entity -> BrainUtils.hasMemory((LivingEntity)entity, FowlPlayMemoryModuleType.TELEPORT_TARGET.get()))});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getDeliverTasks() {
        return BirdBrain.deliverActivity(new Behavior[]{FlightBehaviours.stopFlying().startCondition(PigeonEntity::shouldStopFlyingToRecipient), FlightBehaviours.startFlying().startCondition(PigeonEntity::shouldFlyToRecipient), DeliverBundle.run()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getForageTasks() {
        return BirdBrain.forageActivity(new Behavior[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeBehaviours.tryForage(), CompositeBehaviours.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new Behavior[]{new LeaderlessFlocking(5, 0.03f, 0.6f, 0.05f, 3.0f), CompositeBehaviours.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{CustomBehaviours.setNearestFoodWalkTarget().startCondition(pigeon -> !pigeon.isSitting())});
    }

    @Override
    public BrainActivityGroup<? extends PigeonEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{new SetPerchWalkTarget().startCondition(Predicate.not(Birds::isPerched)), CustomBehaviours.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    private static boolean shouldFlyToRecipient(PigeonEntity pigeon) {
        UUID recipientUuid = pigeon.getBrain().getMemory(FowlPlayMemoryModuleType.RECIPIENT.get()).orElse(null);
        if (recipientUuid == null) {
            return false;
        }
        Player recipient = pigeon.level().getPlayerByUUID(recipientUuid);
        if (recipient == null) {
            return false;
        }
        return pigeon.distanceToSqr((Entity)recipient) > 64.0;
    }

    private static boolean shouldStopFlyingToRecipient(PigeonEntity pigeon) {
        UUID recipientUuid = pigeon.getBrain().getMemory(FowlPlayMemoryModuleType.RECIPIENT.get()).orElse(null);
        if (recipientUuid == null) {
            return true;
        }
        Player recipient = pigeon.level().getPlayerByUUID(recipientUuid);
        if (recipient == null) {
            return true;
        }
        return pigeon.distanceToSqr((Entity)recipient) < 16.0;
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
        super.customServerAiStep();
        if (this.getServer() == null) {
            return;
        }
        if (!this.isTamed()) {
            return;
        }
        ItemStack stack = this.getItemBySlot(EquipmentSlot.OFFHAND);
        ServerPlayer recipient = this.getServer().getPlayerList().getPlayerByName(stack.getHoverName().getString());
        if (!(stack.getItem() instanceof BundleItem) || !stack.getComponents().has(DataComponents.CUSTOM_NAME) || recipient == null || recipient.getUUID() == null) {
            this.setRecipientUuid(null);
            return;
        }
        this.setRecipientUuid(recipient.getUUID());
    }
}

