/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.core.FowlPlayItems;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class ScarecrowEntity
extends LivingEntity
implements ContainerListener,
MenuProvider {
    private static final Predicate<Entity> RIDEABLE_MINECART_PREDICATE = entity -> entity instanceof AbstractMinecart && ((AbstractMinecart)entity).getMinecartType() == AbstractMinecart.Type.RIDEABLE;
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_ROTATION = new Rotations(0.0f, 0.0f, -90.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_ROTATION = new Rotations(0.0f, 0.0f, 90.0f);
    public static final EntityDataAccessor<Rotations> HEAD_ROTATION = SynchedEntityData.defineId(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> BODY_ROTATION = SynchedEntityData.defineId(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> LEFT_ARM_ROTATION = SynchedEntityData.defineId(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> RIGHT_ARM_ROTATION = SynchedEntityData.defineId(ScarecrowEntity.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFT_ARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHT_ARM_ROTATION;
    private static final String POSE_KEY = "pose";
    private static final String HEAD_ROTATION_KEY = "head";
    private static final String BODY_ROTATION_KEY = "body";
    private static final String LEFT_ARM_ROTATION_KEY = "left_arm";
    private static final String RIGHT_ARM_ROTATION_KEY = "right_arm";
    private static final String ITEMS_KEY = "items";
    private static final int INVENTORY_SIZE = 4;
    private static final int HEAD_SLOT = 0;
    private static final int CHEST_SLOT = 1;
    private static final int MAINHAND_SLOT = 2;
    private static final int OFFHAND_SLOT = 3;
    protected SimpleContainer inventory = new SimpleContainer(4);

    public ScarecrowEntity(EntityType<? extends ScarecrowEntity> entityType, Level world) {
        super(entityType, world);
        this.inventory.addListener((ContainerListener)this);
    }

    public static AttributeSupplier.Builder createScarecrowAttributes() {
        return ScarecrowEntity.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected float tickHeadTurn(float bodyRotation, float headRotation) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    public void setYBodyRot(float bodyYaw) {
        this.yBodyRotO = this.yRotO = bodyYaw;
        this.yHeadRotO = this.yHeadRot = bodyYaw;
    }

    public void setYHeadRot(float headYaw) {
        this.yBodyRotO = this.yRotO = headYaw;
        this.yHeadRotO = this.yHeadRot = headYaw;
    }

    public void containerChanged(Container sender) {
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemStack = this.inventory.getItem(i);
                if (itemStack.isEmpty()) continue;
                this.spawnAtLocation(itemStack);
            }
        }
    }

    public Iterable<ItemStack> getHandSlots() {
        return ImmutableList.of((Object)this.inventory.getItem(2), (Object)this.inventory.getItem(3));
    }

    public Iterable<ItemStack> getArmorSlots() {
        return ImmutableList.of((Object)this.inventory.getItem(0), (Object)this.inventory.getItem(1));
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> this.inventory.getItem(0);
            case EquipmentSlot.CHEST -> this.inventory.getItem(1);
            case EquipmentSlot.MAINHAND -> this.inventory.getItem(2);
            case EquipmentSlot.OFFHAND -> this.inventory.getItem(3);
            default -> ItemStack.EMPTY;
        };
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        this.verifyEquippedItem(stack);
        switch (slot) {
            case HEAD: {
                this.inventory.setItem(0, stack);
                break;
            }
            case CHEST: {
                this.inventory.setItem(1, stack);
                break;
            }
            case MAINHAND: {
                this.inventory.setItem(2, stack);
                break;
            }
            case OFFHAND: {
                this.inventory.setItem(3, stack);
            }
        }
    }

    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot equipmentSlot = this.getEquipmentSlotForItem(stack);
        return this.getItemBySlot(equipmentSlot).isEmpty();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEAD_ROTATION, (Object)DEFAULT_HEAD_ROTATION);
        builder.define(BODY_ROTATION, (Object)DEFAULT_BODY_ROTATION);
        builder.define(LEFT_ARM_ROTATION, (Object)DEFAULT_LEFT_ARM_ROTATION);
        builder.define(RIGHT_ARM_ROTATION, (Object)DEFAULT_RIGHT_ARM_ROTATION);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put(ITEMS_KEY, (Tag)this.inventory.createTag((HolderLookup.Provider)this.registryAccess()));
        nbt.put(POSE_KEY, (Tag)this.poseToNbt());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains(ITEMS_KEY, 9)) {
            this.inventory.fromTag(nbt.getList(ITEMS_KEY, 10), (HolderLookup.Provider)this.registryAccess());
        }
        CompoundTag poseNbt = nbt.getCompound(POSE_KEY);
        this.readPoseNbt(poseNbt);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!player.level().isClientSide() && player.getItemInHand(hand).isEmpty() && !player.isSecondaryUseActive()) {
            return InteractionResult.CONSUME;
        }
        return super.interact(player, hand);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player playerEntity) {
        return null;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    protected void pushEntities() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox(), RIDEABLE_MINECART_PREDICATE);
        for (Entity entity : list) {
            if (!(this.distanceToSqr(entity) <= 0.2)) continue;
            entity.push((Entity)this);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide() || this.isRemoved()) {
            return false;
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.kill();
            return false;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.getDirectEntity() instanceof FireworkRocketEntity) {
            return false;
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            this.updateHealth(source, amount);
            return false;
        }
        if (source.is(DamageTypes.LAVA)) {
            this.igniteForSeconds(10.0f);
            if (this.isOnFire()) {
                this.updateHealth(source, 1.0f);
            }
            return false;
        }
        if (source.is(DamageTypeTags.IS_FIRE)) {
            this.igniteForSeconds(5.0f);
            if (this.isOnFire()) {
                this.updateHealth(source, 0.05f);
            }
            return false;
        }
        if (source.getDirectEntity() instanceof AbstractArrow) {
            return true;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.isShiftKeyDown()) {
                this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
                return true;
            }
            if (!player.getAbilities().mayBuild) {
                return false;
            }
            if (source.isCreativePlayer()) {
                this.onBreak(source);
                this.spawnBreakParticles();
                this.kill();
                return false;
            }
            this.breakAndDropThis(source);
            this.spawnBreakParticles();
            this.kill();
        }
        return true;
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        return damageSource.is(DamageTypeTags.IS_FALL);
    }

    public void thunderHit(ServerLevel world, LightningBolt lightning) {
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    protected void spawnBreakParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.sendParticles(this.getParticle(), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void updateHealth(DamageSource damageSource, float amount) {
        float f = this.getHealth();
        if ((f -= amount) <= 0.5f) {
            this.onBreak(damageSource);
            this.kill();
        } else {
            this.setHealth(f);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
        }
    }

    private void breakAndDropThis(DamageSource damageSource) {
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)this.getItem());
        this.onBreak(damageSource);
    }

    private void onBreak(DamageSource damageSource) {
        this.playBreakSound();
        this.dropAllDeathLoot((ServerLevel)this.level(), damageSource);
    }

    private void playBreakSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), this.getDeathSound(), this.getSoundSource(), 1.0f, 1.0f);
    }

    private void readPoseNbt(CompoundTag nbt) {
        ListTag head = nbt.getList(HEAD_ROTATION_KEY, 5);
        ListTag body = nbt.getList(BODY_ROTATION_KEY, 5);
        ListTag leftArm = nbt.getList(LEFT_ARM_ROTATION_KEY, 5);
        ListTag rightArm = nbt.getList(RIGHT_ARM_ROTATION_KEY, 5);
        this.setHeadRotation(head.isEmpty() ? DEFAULT_HEAD_ROTATION : new Rotations(head));
        this.setBodyRotation(body.isEmpty() ? DEFAULT_BODY_ROTATION : new Rotations(body));
        this.setLeftArmRotation(leftArm.isEmpty() ? DEFAULT_LEFT_ARM_ROTATION : new Rotations(leftArm));
        this.setRightArmRotation(rightArm.isEmpty() ? DEFAULT_RIGHT_ARM_ROTATION : new Rotations(rightArm));
    }

    private CompoundTag poseToNbt() {
        CompoundTag nbt = new CompoundTag();
        if (!DEFAULT_HEAD_ROTATION.equals((Object)this.headRotation)) {
            nbt.put(HEAD_ROTATION_KEY, (Tag)this.headRotation.save());
        }
        if (!DEFAULT_BODY_ROTATION.equals((Object)this.bodyRotation)) {
            nbt.put(BODY_ROTATION_KEY, (Tag)this.bodyRotation.save());
        }
        if (!DEFAULT_LEFT_ARM_ROTATION.equals((Object)this.leftArmRotation)) {
            nbt.put(LEFT_ARM_ROTATION_KEY, (Tag)this.leftArmRotation.save());
        }
        if (!DEFAULT_RIGHT_ARM_ROTATION.equals((Object)this.rightArmRotation)) {
            nbt.put(RIGHT_ARM_ROTATION_KEY, (Tag)this.rightArmRotation.save());
        }
        return nbt;
    }

    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    public void setHeadRotation(Rotations angle) {
        this.headRotation = angle;
        this.entityData.set(HEAD_ROTATION, (Object)angle);
    }

    public void setBodyRotation(Rotations angle) {
        this.bodyRotation = angle;
        this.entityData.set(BODY_ROTATION, (Object)angle);
    }

    public void setLeftArmRotation(Rotations angle) {
        this.leftArmRotation = angle;
        this.entityData.set(LEFT_ARM_ROTATION, (Object)angle);
    }

    public void setRightArmRotation(Rotations angle) {
        this.rightArmRotation = angle;
        this.entityData.set(RIGHT_ARM_ROTATION, (Object)angle);
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public ItemStack getItem() {
        return FowlPlayItems.SCARECROW.get().getDefaultInstance();
    }

    public ParticleOptions getParticle() {
        return new BlockParticleOption(ParticleTypes.BLOCK, Blocks.HAY_BLOCK.defaultBlockState());
    }

    public SoundEvent getPlaceSound() {
        return SoundEvents.WOOD_PLACE;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.WOOD_FALL, SoundEvents.WOOD_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WOOD_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.WOOD_BREAK;
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.getItem();
    }
}

