/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.TargetingUtil;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;

public final class Birds {
    public static final float FAST_SPEED = 1.4f;
    public static final float FLY_SPEED = 2.0f;
    public static final float SWIM_SPEED = 4.0f;
    public static final int ITEM_PICK_UP_RANGE = 32;
    public static final CylindricalRadius FLY_AVOID_RANGE = new CylindricalRadius(8, 6);
    public static final int AVOID_TICKS = 160;
    public static final int CANNOT_PICKUP_FOOD_TICKS = 1200;
    public static final UniformInt STAY_NEAR_ENTITY_RANGE = UniformInt.of((int)16, (int)32);

    public static boolean isDaytime(BirdEntity entity) {
        Level world = entity.level();
        return !world.dimensionType().hasFixedTime() && (world.getDayTime() < 12500L || world.getDayTime() > 23000L);
    }

    public static boolean shouldLandAtDestination(FlyingBirdEntity bird, BlockPos destination) {
        Level world = bird.level();
        return !world.getBlockState(destination).isAir() || !world.getBlockState(destination.below()).isAir() || !world.getFluidState(destination).isEmpty() || !world.getFluidState(destination.below()).isEmpty();
    }

    public static void tryFlyingAlongPath(FlyingBirdEntity bird, Path path) {
        if (bird.canStartFlying() && (Birds.shouldFlyToDestination(bird, path, path.getTarget().getCenter()) && (!bird.getType().is(FowlPlayEntityTypeTags.WATERBIRDS) || !bird.isInWaterOrBubble()) || Birds.shouldFlyFromAvoidTarget(bird))) {
            bird.startFlying();
        }
    }

    public static boolean shouldFlyToDestination(FlyingBirdEntity bird, Path path, Vec3 target) {
        if (!path.canReach()) {
            return true;
        }
        Vec3 pos = bird.position();
        double dx = target.x - pos.x;
        double dy = target.y - pos.y;
        double dz = target.z - pos.z;
        double dxz2 = dx * dx + dz * dz;
        double dy2 = dy * dy;
        double xzRadius = bird.getWalkRange().horizontal();
        double yRadius = bird.getWalkRange().vertical();
        return dxz2 > xzRadius * xzRadius || dy2 > yRadius * yRadius;
    }

    public static boolean shouldFlyFromAvoidTarget(FlyingBirdEntity bird) {
        Brain brain = bird.getBrain();
        if (!BrainUtils.hasMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.AVOID_TARGET) || !BrainUtils.hasMemory((Brain)brain, FowlPlayMemoryModuleType.IS_AVOIDING.get())) {
            return false;
        }
        LivingEntity target = (LivingEntity)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.AVOID_TARGET);
        if (target.isSprinting() && !target.isSpectator() || target.isPassenger()) {
            return true;
        }
        Vec3 pos = bird.position();
        Vec3 targetPos = target.position();
        double dx = targetPos.x - pos.x;
        double dy = targetPos.y - pos.y;
        double dz = targetPos.z - pos.z;
        double dxz2 = dx * dx + dz * dz;
        double dy2 = dy * dy;
        double xzRadius = FLY_AVOID_RANGE.horizontal();
        double yRadius = FLY_AVOID_RANGE.vertical();
        return dxz2 <= xzRadius * xzRadius && dy2 <= yRadius * yRadius;
    }

    public static boolean isNotFlightless(Entity entity) {
        return entity.getType().is(FowlPlayEntityTypeTags.BIRDS) && !entity.getType().is(FowlPlayEntityTypeTags.FLIGHTLESS);
    }

    public static <T extends BirdEntity> void alertOthers(T bird, LivingEntity attacker) {
        Birds.getNearbyVisibleAdults(bird).forEach(other -> {
            Brain brain = other.getBrain();
            if (attacker instanceof Player) {
                BrainUtils.setForgettableMemory((Brain)brain, FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD.get(), (Object)true, (int)1200);
            }
            BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            BrainUtils.setForgettableMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.AVOID_TARGET, (Object)attacker, (int)160);
        });
    }

    public static <T extends BirdEntity> List<? extends AgeableMob> getNearbyVisibleAdults(T bird) {
        return Optional.ofNullable((List)BrainUtils.getMemory(bird, FowlPlayMemoryModuleType.NEAREST_VISIBLE_ADULTS.get())).orElse((List)ImmutableList.of());
    }

    public static boolean isPlayerHoldingFood(BirdEntity bird, LivingEntity target) {
        return target.getType() == EntityType.PLAYER && target.isHolding((Predicate)bird.getFood());
    }

    public static boolean canPickupFood(BirdEntity bird) {
        Brain brain = bird.getBrain();
        if (BrainUtils.hasMemory((Brain)brain, FowlPlayMemoryModuleType.CANNOT_PICKUP_FOOD.get())) {
            return false;
        }
        if (!BrainUtils.hasMemory((Brain)brain, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()))) {
            return false;
        }
        List foodItems = (List)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()));
        if (foodItems.isEmpty() || bird.getFood().test(bird.getMainHandItem())) {
            return false;
        }
        NearestVisibleLivingEntities visibleMobs = (NearestVisibleLivingEntities)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        if (visibleMobs == null) {
            return true;
        }
        List<LivingEntity> avoidTargets = visibleMobs.find(entity -> true).filter(entity -> Birds.shouldAvoid(bird, entity)).filter(entity -> entity.closerThan((Entity)foodItems.getFirst(), (double)bird.getFleeRange((LivingEntity)entity))).toList();
        return avoidTargets.isEmpty();
    }

    public static boolean shouldAvoid(BirdEntity bird, LivingEntity target) {
        LivingEntity attackTarget;
        Brain brain = bird.getBrain();
        if (!(bird.shouldAvoid(target) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(target) || Birds.wasHurtBy(bird, target))) {
            return false;
        }
        if (target instanceof Player) {
            TrustingBirdEntity trusting;
            Player player = (Player)target;
            if (bird instanceof TrustingBirdEntity && (trusting = (TrustingBirdEntity)bird).trusts(player)) {
                return false;
            }
        }
        if ((attackTarget = (LivingEntity)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)) != null && attackTarget.equals((Object)target)) {
            return false;
        }
        return !bird.shouldAttack(target);
    }

    public static boolean wasHurtBy(BirdEntity bird, LivingEntity entity) {
        LivingEntity hurtBy = (LivingEntity)BrainUtils.getMemory((LivingEntity)bird, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY);
        return hurtBy != null && hurtBy.equals((Object)entity);
    }

    public static boolean isPerched(BirdEntity entity) {
        FlyingBirdEntity bird;
        return (!(entity instanceof FlyingBirdEntity) || !(bird = (FlyingBirdEntity)entity).isFlying()) && TargetingUtil.isPerch((PathfinderMob)entity, entity.getBlockPosBelowThatAffectsMyMovement());
    }
}

