/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.debug;

import aqario.fowlplay.client.FowlPlayClient;
import aqario.fowlplay.common.network.s2c.DebugBirdCustomPayload;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_4207;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_863;
import net.minecraft.class_868;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class BirdDebugRenderer
implements class_863.class_864 {
    public static final BirdDebugRenderer INSTANCE = new BirdDebugRenderer();
    private final class_310 client;
    private final Map<UUID, DebugBirdCustomPayload.BirdData> birds = Maps.newHashMap();
    @Nullable
    private UUID targetedEntity;

    private BirdDebugRenderer() {
        this.client = class_310.method_1551();
    }

    public void method_20414() {
        this.targetedEntity = null;
    }

    public void addBird(DebugBirdCustomPayload.BirdData birdData) {
        this.birds.put(birdData.uuid(), birdData);
    }

    private boolean isTargeted(DebugBirdCustomPayload.BirdData birdData) {
        return Objects.equals(this.targetedEntity, birdData.uuid());
    }

    public void method_23109(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        if (!FowlPlayClient.DEBUG_BIRD) {
            return;
        }
        this.removeRemovedBirds();
        this.draw(matrices, vertexConsumers, cameraX, cameraY, cameraZ);
        this.updateTargetedEntity();
    }

    private void removeRemovedBirds() {
        this.birds.entrySet().removeIf(entry -> {
            class_1297 entity = this.client.field_1687.method_8469(((DebugBirdCustomPayload.BirdData)entry.getValue()).entityId());
            return entity == null || entity.method_31481();
        });
    }

    private void updateTargetedEntity() {
        class_863.method_23101((class_1297)this.client.method_1560(), (int)8).ifPresent(entity -> {
            this.targetedEntity = entity.method_5667();
        });
    }

    private boolean isClose(DebugBirdCustomPayload.BirdData birdData) {
        class_746 playerEntity = this.client.field_1724;
        class_2338 playerPos = class_2338.method_49637((double)playerEntity.method_23317(), (double)birdData.pos().method_10214(), (double)playerEntity.method_23321());
        class_2338 brainPos = class_2338.method_49638((class_2374)birdData.pos());
        return playerPos.method_19771((class_2382)brainPos, 30.0);
    }

    private void draw(class_4587 matrices, class_4597 vertexConsumers, double x, double y, double z) {
        this.birds.values().forEach(birdData -> {
            if (this.isClose((DebugBirdCustomPayload.BirdData)birdData)) {
                BirdDebugRenderer.drawBirdData(matrices, vertexConsumers, birdData, this.isTargeted((DebugBirdCustomPayload.BirdData)birdData), x, y, z);
            }
        });
    }

    private static void drawBirdData(class_4587 matrices, class_4597 vertexConsumers, DebugBirdCustomPayload.BirdData birdData, boolean targeted, double cameraX, double cameraY, double cameraZ) {
        int i = 0;
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), i, birdData.name(), -1, 0.03f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), ++i, "trusting: " + Arrays.toString(birdData.trusting().toArray()), -3355444, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), ++i, "flying: " + birdData.flying(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), ++i, "perched: " + birdData.perched(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), ++i, "ambient: " + birdData.ambient(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), ++i, "move control: " + birdData.moveControl(), -1, 0.02f);
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), ++i, "navigation: " + birdData.navigation(), -1, 0.02f);
        int j = birdData.health() < birdData.maxHealth() ? -23296 : -1;
        BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), ++i, "health: " + String.format(Locale.ROOT, "%.1f", Float.valueOf(birdData.health())) + " / " + String.format(Locale.ROOT, "%.1f", Float.valueOf(birdData.maxHealth())), j, 0.02f);
        ++i;
        if (!birdData.inventory().isEmpty()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), i, birdData.inventory(), -98404, 0.02f);
        }
        for (String string : birdData.runningTasks()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), i, string, -16711681, 0.02f);
            ++i;
        }
        for (String string : birdData.possibleActivities()) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), i, string, -16711936, 0.02f);
            ++i;
        }
        if (birdData.schedule() != null) {
            BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), i, birdData.schedule(), -23296, 0.02f);
            ++i;
        }
        if (targeted) {
            for (String string : Lists.reverse(birdData.memories())) {
                BirdDebugRenderer.drawString(matrices, vertexConsumers, (class_2374)birdData.pos(), i, string, -3355444, 0.02f);
                ++i;
            }
        }
        BirdDebugRenderer.drawPath(matrices, vertexConsumers, birdData, cameraX, cameraY, cameraZ);
    }

    private static void drawPath(class_4587 matrices, class_4597 vertexConsumers, DebugBirdCustomPayload.BirdData birdData, double cameraX, double cameraY, double cameraZ) {
        if (birdData.path() != null) {
            if (birdData.flying()) {
                BirdDebugRenderer.drawPath(matrices, vertexConsumers, birdData.path(), 0.1f, false, false, cameraX, cameraY, cameraZ);
            } else {
                class_868.method_23118((class_4587)matrices, (class_4597)vertexConsumers, (class_11)birdData.path(), (float)0.5f, (boolean)false, (boolean)false, (double)cameraX, (double)cameraY, (double)cameraZ);
            }
        }
    }

    public static void drawPath(class_4587 matrices, class_4597 vertexConsumers, class_11 path, float nodeSize, boolean drawDebugNodes, boolean drawLabels, double cameraX, double cameraY, double cameraZ) {
        class_868.method_23117((class_4587)matrices, (class_4588)vertexConsumers.getBuffer(class_1921.method_49043((double)6.0)), (class_11)path, (double)cameraX, (double)cameraY, (double)cameraZ);
        class_2338 blockPos = path.method_48();
        if (BirdDebugRenderer.getManhattanDistance(blockPos, cameraX, cameraY, cameraZ) <= 80.0f) {
            class_863.method_23102((class_4587)matrices, (class_4597)vertexConsumers, (class_238)new class_238((double)((float)blockPos.method_10263() + 0.25f), (double)((float)blockPos.method_10264() + 0.25f), (double)blockPos.method_10260() + 0.25, (double)((float)blockPos.method_10263() + 0.75f), (double)((float)blockPos.method_10264() + 0.75f), (double)((float)blockPos.method_10260() + 0.75f)).method_989(-cameraX, -cameraY, -cameraZ), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            for (int i = 0; i < path.method_38(); ++i) {
                class_9 pathNode = path.method_40(i);
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode.method_22879(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                float red = i == path.method_39() ? 1.0f : 0.0f;
                float blue = i == path.method_39() ? 0.0f : 1.0f;
                class_863.method_23102((class_4587)matrices, (class_4597)vertexConsumers, (class_238)new class_238((double)((float)pathNode.field_40 + 0.5f - nodeSize), (double)((float)pathNode.field_39 + 0.5f - nodeSize), (double)((float)pathNode.field_38 + 0.5f - nodeSize), (double)((float)pathNode.field_40 + 0.5f + nodeSize), (double)((float)pathNode.field_39 + 0.5f + nodeSize), (double)((float)pathNode.field_38 + 0.5f + nodeSize)).method_989(-cameraX, -cameraY, -cameraZ), (float)red, (float)0.0f, (float)blue, (float)0.5f);
            }
        }
        class_11.class_8644 debugNodeInfo = path.method_52604();
        if (drawDebugNodes && debugNodeInfo != null) {
            for (class_9 pathNode2 : debugNodeInfo.comp_1588()) {
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode2.method_22879(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                class_863.method_23102((class_4587)matrices, (class_4597)vertexConsumers, (class_238)new class_238((double)((float)pathNode2.field_40 + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.field_39 + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.field_38 + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2.field_40 + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2.field_39 + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2.field_38 + 0.5f + nodeSize / 2.0f)).method_989(-cameraX, -cameraY, -cameraZ), (float)1.0f, (float)0.8f, (float)0.8f, (float)0.5f);
            }
            for (class_9 pathNode2x : debugNodeInfo.comp_1587()) {
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode2x.method_22879(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                class_863.method_23102((class_4587)matrices, (class_4597)vertexConsumers, (class_238)new class_238((double)((float)pathNode2x.field_40 + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.field_39 + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.field_38 + 0.5f - nodeSize / 2.0f), (double)((float)pathNode2x.field_40 + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2x.field_39 + 0.5f + nodeSize / 2.0f), (double)((float)pathNode2x.field_38 + 0.5f + nodeSize / 2.0f)).method_989(-cameraX, -cameraY, -cameraZ), (float)0.8f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
        }
        if (drawLabels) {
            for (int j = 0; j < path.method_38(); ++j) {
                class_9 pathNode3 = path.method_40(j);
                if (!(BirdDebugRenderer.getManhattanDistance(pathNode3.method_22879(), cameraX, cameraY, cameraZ) <= 80.0f)) continue;
                class_863.method_23107((class_4587)matrices, (class_4597)vertexConsumers, (String)String.valueOf(pathNode3.field_41), (double)((double)pathNode3.field_40 + 0.5), (double)((double)pathNode3.field_39 + 0.75), (double)((double)pathNode3.field_38 + 0.5), (int)-1, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
                class_863.method_23107((class_4587)matrices, (class_4597)vertexConsumers, (String)String.format(Locale.ROOT, "%.2f", Float.valueOf(pathNode3.field_43)), (double)((double)pathNode3.field_40 + 0.5), (double)((double)pathNode3.field_39 + 0.25), (double)((double)pathNode3.field_38 + 0.5), (int)-1, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
            }
        }
    }

    private static float getManhattanDistance(class_2338 pos, double x, double y, double z) {
        return (float)(Math.abs((double)pos.method_10263() - x) + Math.abs((double)pos.method_10264() - y) + Math.abs((double)pos.method_10260() - z));
    }

    private static void drawString(class_4587 matrices, class_4597 vertexConsumers, String string, class_4207.class_4233 pointOfInterest, int offsetY, int color) {
        BirdDebugRenderer.drawString(matrices, vertexConsumers, string, pointOfInterest.field_18931, offsetY, color);
    }

    private static void drawString(class_4587 matrices, class_4597 vertexConsumers, String string, class_2338 pos, int offsetY, int color) {
        double f = (double)pos.method_10263() + 0.5;
        double g = (double)pos.method_10264() + 1.3 + (double)offsetY * 0.2;
        double h = (double)pos.method_10260() + 0.5;
        class_863.method_23107((class_4587)matrices, (class_4597)vertexConsumers, (String)string, (double)f, (double)g, (double)h, (int)color, (float)0.02f, (boolean)true, (float)0.0f, (boolean)true);
    }

    private static void drawString(class_4587 matrices, class_4597 vertexConsumers, class_2374 pos, int offsetY, String string, int color, float size) {
        double f = pos.method_10216() + 0.5;
        double g = pos.method_10214() + 2.4 + (double)offsetY * 0.25;
        double h = pos.method_10215() + 0.5;
        class_863.method_23107((class_4587)matrices, (class_4597)vertexConsumers, (String)string, (double)f, (double)g, (double)h, (int)color, (float)size, (boolean)false, (float)0.5f, (boolean)true);
    }
}

