/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.GullVariant;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.FlightBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetRandomFlightTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetRandomLookTarget;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.control.BirdFloatMoveControl;
import aqario.fowlplay.common.entity.ai.pathing.AmphibiousNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.FowlPlayRegistryKeys;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.FowlPlayTrackedDataHandlerRegistry;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7988;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowParent;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class GullEntity
extends TrustingBirdEntity
implements BirdBrain<GullEntity>,
class_7988<class_6880<GullVariant>> {
    private static final class_2940<class_6880<GullVariant>> VARIANT = class_2945.method_12791(GullEntity.class, FowlPlayTrackedDataHandlerRegistry.GULL_VARIANT);
    public final class_7094 standingState = new class_7094();
    public final class_7094 glidingState = new class_7094();
    public final class_7094 flappingState = new class_7094();
    public final class_7094 floatingState = new class_7094();

    public GullEntity(class_1299<? extends GullEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_4, 0.0f);
        this.method_5941(class_7.field_18, 0.0f);
    }

    @Override
    protected class_1335 createMoveControl() {
        return new BirdFloatMoveControl(this);
    }

    @Override
    public int getMaxPitchChange() {
        return 18;
    }

    @Override
    public int getMaxYawChange() {
        return 18;
    }

    @Override
    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)24, (Object)32);
    }

    @Override
    protected class_1408 getLandNavigation() {
        return new AmphibiousNavigation((class_1308)this, this.method_37908());
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        FowlPlayRegistries.GULL_VARIANT.method_10240(world.method_8409()).ifPresent(this::setVariant);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected boolean canSwim() {
        return true;
    }

    @Override
    public int getFlapFrequency() {
        return 0;
    }

    public static class_5132.class_5133 createGullAttributes() {
        return FlyingBirdEntity.createFlyingBirdAttributes().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, (double)0.225f).method_26868(class_5134.field_23720, (double)0.22f).method_26868(class_5134.field_51578, 0.5);
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_59664();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)FowlPlayRegistries.GULL_VARIANT.method_40290(GullVariant.HERRING));
    }

    public class_6880<GullVariant> getVariant() {
        return (class_6880)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(class_6880<GullVariant> variant) {
        this.field_6011.method_12778(VARIANT, variant);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("variant", this.getVariant().method_40230().orElse(GullVariant.HERRING).method_29177().toString());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        Optional.ofNullable(class_2960.method_12829((String)nbt.method_10558("variant"))).map(variant -> class_5321.method_29179(FowlPlayRegistryKeys.GULL_VARIANT, (class_2960)variant)).flatMap(arg_0 -> FowlPlayRegistries.GULL_VARIANT.method_40264(arg_0)).ifPresent(this::setVariant);
    }

    public boolean method_6109() {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    @Override
    public class_1856 getFood() {
        return class_1856.method_8106(FowlPlayItemTags.GULL_FOOD);
    }

    @Override
    public boolean canHunt(class_1309 target) {
        return target.method_5864().method_20210(FowlPlayEntityTypeTags.GULL_HUNT_TARGETS) || target.method_5864().method_20210(FowlPlayEntityTypeTags.GULL_BABY_HUNT_TARGETS) && target.method_6109();
    }

    @Override
    public boolean shouldAvoid(class_1309 entity) {
        return entity.method_5864().method_20210(FowlPlayEntityTypeTags.GULL_AVOIDS);
    }

    @Override
    public void updateAnimations() {
        this.standingState.method_45317(!this.isFlying() && !this.method_5816(), this.field_6012);
        this.glidingState.method_45317(this.isFlying(), this.field_6012);
        this.floatingState.method_45317(!this.isFlying() && this.method_5816(), this.field_6012);
    }

    protected boolean method_5776() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.8f;
    }

    @Override
    public float getFlapPitch() {
        return 0.6f;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    @Override
    @Nullable
    protected class_3414 getCallSound() {
        return FowlPlaySoundEvents.ENTITY_GULL_CALL.get();
    }

    @Override
    @Nullable
    protected class_3414 getSongSound() {
        return FowlPlaySoundEvents.ENTITY_GULL_LONG_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().gullCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().gullSongVolume;
    }

    @Override
    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return FowlPlaySoundEvents.ENTITY_GULL_HURT.get();
    }

    @Override
    public float getWaterline() {
        return 0.35f;
    }

    @Override
    public CylindricalRadius getWalkRange() {
        return new CylindricalRadius(24, 12);
    }

    protected class_4095.class_5303<GullEntity> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends GullEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor(), new AttackTargetSensor()});
    }

    public BrainActivityGroup<? extends GullEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new class_4097[]{FlightBehaviours.stopFalling(), new SetAttackTarget(), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends GullEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new class_4097[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    public BrainActivityGroup<? extends GullEntity> getFightTasks() {
        return BirdBrain.fightActivity(new class_4097[]{new InvalidateAttackTarget(), FlightBehaviours.startFlying(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(0), CustomBehaviours.forgetUnderwaterAttackTarget()});
    }

    public BrainActivityGroup<? extends GullEntity> getIdleTasks() {
        return BirdBrain.idleActivity(new class_4097[]{new BreedWithPartner(), new FollowParent(), SetEntityLookTarget.create(Birds::isPlayerHoldingFood), new SetRandomLookTarget().lookChance(0.02f)});
    }

    @Override
    public BrainActivityGroup<? extends GullEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new class_4097[]{CustomBehaviours.setNearestFoodWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends GullEntity> getRestTasks() {
        return BirdBrain.restActivity(new class_4097[]{CustomBehaviours.setWaterRestTarget(), CustomBehaviours.idleIfInWater()});
    }

    @Override
    public BrainActivityGroup<GullEntity> getSoarTasks() {
        return BirdBrain.soarActivity(new class_4097[]{new SetRandomFlightTarget().startCondition(entity -> !BrainUtils.hasMemory((class_1309)entity, (class_4140)class_4140.field_18445))});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.SEABIRD.get();
    }

    protected void method_5958() {
        class_4095 brain = this.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        this.tickBrain((class_1309)this);
        if (activity == class_4168.field_22396 && brain.method_24538().orElse(null) != class_4168.field_22396) {
            brain.method_24525(class_4140.field_30246, (Object)true, 2400L);
        }
        super.method_5958();
    }
}

