/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.core;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BlueJayEntity;
import aqario.fowlplay.common.entity.CardinalEntity;
import aqario.fowlplay.common.entity.ChickadeeEntity;
import aqario.fowlplay.common.entity.CrowEntity;
import aqario.fowlplay.common.entity.CustomSpawnGroup;
import aqario.fowlplay.common.entity.DuckEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.GooseEntity;
import aqario.fowlplay.common.entity.GullEntity;
import aqario.fowlplay.common.entity.HawkEntity;
import aqario.fowlplay.common.entity.PenguinEntity;
import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.RavenEntity;
import aqario.fowlplay.common.entity.RobinEntity;
import aqario.fowlplay.common.entity.ScarecrowEntity;
import aqario.fowlplay.common.entity.SparrowEntity;
import aqario.fowlplay.common.util.EntityTypeBuilder;
import aqario.fowlplay.common.world.gen.CustomSpawnLocations;
import aqario.fowlplay.core.platform.PlatformHelper;
import aqario.fowlplay.core.tags.FowlPlayBiomeTags;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_5483;
import net.minecraft.class_6862;

public final class FowlPlayEntityType {
    public static final Supplier<class_1299<BlueJayEntity>> BLUE_JAY = FowlPlayEntityType.register("blue_jay", EntityTypeBuilder.create(BlueJayEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<class_1299<CardinalEntity>> CARDINAL = FowlPlayEntityType.register("cardinal", EntityTypeBuilder.create(CardinalEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<class_1299<ChickadeeEntity>> CHICKADEE = FowlPlayEntityType.register("chickadee", EntityTypeBuilder.create(ChickadeeEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnPasserines).dimensions(0.3f, 0.45f).eyeHeight(0.4f));
    public static final Supplier<class_1299<CrowEntity>> CROW = FowlPlayEntityType.register("crow", EntityTypeBuilder.create(CrowEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(CrowEntity::createCrowAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnPasserines).dimensions(0.5f, 0.6f).eyeHeight(0.55f));
    public static final Supplier<class_1299<DuckEntity>> DUCK = FowlPlayEntityType.register("duck", EntityTypeBuilder.create(DuckEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(DuckEntity::createDuckAttributes).spawnRestriction(CustomSpawnLocations.AQUATIC, class_2902.class_2903.field_13203, FlyingBirdEntity::canSpawnWaterfowl).dimensions(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<class_1299<GooseEntity>> GOOSE = FowlPlayEntityType.register("goose", EntityTypeBuilder.create(GooseEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(GooseEntity::createGooseAttributes).spawnRestriction(CustomSpawnLocations.AQUATIC, class_2902.class_2903.field_13203, FlyingBirdEntity::canSpawnWaterfowl).dimensions(0.7f, 1.1f).eyeHeight(1.0f));
    public static final Supplier<class_1299<GullEntity>> GULL = FowlPlayEntityType.register("gull", EntityTypeBuilder.create(GullEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(GullEntity::createGullAttributes).spawnRestriction(CustomSpawnLocations.SEMIAQUATIC, class_2902.class_2903.field_13203, FlyingBirdEntity::canSpawnShorebirds).dimensions(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<class_1299<HawkEntity>> HAWK = FowlPlayEntityType.register("hawk", EntityTypeBuilder.create(HawkEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(HawkEntity::createHawkAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnPasserines).dimensions(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<class_1299<PenguinEntity>> PENGUIN = FowlPlayEntityType.register("penguin", EntityTypeBuilder.create(PenguinEntity::new, class_1311.field_6294).attributes(PenguinEntity::createPenguinAttributes).spawnRestriction(CustomSpawnLocations.SEMIAQUATIC, class_2902.class_2903.field_13203, PenguinEntity::canSpawnPenguins).dimensions(0.5f, 1.4f).eyeHeight(1.35f).passengerAttachments(new class_243(0.0, 0.75, -0.1)));
    public static final Supplier<class_1299<PigeonEntity>> PIGEON = FowlPlayEntityType.register("pigeon", EntityTypeBuilder.create(PigeonEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(PigeonEntity::createPigeonAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnShorebirds).dimensions(0.5f, 0.6f).eyeHeight(0.5f));
    public static final Supplier<class_1299<RavenEntity>> RAVEN = FowlPlayEntityType.register("raven", EntityTypeBuilder.create(RavenEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(RavenEntity::createRavenAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnPasserines).dimensions(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<class_1299<RobinEntity>> ROBIN = FowlPlayEntityType.register("robin", EntityTypeBuilder.create(RobinEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<class_1299<SparrowEntity>> SPARROW = FowlPlayEntityType.register("sparrow", EntityTypeBuilder.create(SparrowEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, class_2902.class_2903.field_13197, FlyingBirdEntity::canSpawnPasserines).dimensions(0.3f, 0.45f).eyeHeight(0.4f));
    public static final Supplier<class_1299<ScarecrowEntity>> SCARECROW = FowlPlayEntityType.register("scarecrow", EntityTypeBuilder.create(ScarecrowEntity::new, class_1311.field_17715).attributes(ScarecrowEntity::createScarecrowAttributes).dimensions(0.6f, 2.0f).eyeHeight(1.72f));

    private static <T extends class_1297> Supplier<class_1299<T>> register(String id, EntityTypeBuilder<T> builder) {
        return PlatformHelper.registerEntityType(id, () -> builder.build(id));
    }

    public static void init() {
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_BLUE_JAYS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, BLUE_JAY, FowlPlayConfig.getInstance().blueJaySpawnWeight, FowlPlayConfig.getInstance().blueJayMinGroupSize, FowlPlayConfig.getInstance().blueJayMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CARDINALS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, CARDINAL, FowlPlayConfig.getInstance().cardinalSpawnWeight, FowlPlayConfig.getInstance().cardinalMinGroupSize, FowlPlayConfig.getInstance().cardinalMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CHICKADEES, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, CHICKADEE, FowlPlayConfig.getInstance().chickadeeSpawnWeight, FowlPlayConfig.getInstance().chickadeeMinGroupSize, FowlPlayConfig.getInstance().chickadeeMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CROWS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, CROW, FowlPlayConfig.getInstance().crowSpawnWeight, FowlPlayConfig.getInstance().crowMinGroupSize, FowlPlayConfig.getInstance().crowMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_DUCKS, CustomSpawnGroup.BIRDS.spawnGroup, DUCK, FowlPlayConfig.getInstance().duckSpawnWeight, FowlPlayConfig.getInstance().duckMinGroupSize, FowlPlayConfig.getInstance().duckMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_GEESE, CustomSpawnGroup.BIRDS.spawnGroup, GOOSE, FowlPlayConfig.getInstance().gooseSpawnWeight, FowlPlayConfig.getInstance().gooseMinGroupSize, FowlPlayConfig.getInstance().gooseMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_GULLS, CustomSpawnGroup.BIRDS.spawnGroup, GULL, FowlPlayConfig.getInstance().gullSpawnWeight, FowlPlayConfig.getInstance().gullMinGroupSize, FowlPlayConfig.getInstance().gullMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_HAWKS, CustomSpawnGroup.BIRDS.spawnGroup, HAWK, FowlPlayConfig.getInstance().hawkSpawnWeight, FowlPlayConfig.getInstance().hawkMinGroupSize, FowlPlayConfig.getInstance().hawkMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_PENGUINS, class_1311.field_6294, PENGUIN, FowlPlayConfig.getInstance().penguinSpawnWeight, FowlPlayConfig.getInstance().penguinMinGroupSize, FowlPlayConfig.getInstance().penguinMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_PIGEONS, CustomSpawnGroup.BIRDS.spawnGroup, PIGEON, FowlPlayConfig.getInstance().pigeonSpawnWeight, FowlPlayConfig.getInstance().pigeonMinGroupSize, FowlPlayConfig.getInstance().pigeonMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_RAVENS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, RAVEN, FowlPlayConfig.getInstance().ravenSpawnWeight, FowlPlayConfig.getInstance().ravenMinGroupSize, FowlPlayConfig.getInstance().ravenMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_ROBINS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, ROBIN, FowlPlayConfig.getInstance().robinSpawnWeight, FowlPlayConfig.getInstance().robinMinGroupSize, FowlPlayConfig.getInstance().robinMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_SPARROWS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, SPARROW, FowlPlayConfig.getInstance().sparrowSpawnWeight, FowlPlayConfig.getInstance().sparrowMinGroupSize, FowlPlayConfig.getInstance().sparrowMaxGroupSize);
        FowlPlayEntityType.setSpawnCost(FowlPlayBiomeTags.SPAWNS_DUCKS, DUCK, 0.8, 0.1);
        FowlPlayEntityType.setSpawnCost(FowlPlayBiomeTags.SPAWNS_GULLS, GULL, 1.0, 0.07);
    }

    public static <T extends class_1297> void addSpawn(class_6862<class_1959> tag, class_1311 spawnGroup, Supplier<class_1299<T>> type, int weight, int minGroupSize, int maxGroupSize) {
        BiomeModifications.addProperties(context -> context.hasTag(tag), (context, mutable) -> mutable.getSpawnProperties().addSpawn(spawnGroup, new class_5483.class_1964((class_1299)type.get(), weight, minGroupSize, maxGroupSize)));
    }

    public static <T extends class_1297> void setSpawnCost(class_6862<class_1959> tag, Supplier<class_1299<T>> type, double gravityLimit, double mass) {
        BiomeModifications.addProperties(context -> context.hasTag(tag), (context, mutable) -> mutable.getSpawnProperties().setSpawnCost((class_1299)type.get(), new class_5483.class_5265(gravityLimit, mass)));
    }
}

