/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;

public class SmallBubbleParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;
    protected int popAge;
    protected int maxPopAge;
    protected boolean shouldPop;

    public SmallBubbleParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z);
        this.spriteProvider = spriteProvider;
        this.gravity = -0.05f;
        this.friction = 0.95f;
        this.setSize(0.02f, 0.02f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.xd = velocityX * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.yd = velocityY * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.zd = velocityZ * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.lifetime = (int)(30.0 / (Math.random() * 0.8 + 0.2));
        this.maxPopAge = 4;
        this.setSpriteFromAge(spriteProvider);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (!this.removed && !this.level.getFluidState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).is(FluidTags.WATER)) {
            this.shouldPop = true;
        }
        if (this.age++ >= this.lifetime) {
            this.shouldPop = true;
        } else {
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.speedUpWhenYMotionIsBlocked && this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)this.friction;
            this.yd *= (double)this.friction;
            this.zd *= (double)this.friction;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
        if (this.shouldPop && this.popAge++ >= this.maxPopAge) {
            this.remove();
        }
        if (!this.removed) {
            this.setSprite(this.spriteProvider.get(this.popAge, this.maxPopAge));
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new SmallBubbleParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

