/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.brain.task.CompositeTasks;
import aqario.fowlplay.common.entity.ai.brain.task.FlightTasks;
import aqario.fowlplay.common.entity.ai.brain.task.SetEntityLookTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SetPerchWalkTargetTask;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlaySchedules;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.schedule.SmartBrainSchedule;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.Nullable;

public class ChickadeeEntity
extends FlyingBirdEntity
implements BirdBrain<ChickadeeEntity> {
    public final AnimationState standingState = new AnimationState();
    public final AnimationState glidingState = new AnimationState();
    public final AnimationState flappingState = new AnimationState();
    public final AnimationState floatingState = new AnimationState();

    public ChickadeeEntity(EntityType<? extends ChickadeeEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean isBaby() {
        return false;
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.of(FowlPlayItemTags.CHICKADEE_FOOD);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.getType().is(FowlPlayEntityTypeTags.CHICKADEE_AVOIDS);
    }

    @Override
    public int getFlapFrequency() {
        return 7;
    }

    @Override
    protected void updateAnimations() {
        this.standingState.animateWhen(!this.isFlying() && !this.isInWaterOrBubble(), this.tickCount);
        this.flappingState.animateWhen(this.isFlying(), this.tickCount);
        this.floatingState.animateWhen(!this.isFlying() && this.isInWaterOrBubble(), this.tickCount);
    }

    protected boolean isFlapping() {
        return this.isFlying();
    }

    @Override
    public float getFlapVolume() {
        return 0.5f;
    }

    @Override
    public float getFlapPitch() {
        return 1.0f;
    }

    @Override
    public float getWaterline() {
        return 0.35f;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return FowlPlaySoundEvents.ENTITY_CHICKADEE_CALL.get();
    }

    @Override
    @Nullable
    protected SoundEvent getSongSound() {
        return FowlPlaySoundEvents.ENTITY_CHICKADEE_SONG.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().chickadeeCallVolume;
    }

    @Override
    protected float getSongVolume() {
        return FowlPlayConfig.getInstance().chickadeeSongVolume;
    }

    @Override
    public int getCallDelay() {
        return 480;
    }

    @Override
    public int getSongDelay() {
        return 240;
    }

    @Override
    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_CHICKADEE_HURT.get();
    }

    protected Brain.Provider<ChickadeeEntity> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends ChickadeeEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new InWaterSensor(), new AttackedSensor().setScanRate(bird -> 10), new AvoidTargetSensor().setScanRate(bird -> 10)});
    }

    public BrainActivityGroup<? extends ChickadeeEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{new FloatToSurfaceOfFluid(), FlightTasks.stopFalling(), SetEntityLookTargetTask.create(Birds::isPlayerHoldingFood), new LookAtTarget().runForBetween(45, 90), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends ChickadeeEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CompositeTasks.setAvoidEntityWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends ChickadeeEntity> getForageTasks() {
        return BirdBrain.forageActivity(new Behavior[]{new OneRandomBehaviour(new ExtendedBehaviour[]{CompositeTasks.tryForage(), CompositeTasks.tryPerch()})});
    }

    @Override
    public BrainActivityGroup<? extends ChickadeeEntity> getPerchTasks() {
        return BirdBrain.perchActivity(new Behavior[]{CompositeTasks.tryPerch()});
    }

    @Override
    public BrainActivityGroup<? extends ChickadeeEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{CompositeTasks.setNearestFoodWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends ChickadeeEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{new SetPerchWalkTargetTask().startCondition(Predicate.not(Birds::isPerched)), CompositeTasks.idleIfPerched()});
    }

    @Nullable
    public SmartBrainSchedule getSchedule() {
        return FowlPlaySchedules.FORAGER.get();
    }

    protected void customServerAiStep() {
        this.tickBrain((LivingEntity)this);
        super.customServerAiStep();
    }
}

