/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.pathing.FlightNavigation;
import aqario.fowlplay.common.entity.ai.pathing.GroundNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.object.SquareRadius;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class FlyingBirdEntity
extends BirdEntity {
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.defineId(FlyingBirdEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean isFlightNavigation;
    private float prevRoll;
    private float visualRoll;
    public int timeFlying = 0;
    private static final int ROLL_FACTOR = 4;
    private static final float MIN_HEALTH_TO_FLY = 1.5f;
    private static final int MIN_FLIGHT_TIME = 15;

    protected FlyingBirdEntity(EntityType<? extends BirdEntity> entityType, Level world) {
        super(entityType, world);
        this.setNavigation(false);
        this.setPathfindingMalus(PathType.LEAVES, 0.0f);
    }

    public static AttributeSupplier.Builder createFlyingBirdAttributes() {
        return BirdEntity.createBirdAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.28f).add(Attributes.FLYING_SPEED, (double)0.235f);
    }

    private static boolean hasSkyAccess(LevelAccessor world, BlockPos pos) {
        return world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ()) <= pos.getY();
    }

    private static boolean isMidairSpawn(LevelAccessor world, BlockPos pos) {
        return world.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ()) <= pos.getY() - 32 && world.getBlockState(pos.below()).isAir();
    }

    public static boolean canSpawnPasserines(EntityType<? extends BirdEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.getBlockState(pos.below()).getBlock() instanceof LeavesBlock && (Integer)world.getBlockState(pos.below()).getValue((Property)BlockStateProperties.DISTANCE) < 7 || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    public static boolean canSpawnShorebirds(EntityType<? extends BirdEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.getBlockState(pos.below()).is(FowlPlayBlockTags.SHOREBIRDS_SPAWNABLE_ON) || world.getFluidState(pos.below()).is(FluidTags.WATER) || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    public static boolean canSpawnWaterfowl(EntityType<? extends BirdEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return FlyingBirdEntity.hasSkyAccess(world, pos) && (world.getFluidState(pos.below()).is(FluidTags.WATER) || FlyingBirdEntity.isMidairSpawn(world, pos));
    }

    protected PathNavigation createNavigation(Level world) {
        this.setNavigation(this.isFlying());
        return this.navigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("flying", this.isFlying());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setFlying(nbt.getBoolean("flying"));
    }

    protected void onFlap() {
        this.playSound(FowlPlaySoundEvents.ENTITY_BIRD_FLAP.get(), this.getFlapVolume(), this.getFlapPitch());
    }

    public abstract int getFlapFrequency();

    public abstract float getFlapVolume();

    public abstract float getFlapPitch();

    public SquareRadius getWalkRange() {
        return new SquareRadius(16.0, 8.0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.isFlying()) {
                ++this.timeFlying;
                this.setNoGravity(true);
                this.fallDistance = 0.0f;
                if (this.shouldStopFlying()) {
                    this.stopFlying();
                }
            } else {
                this.timeFlying = 0;
                this.setNoGravity(false);
            }
            if (this.isFlying() != this.isFlightNavigation) {
                this.setNavigation(this.isFlying());
            }
        }
        this.prevRoll = this.visualRoll;
        this.visualRoll = this.calculateRoll(this.yRotO, this.getYRot());
    }

    private float calculateRoll(float prevYaw, float currentYaw) {
        float difference = currentYaw - prevYaw;
        if (difference >= 180.0f) {
            difference = 360.0f - difference;
        }
        if (difference < -180.0f) {
            difference = -(360.0f + difference);
        }
        return -difference * 4.0f;
    }

    public float getRoll(float tickDelta) {
        return tickDelta == 1.0f ? this.visualRoll : Mth.lerp((float)tickDelta, (float)this.prevRoll, (float)this.visualRoll);
    }

    protected PathNavigation getLandNavigation() {
        return new GroundNavigation((Mob)this, this.level());
    }

    protected FlightNavigation getFlightNavigation() {
        FlightNavigation navigation = new FlightNavigation(this, this.level());
        navigation.setCanOpenDoors(false);
        navigation.setCanPassDoors(true);
        navigation.setCanFloat(this.canSwim());
        return navigation;
    }

    public int getMaxPitchChange() {
        return 20;
    }

    public int getMaxYawChange() {
        return 20;
    }

    protected boolean canSwim() {
        return false;
    }

    public void setNavigation(boolean isFlying) {
        if (isFlying) {
            this.navigation = this.getFlightNavigation();
            this.isFlightNavigation = true;
        } else {
            this.navigation = this.getLandNavigation();
            this.isFlightNavigation = false;
        }
    }

    public Pair<Integer, Integer> getFlyHeightRange() {
        return Pair.of((Object)5, (Object)10);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        if (!this.isFlying()) {
            return super.getWalkTargetValue(pos, world);
        }
        return this.getFlyingPathfindingFavor(pos, world);
    }

    public float getFlyingPathfindingFavor(BlockPos pos) {
        return this.getFlyingPathfindingFavor(pos, (LevelReader)this.level());
    }

    public float getFlyingPathfindingFavor(BlockPos pos, LevelReader world) {
        return FlyingBirdEntity.magicFunction(pos.getY() - world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ()), this.getFlyHeightRange());
    }

    private static float magicFunction(float posY, Pair<Integer, Integer> flyHeightRange) {
        if (posY < (float)((Integer)flyHeightRange.getFirst()).intValue()) {
            return posY - (float)((Integer)flyHeightRange.getFirst()).intValue();
        }
        if (posY > (float)((Integer)flyHeightRange.getSecond()).intValue()) {
            return (float)((Integer)flyHeightRange.getSecond()).intValue() - posY;
        }
        return 0.0f;
    }

    protected float getFlyingSpeed() {
        return this.isFlying() ? this.getSpeed() : super.getFlyingSpeed();
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return !this.isFlying() && super.causeFallDamage(fallDistance, damageMultiplier, damageSource);
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        if (!this.isFlying()) {
            super.checkFallDamage(heightDifference, onGround, landedState, landedPosition);
        }
    }

    public boolean canStartFlying() {
        return !this.isFlying() && !this.isBelowWaterline() && this.getHealth() >= 1.5f;
    }

    public boolean shouldStopFlying() {
        if (this.isUnderWater()) {
            return true;
        }
        if (this.timeFlying < 15) {
            return false;
        }
        return this.onGround() || this.isBelowWaterline() || this.getHealth() < 1.5f;
    }

    public void startFlying() {
        this.setFlying(true);
        this.setNavigation(true);
    }

    public void stopFlying() {
        this.setFlying(false);
        this.setNavigation(false);
        this.getNavigation().stop();
        Brain brain = this.getBrain();
        brain.eraseMemory(MemoryModuleType.WALK_TARGET);
        if (Birds.isNotFlightless((Entity)this) && Birds.isPerched(this)) {
            this.setDeltaMovement(Vec3.ZERO);
            this.getNavigation().stop();
        }
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(FLYING);
    }

    @VisibleForTesting
    public void setFlying(boolean flying) {
        this.entityData.set(FLYING, (Object)flying);
    }

    protected void playSecondaryStepSound(BlockState state) {
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    protected void playCombinationStepSounds(BlockState primaryState, BlockState secondaryState) {
    }

    @Override
    protected boolean canSing() {
        return Birds.isPerched(this) && super.canSing();
    }

    public void calculateEntityAnimation(boolean flutter) {
        float speed;
        float yDelta = (float)(this.getY() - this.yo);
        float posDelta = !this.isFlying() || yDelta > 0.0f ? (float)Mth.length((double)(this.getX() - this.xo), (double)0.0, (double)(this.getZ() - this.zo)) : (float)Mth.length((double)(this.getX() - this.xo), (double)yDelta, (double)(this.getZ() - this.zo));
        if (this.isFlying()) {
            speed = Math.abs(1.0f - Math.min(posDelta * 0.8f, 1.0f));
            if (yDelta > 0.0f) {
                speed = (float)Math.sqrt(speed * speed + yDelta * yDelta * 4.0f);
            }
        } else {
            speed = Math.min(posDelta * 4.0f, 1.0f);
        }
        this.walkAnimation.update(speed, 0.4f);
    }

    protected void updateWalkAnimation(float posDelta) {
    }

    public void travel(Vec3 movementInput) {
        if (!this.isFlying()) {
            super.travel(movementInput);
            return;
        }
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(this.isBelowWaterline() ? 0.02f : this.getSpeed(), movementInput);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, movementInput);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                float friction = 0.75f;
                this.moveRelative(this.getSpeed(), movementInput);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)friction));
            }
        }
        this.calculateEntityAnimation(false);
    }
}

