/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.core.FowlPlayActivities;
import aqario.fowlplay.core.FowlPlayMemoryModuleType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;

public interface BirdBrain<E extends BirdEntity>
extends SmartBrainOwner<E> {
    default public BrainActivityGroup<? extends E> getAvoidTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getDeliverTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getForageTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getPerchTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getPickupFoodTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getRestTasks() {
        return BrainActivityGroup.empty();
    }

    default public BrainActivityGroup<? extends E> getSoarTasks() {
        return BrainActivityGroup.empty();
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> coreActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(Activity.CORE).priority(0).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> avoidActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(Activity.AVOID).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{FowlPlayMemoryModuleType.IS_AVOIDING.get()});
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> deliverActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.DELIVER.get()).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{FowlPlayMemoryModuleType.RECIPIENT.get()});
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> fightActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(Activity.FIGHT).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{MemoryModuleType.ATTACK_TARGET});
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> forageActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.FORAGE.get()).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> idleActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(Activity.IDLE).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> perchActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.PERCH.get()).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> pickupFoodActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.PICK_UP.get()).priority(10).behaviours(behaviours).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{FowlPlayMemoryModuleType.SEES_FOOD.get()});
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> restActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(Activity.REST).priority(10).behaviours(behaviours);
    }

    @SafeVarargs
    public static <T extends BirdEntity> BrainActivityGroup<T> soarActivity(Behavior<? super T> ... behaviours) {
        return new BrainActivityGroup(FowlPlayActivities.SOAR.get()).priority(10).behaviours(behaviours);
    }

    default public Map<Activity, BrainActivityGroup<? extends E>> getAdditionalTasks() {
        Object2ObjectOpenHashMap taskList = new Object2ObjectOpenHashMap();
        BrainActivityGroup<E> activityGroup = this.getDeliverTasks();
        if (!activityGroup.getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.DELIVER.get(), activityGroup);
        }
        if (!(activityGroup = this.getAvoidTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)Activity.AVOID, activityGroup);
        }
        if (!(activityGroup = this.getPickupFoodTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.PICK_UP.get(), activityGroup);
        }
        if (!(activityGroup = this.getForageTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.FORAGE.get(), activityGroup);
        }
        if (!(activityGroup = this.getSoarTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.SOAR.get(), activityGroup);
        }
        if (!(activityGroup = this.getPerchTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)FowlPlayActivities.PERCH.get(), activityGroup);
        }
        if (!(activityGroup = this.getRestTasks()).getBehaviours().isEmpty()) {
            taskList.put((Object)Activity.REST, activityGroup);
        }
        return taskList;
    }

    default public List<Activity> getActivityPriorities() {
        return ObjectArrayList.of((Object[])new Activity[]{FowlPlayActivities.DELIVER.get(), Activity.AVOID, Activity.FIGHT, FowlPlayActivities.PICK_UP.get(), FowlPlayActivities.FORAGE.get(), FowlPlayActivities.SOAR.get(), FowlPlayActivities.PERCH.get(), Activity.IDLE, Activity.REST});
    }

    default public Set<Activity> getScheduleIgnoringActivities() {
        return ObjectArraySet.of((Object[])new Activity[]{FowlPlayActivities.DELIVER.get(), Activity.AVOID, Activity.FIGHT, FowlPlayActivities.PICK_UP.get()});
    }

    default public Activity getDefaultActivity() {
        return Activity.REST;
    }
}

