/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.task;

import aqario.fowlplay.common.entity.PenguinEntity;
import aqario.fowlplay.common.entity.ai.brain.task.SetWaterWalkTargetTask;
import aqario.fowlplay.common.entity.ai.brain.task.SingleTickBehaviour;
import aqario.fowlplay.common.entity.ai.brain.task.SlideTasks;
import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.AllApplicableBehaviours;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class PenguinSpecificTasks {
    private static final int[][] SWIM_DISTANCES = new int[][]{{31, 15}};

    public static ExtendedBehaviour<PenguinEntity> goToWater() {
        return new AllApplicableBehaviours(new Pair[]{Pair.of(SlideTasks.startSliding(), (Object)1), Pair.of(SetWaterWalkTargetTask.create(32), (Object)2)}).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.HAS_HUNTING_COOLDOWN));
    }

    public static SingleTickBehaviour<PenguinEntity> swim() {
        return PenguinSpecificTasks.swim(PenguinSpecificTasks::findSwimTargetPos, Entity::isInWaterOrBubble);
    }

    private static SingleTickBehaviour<PenguinEntity> swim(Function<PenguinEntity, Vec3> targetGetter, Predicate<PenguinEntity> predicate) {
        return new SingleTickBehaviour<PenguinEntity>((List<Pair<MemoryModuleType<?>, MemoryStatus>>)((Object)MemoryList.create(1).absent((MemoryModuleType<?>)MemoryModuleType.WALK_TARGET)), (BiPredicate<PenguinEntity, Brain<?>>)((BiPredicate<PenguinEntity, Brain>)(bird, brain) -> {
            if (!predicate.test((PenguinEntity)bird)) {
                return false;
            }
            Optional<Vec3> optional = Optional.ofNullable((Vec3)targetGetter.apply((PenguinEntity)bird));
            BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)optional.map(vec3d -> new WalkTarget(vec3d, 1.0f, 0)).orElse(null));
            return true;
        }));
    }

    @Nullable
    private static Vec3 findSwimTargetPos(PathfinderMob entity) {
        Vec3 vec3d = null;
        Vec3 vec3d2 = null;
        for (int[] is : SWIM_DISTANCES) {
            vec3d2 = vec3d == null ? BehaviorUtils.getRandomSwimmablePos((PathfinderMob)entity, (int)is[0], (int)is[1]) : entity.position().add(entity.position().vectorTo(vec3d).normalize().multiply((double)is[0], (double)is[1], (double)is[0]));
            if (vec3d2 == null || entity.level().getFluidState(BlockPos.containing((Position)vec3d2)).isEmpty()) {
                return vec3d;
            }
            vec3d = vec3d2;
        }
        return vec3d2;
    }
}

