/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.task;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.task.SpeedModifiableBehaviour;
import aqario.fowlplay.common.util.MemoryList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetAirTargetTask<E extends BirdEntity>
extends SpeedModifiableBehaviour<E> {
    private static final MemoryList MEMORIES = MemoryList.create(1).registered((MemoryModuleType<?>)MemoryModuleType.WALK_TARGET);

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean shouldRun(ServerLevel world, E bird) {
        return this.shouldKeepRunning(bird);
    }

    protected boolean shouldKeepRunning(E bird) {
        return bird.getAirSupply() < 400;
    }

    protected void tick(E bird) {
        Vec3 targetPos = this.findAir(bird);
        BrainUtils.setMemory(bird, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(targetPos, ((Float)this.speedModifier.apply(bird, targetPos)).floatValue(), 0));
    }

    private Vec3 findAir(E bird) {
        Iterable iterable = BlockPos.betweenClosed((int)Mth.floor((double)(bird.getX() - 1.0)), (int)bird.getBlockY(), (int)Mth.floor((double)(bird.getZ() - 1.0)), (int)Mth.floor((double)(bird.getX() + 1.0)), (int)Mth.floor((double)(bird.getY() + 8.0)), (int)Mth.floor((double)(bird.getZ() + 1.0)));
        BlockPos blockPos = null;
        for (BlockPos blockPos2 : iterable) {
            if (!this.isAirPos((LevelReader)bird.level(), blockPos2)) continue;
            blockPos = blockPos2;
            break;
        }
        if (blockPos == null) {
            blockPos = BlockPos.containing((double)bird.getX(), (double)(bird.getY() + 8.0), (double)bird.getZ());
        }
        return new Vec3((double)blockPos.getX(), (double)(blockPos.getY() + 1), (double)blockPos.getZ());
    }

    private boolean isAirPos(LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return (world.getFluidState(pos).isEmpty() || blockState.is(Blocks.BUBBLE_COLUMN)) && blockState.isPathfindable(PathComputationType.LAND);
    }
}

