/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.control;

import aqario.fowlplay.common.entity.BirdEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;

public class BirdBodyControl
extends BodyRotationControl {
    private final BirdEntity entity;
    private static final int BODY_KEEP_UP_THRESHOLD = 15;
    private float lastHeadYaw;
    private int bodyAdjustTicks;

    public BirdBodyControl(BirdEntity entity) {
        super((Mob)entity);
        this.entity = entity;
    }

    public void clientTick() {
        if (this.isMoving()) {
            this.entity.yBodyRot = this.entity.getYRot();
            this.keepUpHead();
            this.lastHeadYaw = this.entity.yHeadRot;
        } else if (this.isIndependent()) {
            // empty if block
        }
    }

    private void keepUpBody() {
        this.entity.yBodyRot = Mth.rotateIfNecessary((float)this.entity.yBodyRot, (float)this.entity.yHeadRot, (float)this.entity.getMaxHeadYRot());
    }

    private void keepUpHead() {
        this.entity.yHeadRot = Mth.rotateIfNecessary((float)this.entity.yHeadRot, (float)this.entity.yBodyRot, (float)this.entity.getMaxHeadYRot());
    }

    private boolean isIndependent() {
        return !(this.entity.getFirstPassenger() instanceof Mob);
    }

    private boolean isMoving() {
        double e;
        double d = this.entity.getX() - this.entity.xo;
        return d * d + (e = this.entity.getZ() - this.entity.zo) * e > 2.500000277905201E-7;
    }
}

