/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.pathing;

import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.object.SquareRadius;
import org.jetbrains.annotations.Nullable;

public class FlightTargeting {
    @Nullable
    public static Vec3 findPerchOrGround(FlyingBirdEntity entity, SquareRadius perchRange, SquareRadius groundRange) {
        Vec3 perch = FlightTargeting.findPerch(entity, (int)perchRange.xzRadius(), (int)perchRange.yRadius());
        return perch != null ? perch : FlightTargeting.findGround(entity, (int)groundRange.xzRadius(), (int)groundRange.yRadius());
    }

    @Nullable
    public static Vec3 findGround(FlyingBirdEntity entity, int horizontalRange, int verticalRange) {
        boolean bl = GoalUtils.mobRestricted((PathfinderMob)entity, (int)horizontalRange);
        Vec3 target = RandomPos.generateRandomPos(() -> AirAndWaterRandomPos.generateRandomPos((PathfinderMob)entity, (int)horizontalRange, (int)verticalRange, (int)-2, (double)0.0, (double)0.0, (double)Math.PI, (boolean)bl), pos -> 0.0);
        return target == null || target.y > entity.getY() ? null : target;
    }

    @Nullable
    public static Vec3 findPerch(FlyingBirdEntity entity, int horizontalRange, int verticalRange) {
        return FlightTargeting.findPerch(entity, horizontalRange, verticalRange, pos -> 0.0);
    }

    @Nullable
    public static Vec3 findPerch(FlyingBirdEntity entity, int horizontalRange, int verticalRange, ToDoubleFunction<BlockPos> scorer) {
        boolean posTargetInRange = GoalUtils.mobRestricted((PathfinderMob)entity, (int)horizontalRange);
        Vec3 direction = entity.getViewVector(1.0f);
        return RandomPos.generateRandomPos(() -> {
            BlockPos blockPos = RandomPos.generateRandomDirectionWithinRadians((RandomSource)entity.getRandom(), (int)horizontalRange, (int)verticalRange, (int)0, (double)direction.x, (double)direction.z, (double)(Math.PI * 2));
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos2 = FlightTargeting.towardTarget(entity, horizontalRange, posTargetInRange, blockPos);
            if (blockPos2 == null) {
                return null;
            }
            return FlightTargeting.validatePerch(entity, blockPos2);
        }, scorer);
    }

    @Nullable
    public static Vec3 find(FlyingBirdEntity entity, int horizontalRange, int verticalRange) {
        return FlightTargeting.find(entity, horizontalRange, verticalRange, arg_0 -> ((FlyingBirdEntity)entity).getWalkTargetValue(arg_0));
    }

    @Nullable
    public static Vec3 find(FlyingBirdEntity entity, int horizontalRange, int verticalRange, ToDoubleFunction<BlockPos> scorer) {
        boolean posTargetInRange = GoalUtils.mobRestricted((PathfinderMob)entity, (int)horizontalRange);
        Vec3 direction = entity.getViewVector(1.0f);
        double angle = 15.0;
        return RandomPos.generateRandomPos(() -> {
            BlockPos blockPos = RandomPos.generateRandomDirectionWithinRadians((RandomSource)entity.getRandom(), (int)horizontalRange, (int)verticalRange, (int)0, (double)direction.x, (double)direction.z, (double)0.2617993877991494);
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos2 = FlightTargeting.towardTarget(entity, horizontalRange, posTargetInRange, blockPos);
            if (blockPos2 == null) {
                return null;
            }
            return Birds.isPosWithinViewAngle((PathfinderMob)entity, blockPos2, 0.2617993877991494) ? FlightTargeting.validate(entity, blockPos2) : null;
        }, scorer);
    }

    @Nullable
    public static Vec3 findTo(FlyingBirdEntity entity, int horizontalRange, int verticalRange, Vec3 end) {
        Vec3 vec3d = end.subtract(entity.getX(), entity.getY(), entity.getZ());
        boolean bl = GoalUtils.mobRestricted((PathfinderMob)entity, (int)horizontalRange);
        return FlightTargeting.findValid(entity, horizontalRange, verticalRange, vec3d, bl);
    }

    @Nullable
    public static Vec3 findFrom(FlyingBirdEntity entity, int horizontalRange, int verticalRange, Vec3 start) {
        Vec3 vec3d = entity.position().subtract(start);
        boolean bl = GoalUtils.mobRestricted((PathfinderMob)entity, (int)horizontalRange);
        return FlightTargeting.findValid(entity, horizontalRange, verticalRange, vec3d, bl);
    }

    @Nullable
    private static Vec3 findValid(FlyingBirdEntity entity, int horizontalRange, int verticalRange, Vec3 direction, boolean posTargetInRange) {
        return RandomPos.generateRandomPos((PathfinderMob)entity, () -> {
            BlockPos blockPos = RandomPos.generateRandomDirectionWithinRadians((RandomSource)entity.getRandom(), (int)horizontalRange, (int)verticalRange, (int)0, (double)direction.x, (double)direction.z, (double)1.5707963705062866);
            if (blockPos == null) {
                return null;
            }
            BlockPos blockPos2 = FlightTargeting.towardTarget(entity, horizontalRange, posTargetInRange, blockPos);
            return blockPos2 == null ? null : FlightTargeting.validate(entity, blockPos2);
        });
    }

    @Nullable
    public static BlockPos validate(FlyingBirdEntity entity, BlockPos pos) {
        return !GoalUtils.isWater((PathfinderMob)entity, (BlockPos)(pos = RandomPos.moveUpOutOfSolid((BlockPos)pos, (int)entity.level().getMaxBuildHeight(), currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos)))) && !GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)pos) ? pos : null;
    }

    @Nullable
    public static BlockPos validatePerch(FlyingBirdEntity entity, BlockPos pos) {
        return !GoalUtils.isWater((PathfinderMob)entity, (BlockPos)(pos = RandomPos.moveUpOutOfSolid((BlockPos)pos, (int)entity.level().getMaxBuildHeight(), currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) && !entity.level().getBlockState(currentPos).is(FowlPlayBlockTags.PERCHES)))) && !GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)pos) && entity.level().getBlockState(pos).is(FowlPlayBlockTags.PERCHES) ? pos : null;
    }

    @Nullable
    public static BlockPos towardTarget(FlyingBirdEntity entity, int horizontalRange, boolean posTargetInRange, BlockPos relativeInRangePos) {
        BlockPos blockPos = RandomPos.generateRandomPosTowardDirection((PathfinderMob)entity, (int)horizontalRange, (RandomSource)entity.getRandom(), (BlockPos)relativeInRangePos);
        return !GoalUtils.isOutsideLimits((BlockPos)blockPos, (PathfinderMob)entity) && !GoalUtils.isRestricted((boolean)posTargetInRange, (PathfinderMob)entity, (BlockPos)blockPos) && !GoalUtils.isNotStable((PathNavigation)entity.getNavigation(), (BlockPos)blockPos) ? blockPos : null;
    }
}

