/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.network.s2c;

import aqario.fowlplay.client.render.debug.BirdDebugRenderer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record DebugBirdCustomPayload(BirdData birdData) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, DebugBirdCustomPayload> CODEC = CustomPacketPayload.codec(DebugBirdCustomPayload::write, DebugBirdCustomPayload::new);
    public static final CustomPacketPayload.Type<DebugBirdCustomPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fowlplay", (String)"debug/bird"));

    private DebugBirdCustomPayload(FriendlyByteBuf buf) {
        this(new BirdData(buf));
    }

    private void write(FriendlyByteBuf buf) {
        this.birdData.write(buf);
    }

    public static void onReceive(DebugBirdCustomPayload payload) {
        BirdDebugRenderer.INSTANCE.addBird(payload.birdData());
    }

    public CustomPacketPayload.Type<DebugBirdCustomPayload> type() {
        return ID;
    }

    public record BirdData(UUID uuid, int entityId, String name, String moveControl, String navigation, float health, float maxHealth, Vec3 pos, String inventory, @Nullable Path path, List<String> trusting, boolean ambient, boolean perched, List<String> possibleActivities, List<String> runningTasks, List<String> memories, @Nullable String schedule, Set<BlockPos> pois, Set<BlockPos> potentialPois) {
        public BirdData(FriendlyByteBuf buf) {
            this(buf.readUUID(), buf.readInt(), buf.readUtf(), buf.readUtf(), buf.readUtf(), buf.readFloat(), buf.readFloat(), buf.readVec3(), buf.readUtf(), (Path)buf.readNullable(Path::createFromStream), buf.readList(FriendlyByteBuf::readUtf), buf.readBoolean(), buf.readBoolean(), buf.readList(FriendlyByteBuf::readUtf), buf.readList(FriendlyByteBuf::readUtf), buf.readList(FriendlyByteBuf::readUtf), (String)buf.readNullable(FriendlyByteBuf::readUtf), (Set)buf.readCollection(HashSet::new, (StreamDecoder)BlockPos.STREAM_CODEC), (Set)buf.readCollection(HashSet::new, (StreamDecoder)BlockPos.STREAM_CODEC));
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeUUID(this.uuid);
            buf.writeInt(this.entityId);
            buf.writeUtf(this.name);
            buf.writeUtf(this.moveControl);
            buf.writeUtf(this.navigation);
            buf.writeFloat(this.health);
            buf.writeFloat(this.maxHealth);
            buf.writeVec3(this.pos);
            buf.writeUtf(this.inventory);
            buf.writeNullable((Object)this.path, (bufx, path) -> path.writeToStream(bufx));
            buf.writeCollection(this.trusting, FriendlyByteBuf::writeUtf);
            buf.writeBoolean(this.ambient);
            buf.writeBoolean(this.perched);
            buf.writeCollection(this.possibleActivities, FriendlyByteBuf::writeUtf);
            buf.writeCollection(this.runningTasks, FriendlyByteBuf::writeUtf);
            buf.writeCollection(this.memories, FriendlyByteBuf::writeUtf);
            buf.writeNullable((Object)this.schedule, FriendlyByteBuf::writeUtf);
            buf.writeCollection(this.pois, (StreamEncoder)BlockPos.STREAM_CODEC);
            buf.writeCollection(this.potentialPois, (StreamEncoder)BlockPos.STREAM_CODEC);
        }
    }
}

