/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.core;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BlueJayEntity;
import aqario.fowlplay.common.entity.CardinalEntity;
import aqario.fowlplay.common.entity.ChickadeeEntity;
import aqario.fowlplay.common.entity.CrowEntity;
import aqario.fowlplay.common.entity.CustomSpawnGroup;
import aqario.fowlplay.common.entity.DuckEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.GooseEntity;
import aqario.fowlplay.common.entity.GullEntity;
import aqario.fowlplay.common.entity.HawkEntity;
import aqario.fowlplay.common.entity.PenguinEntity;
import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.RavenEntity;
import aqario.fowlplay.common.entity.RobinEntity;
import aqario.fowlplay.common.entity.ScarecrowEntity;
import aqario.fowlplay.common.entity.SparrowEntity;
import aqario.fowlplay.common.util.EntityTypeBuilder;
import aqario.fowlplay.common.world.gen.CustomSpawnLocations;
import aqario.fowlplay.core.platform.PlatformHelper;
import aqario.fowlplay.core.tags.FowlPlayBiomeTags;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public final class FowlPlayEntityType {
    public static final Supplier<EntityType<BlueJayEntity>> BLUE_JAY = FowlPlayEntityType.register("blue_jay", EntityTypeBuilder.create(BlueJayEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<EntityType<CardinalEntity>> CARDINAL = FowlPlayEntityType.register("cardinal", EntityTypeBuilder.create(CardinalEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<EntityType<ChickadeeEntity>> CHICKADEE = FowlPlayEntityType.register("chickadee", EntityTypeBuilder.create(ChickadeeEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.3f, 0.45f).eyeHeight(0.4f));
    public static final Supplier<EntityType<CrowEntity>> CROW = FowlPlayEntityType.register("crow", EntityTypeBuilder.create(CrowEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(CrowEntity::createCrowAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.5f, 0.6f).eyeHeight(0.55f));
    public static final Supplier<EntityType<DuckEntity>> DUCK = FowlPlayEntityType.register("duck", EntityTypeBuilder.create(DuckEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(DuckEntity::createDuckAttributes).spawnRestriction(CustomSpawnLocations.AQUATIC, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnWaterfowl).dimensions(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<EntityType<GooseEntity>> GOOSE = FowlPlayEntityType.register("goose", EntityTypeBuilder.create(GooseEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(GooseEntity::createGooseAttributes).spawnRestriction(CustomSpawnLocations.AQUATIC, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnWaterfowl).dimensions(0.8f, 1.0f).eyeHeight(0.9f));
    public static final Supplier<EntityType<GullEntity>> GULL = FowlPlayEntityType.register("gull", EntityTypeBuilder.create(GullEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(GullEntity::createGullAttributes).spawnRestriction(CustomSpawnLocations.SEMIAQUATIC, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnShorebirds).dimensions(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<EntityType<HawkEntity>> HAWK = FowlPlayEntityType.register("hawk", EntityTypeBuilder.create(HawkEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(HawkEntity::createHawkAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<EntityType<PenguinEntity>> PENGUIN = FowlPlayEntityType.register("penguin", EntityTypeBuilder.create(PenguinEntity::new, MobCategory.CREATURE).attributes(PenguinEntity::createPenguinAttributes).spawnRestriction(CustomSpawnLocations.SEMIAQUATIC, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PenguinEntity::canSpawnPenguins).dimensions(0.5f, 1.4f).eyeHeight(1.35f).passengerAttachments(new Vec3(0.0, 0.75, -0.1)));
    public static final Supplier<EntityType<PigeonEntity>> PIGEON = FowlPlayEntityType.register("pigeon", EntityTypeBuilder.create(PigeonEntity::new, CustomSpawnGroup.BIRDS.spawnGroup).attributes(PigeonEntity::createPigeonAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnShorebirds).dimensions(0.5f, 0.6f).eyeHeight(0.5f));
    public static final Supplier<EntityType<RavenEntity>> RAVEN = FowlPlayEntityType.register("raven", EntityTypeBuilder.create(RavenEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(RavenEntity::createRavenAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<EntityType<RobinEntity>> ROBIN = FowlPlayEntityType.register("robin", EntityTypeBuilder.create(RobinEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<EntityType<SparrowEntity>> SPARROW = FowlPlayEntityType.register("sparrow", EntityTypeBuilder.create(SparrowEntity::new, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnLocations.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).dimensions(0.3f, 0.45f).eyeHeight(0.4f));
    public static final Supplier<EntityType<ScarecrowEntity>> SCARECROW = FowlPlayEntityType.register("scarecrow", EntityTypeBuilder.create(ScarecrowEntity::new, MobCategory.MISC).attributes(ScarecrowEntity::createScarecrowAttributes).dimensions(0.6f, 2.0f).eyeHeight(1.72f));

    private static <T extends Entity> Supplier<EntityType<T>> register(String id, EntityTypeBuilder<T> builder) {
        return PlatformHelper.registerEntityType(id, () -> builder.build(id));
    }

    public static void init() {
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_BLUE_JAYS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, BLUE_JAY, FowlPlayConfig.getInstance().blueJaySpawnWeight, FowlPlayConfig.getInstance().blueJayMinGroupSize, FowlPlayConfig.getInstance().blueJayMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CARDINALS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, CARDINAL, FowlPlayConfig.getInstance().cardinalSpawnWeight, FowlPlayConfig.getInstance().cardinalMinGroupSize, FowlPlayConfig.getInstance().cardinalMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CHICKADEES, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, CHICKADEE, FowlPlayConfig.getInstance().chickadeeSpawnWeight, FowlPlayConfig.getInstance().chickadeeMinGroupSize, FowlPlayConfig.getInstance().chickadeeMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_CROWS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, CROW, FowlPlayConfig.getInstance().crowSpawnWeight, FowlPlayConfig.getInstance().crowMinGroupSize, FowlPlayConfig.getInstance().crowMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_DUCKS, CustomSpawnGroup.BIRDS.spawnGroup, DUCK, FowlPlayConfig.getInstance().duckSpawnWeight, FowlPlayConfig.getInstance().duckMinGroupSize, FowlPlayConfig.getInstance().duckMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_GEESE, CustomSpawnGroup.BIRDS.spawnGroup, GOOSE, FowlPlayConfig.getInstance().gooseSpawnWeight, FowlPlayConfig.getInstance().gooseMinGroupSize, FowlPlayConfig.getInstance().gooseMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_GULLS, CustomSpawnGroup.BIRDS.spawnGroup, GULL, FowlPlayConfig.getInstance().gullSpawnWeight, FowlPlayConfig.getInstance().gullMinGroupSize, FowlPlayConfig.getInstance().gullMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_HAWKS, CustomSpawnGroup.BIRDS.spawnGroup, HAWK, FowlPlayConfig.getInstance().hawkSpawnWeight, FowlPlayConfig.getInstance().hawkMinGroupSize, FowlPlayConfig.getInstance().hawkMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_PENGUINS, MobCategory.CREATURE, PENGUIN, FowlPlayConfig.getInstance().penguinSpawnWeight, FowlPlayConfig.getInstance().penguinMinGroupSize, FowlPlayConfig.getInstance().penguinMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_PIGEONS, CustomSpawnGroup.BIRDS.spawnGroup, PIGEON, FowlPlayConfig.getInstance().pigeonSpawnWeight, FowlPlayConfig.getInstance().pigeonMinGroupSize, FowlPlayConfig.getInstance().pigeonMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_RAVENS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, RAVEN, FowlPlayConfig.getInstance().ravenSpawnWeight, FowlPlayConfig.getInstance().ravenMinGroupSize, FowlPlayConfig.getInstance().ravenMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_ROBINS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, ROBIN, FowlPlayConfig.getInstance().robinSpawnWeight, FowlPlayConfig.getInstance().robinMinGroupSize, FowlPlayConfig.getInstance().robinMaxGroupSize);
        FowlPlayEntityType.addSpawn(FowlPlayBiomeTags.SPAWNS_SPARROWS, CustomSpawnGroup.AMBIENT_BIRDS.spawnGroup, SPARROW, FowlPlayConfig.getInstance().sparrowSpawnWeight, FowlPlayConfig.getInstance().sparrowMinGroupSize, FowlPlayConfig.getInstance().sparrowMaxGroupSize);
        FowlPlayEntityType.setSpawnCost(FowlPlayBiomeTags.SPAWNS_DUCKS, DUCK, 0.8, 0.1);
        FowlPlayEntityType.setSpawnCost(FowlPlayBiomeTags.SPAWNS_GULLS, GULL, 1.0, 0.07);
    }

    public static <T extends Entity> void addSpawn(TagKey<Biome> tag, MobCategory spawnGroup, Supplier<EntityType<T>> type, int weight, int minGroupSize, int maxGroupSize) {
        BiomeModifications.addProperties(context -> context.hasTag(tag), (context, mutable) -> mutable.getSpawnProperties().addSpawn(spawnGroup, new MobSpawnSettings.SpawnerData((EntityType)type.get(), weight, minGroupSize, maxGroupSize)));
    }

    public static <T extends Entity> void setSpawnCost(TagKey<Biome> tag, Supplier<EntityType<T>> type, double gravityLimit, double mass) {
        BiomeModifications.addProperties(context -> context.hasTag(tag), (context, mutable) -> mutable.getSpawnProperties().setSpawnCost((EntityType)type.get(), new MobSpawnSettings.MobSpawnCost(gravityLimit, mass)));
    }
}

