/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.core.platform.neoforge;

import aqario.fowlplay.common.entity.ChickenVariant;
import aqario.fowlplay.common.entity.DuckVariant;
import aqario.fowlplay.common.entity.GooseVariant;
import aqario.fowlplay.common.entity.GullVariant;
import aqario.fowlplay.common.entity.PigeonVariant;
import aqario.fowlplay.common.entity.SparrowVariant;
import aqario.fowlplay.common.entity.ai.brain.ExtendedSchedule;
import aqario.fowlplay.core.FowlPlayRegistryKeys;
import aqario.fowlplay.core.platform.PlatformHelper;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class PlatformHelperImpl {
    public static final Object2ObjectOpenHashMap<Supplier<Item>, ResourceKey<CreativeModeTab>> ITEM_TO_GROUPS = new Object2ObjectOpenHashMap();
    public static final DeferredRegister<ChickenVariant> CHICKEN_VARIANTS = DeferredRegister.create(FowlPlayRegistryKeys.CHICKEN_VARIANT, (String)"fowlplay");
    public static final DeferredRegister<DuckVariant> DUCK_VARIANTS = DeferredRegister.create(FowlPlayRegistryKeys.DUCK_VARIANT, (String)"fowlplay");
    public static final DeferredRegister<GooseVariant> GOOSE_VARIANTS = DeferredRegister.create(FowlPlayRegistryKeys.GOOSE_VARIANT, (String)"fowlplay");
    public static final DeferredRegister<GullVariant> GULL_VARIANTS = DeferredRegister.create(FowlPlayRegistryKeys.GULL_VARIANT, (String)"fowlplay");
    public static final DeferredRegister<PigeonVariant> PIGEON_VARIANTS = DeferredRegister.create(FowlPlayRegistryKeys.PIGEON_VARIANT, (String)"fowlplay");
    public static final DeferredRegister<SparrowVariant> SPARROW_VARIANTS = DeferredRegister.create(FowlPlayRegistryKeys.SPARROW_VARIANT, (String)"fowlplay");
    public static final DeferredRegister<Activity> ACTIVITIES = DeferredRegister.create((Registry)BuiltInRegistries.ACTIVITY, (String)"fowlplay");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"fowlplay");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"fowlplay");
    public static final DeferredRegister<MemoryModuleType<?>> MEMORY_MODULE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MEMORY_MODULE_TYPE, (String)"fowlplay");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"fowlplay");
    public static final DeferredRegister<Schedule> SCHEDULES = DeferredRegister.create((Registry)BuiltInRegistries.SCHEDULE, (String)"fowlplay");
    public static final DeferredRegister<SensorType<?>> SENSOR_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.SENSOR_TYPE, (String)"fowlplay");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"fowlplay");
    public static final ObjectArrayList<Registry<?>> REGISTRIES = new ObjectArrayList();
    public static final DeferredRegister<EntityDataSerializer<?>> TRACKED_DATA_HANDLERS = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)"fowlplay");
    public static final ObjectArrayList<Pair<ModelLayerLocation, Supplier<LayerDefinition>>> MODEL_LAYERS = new ObjectArrayList();
    public static final ObjectArrayList<Pair<Supplier<EntityType<?>>, EntityRendererProvider<?>>> ENTITY_RENDERERS = new ObjectArrayList();

    public static <T> void registerVariant(String id, ResourceKey<T> key, Supplier<T> variant) {
        if (key.isFor(FowlPlayRegistryKeys.CHICKEN_VARIANT)) {
            CHICKEN_VARIANTS.register(id, variant);
        } else if (key.isFor(FowlPlayRegistryKeys.DUCK_VARIANT)) {
            DUCK_VARIANTS.register(id, variant);
        } else if (key.isFor(FowlPlayRegistryKeys.GOOSE_VARIANT)) {
            GOOSE_VARIANTS.register(id, variant);
        } else if (key.isFor(FowlPlayRegistryKeys.GULL_VARIANT)) {
            GULL_VARIANTS.register(id, variant);
        } else if (key.isFor(FowlPlayRegistryKeys.PIGEON_VARIANT)) {
            PIGEON_VARIANTS.register(id, variant);
        } else if (key.isFor(FowlPlayRegistryKeys.SPARROW_VARIANT)) {
            SPARROW_VARIANTS.register(id, variant);
        }
    }

    public static Supplier<Activity> registerActivity(String id, Supplier<Activity> activity) {
        return ACTIVITIES.register(id, activity);
    }

    public static <T extends Entity> Supplier<EntityType<T>> registerEntityType(String id, Supplier<EntityType<T>> entityType) {
        return ENTITY_TYPES.register(id, entityType);
    }

    public static Supplier<Item> registerItem(String id, Supplier<Item> item, ResourceKey<CreativeModeTab> group) {
        DeferredHolder registry = ITEMS.register(id, item);
        PlatformHelper.addItemToItemGroup((Supplier<Item>)registry, group);
        return registry;
    }

    public static <T extends Mob> Supplier<Item> registerSpawnEggItem(String id, Supplier<EntityType<T>> entityType, int backgroundColor, int highlightColor) {
        return PlatformHelperImpl.registerItem(id, () -> new DeferredSpawnEggItem(entityType, backgroundColor, highlightColor, new Item.Properties()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.SPAWN_EGGS);
    }

    public static <T> Supplier<MemoryModuleType<T>> registerMemoryModuleType(String id, Supplier<MemoryModuleType<T>> memoryModuleType) {
        return MEMORY_MODULE_TYPES.register(id, memoryModuleType);
    }

    public static Supplier<SimpleParticleType> registerParticleType(String id, Supplier<SimpleParticleType> particleType) {
        return PARTICLE_TYPES.register(id, particleType);
    }

    public static Supplier<ExtendedSchedule> registerSchedule(String id, Supplier<ExtendedSchedule> schedule) {
        return SCHEDULES.register(id, schedule);
    }

    public static <T extends Sensor<?>> Supplier<SensorType<T>> registerSensorType(String id, Supplier<SensorType<T>> sensorType) {
        return SENSOR_TYPES.register(id, sensorType);
    }

    public static Supplier<SoundEvent> registerSoundEvent(String id, Supplier<SoundEvent> soundEvent) {
        return SOUND_EVENTS.register(id, soundEvent);
    }

    public static <T> Registry<T> registerRegistry(ResourceKey<Registry<T>> registryKey, boolean sync) {
        RegistryBuilder builder = new RegistryBuilder(registryKey);
        if (sync) {
            builder.sync(true);
        }
        Registry registry = builder.create();
        REGISTRIES.add((Object)registry);
        return registry;
    }

    public static <T> void registerTrackedDataHandler(String id, EntityDataSerializer<T> handler) {
        TRACKED_DATA_HANDLERS.register(id, () -> handler);
    }

    public static void addItemToItemGroup(Supplier<Item> item, ResourceKey<CreativeModeTab> itemGroup) {
        ITEM_TO_GROUPS.put(item, itemGroup);
    }

    public static <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> type, EntityRendererProvider<T> provider) {
        ENTITY_RENDERERS.add((Object)Pair.of(type, provider));
    }

    public static void registerModelLayer(ModelLayerLocation location, Supplier<LayerDefinition> definition) {
        MODEL_LAYERS.add((Object)Pair.of((Object)location, definition));
    }

    public static <T extends ParticleOptions> void registerParticleFactory(Supplier<ParticleType<T>> supplier, ParticleProvider<T> provider) {
    }
}

